/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingMessages;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.MembersView;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.NamespacesView;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.StatusBarUpdater;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.TypeInfoComparator;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.TypeInfoSorter;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.ProblemTableViewer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class CBrowsingPart
extends ViewPart
implements IMenuListener,
ISelectionListener,
IViewPartInputProvider {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_LOGICAL_PACKAGE = "logicalPackage";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private LabelProvider fLabelProvider;
    private ILabelProvider fTitleProvider;
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private TypeInfoComparator fTypeComparator;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            CBrowsingPart.this.setSelectionFromEditor(iWorkbenchPartReference);
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
            CBrowsingPart.this.setSelectionFromEditor(iWorkbenchPartReference);
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            CBrowsingPart.this.setSelectionFromEditor(iWorkbenchPartReference);
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == CBrowsingPart.this.getSite().getId()) {
                CBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage iWorkbenchPage = CBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    CBrowsingPart.this.selectionChanged(iWorkbenchPage.getActivePart(), iWorkbenchPage.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference != null && iWorkbenchPartReference.getId() == CBrowsingPart.this.getSite().getId()) {
                CBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CBrowsingPart() {
        this.initLinkingEnabled();
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.fMemento = iMemento;
    }

    public void saveState(IMemento iMemento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                iMemento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(iMemento);
        }
        this.saveSelectionState(iMemento);
        this.saveLinkingEnabled(iMemento);
    }

    private void saveLinkingEnabled(IMemento iMemento) {
        iMemento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    private void saveSelectionState(IMemento iMemento) {
    }

    protected void restoreState(IMemento iMemento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(iMemento);
        }
        if (this.fHasCustomFilter || this.fHasWorkingSetFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private ISelection restoreSelectionState(IMemento iMemento) {
        return null;
    }

    private void restoreLinkingEnabled(IMemento iMemento) {
        Integer n = iMemento.getInteger(this.getLinkToEditorKey());
        if (n != null) {
            this.fLinkingEnabled = n != 0;
        }
    }

    public void createPartControl(Composite composite) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fTypeComparator = new TypeInfoComparator();
        this.fViewer = this.createViewer(composite);
        this.initDragAndDrop();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setSorter((ViewerSorter)this.createTypeInfoSorter());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        this.addKeyListener();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.createStatusBarUpdater(iStatusLineManager));
        this.hookViewerListeners();
        this.addFilters();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.fMemento = null;
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
        this.setHelp();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        return super.getAdapter(clazz);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, CBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected TypeInfoSorter createTypeInfoSorter() {
        return new TypeInfoSorter();
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager iStatusLineManager) {
        return new StatusBarUpdater(iStatusLineManager);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    protected void initDragAndDrop() {
    }

    protected void fillActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fillToolBar(iToolBarManager);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        iActionBars.updateActionBars();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fWorkingSetFilterActionGroup != null) {
            this.fWorkingSetFilterActionGroup.dispose();
        }
        super.dispose();
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CBrowsingPart.this.handleKeyReleased(keyEvent);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.stateMask != 0) {
            return;
        }
        int n = keyEvent.keyCode;
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        CUIPlugin.createStandardGroups(iMenuManager);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        int n = iStructuredSelection.size();
        Object object = iStructuredSelection.getFirstElement();
        if (n == 1) {
            this.addOpenNewWindowAction(iMenuManager, object);
        }
    }

    private void addOpenNewWindowAction(IMenuManager iMenuManager, Object object) {
        if (object instanceof ICElement) {
            object = ((ICElement)object).getResource();
        }
        if (!(object instanceof IContainer)) {
            return;
        }
    }

    protected void createActions() {
        if (this.fHasWorkingSetFilter) {
            String string = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)string);
            IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CBrowsingPart.this.doWorkingSetChanged(propertyChangeEvent);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(string, this.getShell(), iPropertyChangeListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
    }

    private void doWorkingSetChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("workingSetNameChange".equals(string)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(string)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ICElement) {
            return ((ICElement)object).exists();
        }
        if (object instanceof ITypeInfo) {
            return ((ITypeInfo)object).exists();
        }
        return false;
    }

    protected ICProject findCProject(ICElement iCElement) {
        return iCElement.getCProject();
    }

    protected ICProject findCProject(ITypeInfo iTypeInfo) {
        IProject iProject = iTypeInfo.getEnclosingProject();
        if (iProject != null) {
            try {
                ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
                if (iCProjectArray != null) {
                    int n = 0;
                    while (n < iCProjectArray.length) {
                        ICProject iCProject = iCProjectArray[n];
                        if (iCProject.getProject().equals((Object)iProject)) {
                            return iCProject;
                        }
                        ++n;
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    protected ISourceRoot findSourceRoot(ICElement iCElement) {
        while (iCElement != null) {
            if (iCElement instanceof ISourceRoot) {
                return (ISourceRoot)iCElement;
            }
            if (iCElement instanceof ICProject) {
                return null;
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    protected ISourceRoot findSourceRoot(ITypeInfo iTypeInfo) {
        ICProject iCProject = this.findCProject(iTypeInfo);
        if (iCProject != null) {
            try {
                ISourceRoot[] iSourceRootArray = iCProject.getAllSourceRoots();
                if (iSourceRootArray != null) {
                    int n = 0;
                    while (n < iSourceRootArray.length) {
                        ISourceRoot iSourceRoot = iSourceRootArray[n];
                        if (!this.isProjectSourceRoot(iSourceRoot)) {
                            TypeSearchScope typeSearchScope = new TypeSearchScope();
                            typeSearchScope.add((ICElement)iSourceRoot);
                            if (iTypeInfo.isEnclosed((ITypeSearchScope)typeSearchScope)) {
                                return iSourceRoot;
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    protected boolean isProjectSourceRoot(ISourceRoot iSourceRoot) {
        IResource iResource = iSourceRoot.getResource();
        return iResource instanceof IProject;
    }

    protected boolean isValidNamespace(Object object) {
        ITypeInfo[] iTypeInfoArray;
        ITypeInfo iTypeInfo;
        if (object instanceof ITypeInfo && (iTypeInfo = (ITypeInfo)object).exists() && iTypeInfo.getCElementType() == 61 && (iTypeInfoArray = iTypeInfo.getEnclosedTypes()) != null) {
            int n = 0;
            while (n < iTypeInfoArray.length) {
                if (iTypeInfoArray[n].getCElementType() != 61) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected Object getNamespaceInput(Object object) {
        ICProject iCProject;
        ISourceRoot iSourceRoot;
        ITypeInfo iTypeInfo;
        if (object instanceof ICModel) {
            return null;
        }
        if ((object instanceof ICProject || object instanceof ISourceRoot) && this.exists(object)) {
            return object;
        }
        if (object instanceof ITypeInfo) {
            iTypeInfo = (ITypeInfo)object;
            iSourceRoot = this.findSourceRoot(iTypeInfo);
            if (this.exists(iSourceRoot)) {
                return iSourceRoot;
            }
            iCProject = this.findCProject(iTypeInfo);
            if (this.exists(iCProject)) {
                return iCProject;
            }
        }
        if (object instanceof ICElement) {
            iTypeInfo = (ICElement)object;
            iSourceRoot = this.findSourceRoot((ICElement)iTypeInfo);
            if (this.exists(iSourceRoot)) {
                return iSourceRoot;
            }
            iCProject = this.findCProject((ICElement)iTypeInfo);
            if (this.exists(iCProject)) {
                return iCProject;
            }
        }
        return null;
    }

    private static boolean hasChild(ICElement iCElement, final ICElement iCElement2) {
        final boolean[] blArray = new boolean[1];
        ICElementVisitor iCElementVisitor = new ICElementVisitor(){

            public boolean visit(ICElement iCElement) throws CoreException {
                if (blArray[0]) {
                    return false;
                }
                if (iCElement.equals(iCElement2)) {
                    blArray[0] = true;
                    return false;
                }
                return true;
            }
        };
        try {
            iCElement.accept(iCElementVisitor);
        }
        catch (CoreException coreException) {}
        return blArray[0];
    }

    protected Object getTypesInput(Object object) {
        if (object instanceof ICModel || object instanceof ICProject || object instanceof ISourceRoot) {
            return null;
        }
        if (object instanceof ICElement) {
            ITypeInfo[] iTypeInfoArray;
            TypeSearchScope typeSearchScope = new TypeSearchScope();
            ICElement iCElement = ((ICElement)object).getParent();
            ISourceRoot iSourceRoot = this.findSourceRoot(iCElement);
            if (iSourceRoot != null) {
                typeSearchScope.add((ICElement)iSourceRoot);
            } else {
                iTypeInfoArray = this.findCProject(iCElement);
                if (iTypeInfoArray != null) {
                    typeSearchScope.add((ICElement)iTypeInfoArray);
                }
            }
            iTypeInfoArray = AllTypesCache.getNamespaces((ITypeSearchScope)typeSearchScope, (boolean)true);
            if (iTypeInfoArray != null) {
                int n = 0;
                while (n < iTypeInfoArray.length) {
                    ITypeInfo[] iTypeInfoArray2 = iTypeInfoArray[n].getEnclosedTypes();
                    int n2 = 0;
                    while (n2 < iTypeInfoArray2.length) {
                        ICElement iCElement2;
                        ITypeInfo iTypeInfo = iTypeInfoArray2[n2];
                        if (iTypeInfo.getResolvedReference() != null && (iCElement2 = iTypeInfo.getCElement()) != null && (iCElement2.equals(iCElement) || iCElement2 instanceof IParent && CBrowsingPart.hasChild(iCElement2, iCElement))) {
                            return iTypeInfoArray[n];
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return null;
        }
        if (object instanceof ITypeInfo) {
            ITypeInfo iTypeInfo = (ITypeInfo)object;
            if (iTypeInfo.getCElementType() == 61 && this.exists(iTypeInfo)) {
                return iTypeInfo;
            }
            ITypeInfo iTypeInfo2 = iTypeInfo.getEnclosingType(new int[]{61});
            if (iTypeInfo2 == null) {
                iTypeInfo2 = iTypeInfo.getRootNamespace(true);
            }
            if (this.exists(iTypeInfo2)) {
                return iTypeInfo2;
            }
        }
        return null;
    }

    protected Object getMembersInput(Object object) {
        ITypeInfo iTypeInfo;
        if (object instanceof ICModel || object instanceof ICProject || object instanceof ISourceRoot) {
            return null;
        }
        if (object instanceof ITypeInfo && (iTypeInfo = (ITypeInfo)object).getCElementType() != 61 && this.exists(iTypeInfo)) {
            return iTypeInfo;
        }
        if (object instanceof ICElement) {
            ITypeInfo[] iTypeInfoArray;
            iTypeInfo = new TypeSearchScope();
            ICElement iCElement = ((ICElement)object).getParent();
            ISourceRoot iSourceRoot = this.findSourceRoot(iCElement);
            if (iSourceRoot != null) {
                iTypeInfo.add((ICElement)iSourceRoot);
            } else {
                iTypeInfoArray = this.findCProject(iCElement);
                if (iTypeInfoArray != null) {
                    iTypeInfo.add((ICElement)iTypeInfoArray);
                }
            }
            iTypeInfoArray = AllTypesCache.getNamespaces((ITypeSearchScope)iTypeInfo, (boolean)true);
            if (iTypeInfoArray != null) {
                int n = 0;
                while (n < iTypeInfoArray.length) {
                    ITypeInfo[] iTypeInfoArray2 = iTypeInfoArray[n].getEnclosedTypes();
                    int n2 = 0;
                    while (n2 < iTypeInfoArray2.length) {
                        ICElement iCElement2;
                        ITypeInfo iTypeInfo2 = iTypeInfoArray2[n2];
                        if (iTypeInfo2.getResolvedReference() != null && (iCElement2 = iTypeInfo2.getCElement()) != null && (iCElement2.equals(iCElement) || iCElement2 instanceof IParent && CBrowsingPart.hasChild(iCElement2, iCElement))) {
                            return iTypeInfo2;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return null;
        }
        return null;
    }

    protected abstract boolean isValidElement(Object var1);

    private boolean isInputResetBy(Object object, Object object2, IWorkbenchPart iWorkbenchPart) {
        if (object == null) {
            return iWorkbenchPart == this.fPreviousSelectionProvider;
        }
        if (object2 instanceof ICElement && object instanceof ICElement) {
            return this.getTypeComparator().compare(object, object2) > 0;
        }
        return object instanceof List && iWorkbenchPart instanceof NamespacesView;
    }

    private boolean isInputResetBy(IWorkbenchPart iWorkbenchPart) {
        if (!(iWorkbenchPart instanceof CBrowsingPart)) {
            return true;
        }
        Object object = this.getViewer().getInput();
        Object object2 = ((CBrowsingPart)iWorkbenchPart).getViewer().getInput();
        if (object instanceof Collection) {
            object = ((Collection)object).iterator().next();
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator().next();
        }
        if ((object instanceof ICElement || object instanceof ITypeInfo) && (object2 instanceof ICElement || object2 instanceof ITypeInfo)) {
            return this.getTypeComparator().compare(object2, object) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object object, Object object2) {
        if (object2 instanceof ICElement && object instanceof ICElement) {
            return !object2.equals(object) && this.internalIsAncestorOf((ICElement)object, (ICElement)object2);
        }
        if (object2 instanceof ITypeInfo) {
            ICProject iCProject;
            if ((object instanceof ISourceRoot || object instanceof ICProject || object instanceof ICModel) && (iCProject = ((ICElement)object).getCProject()) != null) {
                IProject iProject = ((ITypeInfo)object2).getEnclosingProject();
                return iProject != null && iProject.equals((Object)iCProject.getProject());
            }
            if (object instanceof ITypeInfo) {
                return ((ITypeInfo)object).encloses((ITypeInfo)object2);
            }
        }
        return false;
    }

    private boolean internalIsAncestorOf(ICElement iCElement, ICElement iCElement2) {
        if (iCElement2 != null) {
            return iCElement2.equals(iCElement) || this.internalIsAncestorOf(iCElement, iCElement2.getParent());
        }
        return false;
    }

    private boolean isSearchResultView(IWorkbenchPart iWorkbenchPart) {
        return false;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.fProcessSelectionEvents || iWorkbenchPart == this || this.isSearchResultView(iWorkbenchPart)) {
            if (iWorkbenchPart == this) {
                this.fPreviousSelectionProvider = iWorkbenchPart;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.needsToProcessSelectionChanged(iWorkbenchPart, iSelection)) {
            return;
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        Object object = this.getSingleElementFromSelection(iSelection);
        if (object != null && (iWorkbenchPart == null || iWorkbenchPart.equals(this.fPreviousSelectionProvider)) && object.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = object;
        Object object2 = this.getViewer().getInput();
        if (object != null && object.equals(object2)) {
            Object object3 = this.findElementToSelect(object);
            if (object3 != null && this.getTypeComparator().compare(object, object3) < 0) {
                this.setSelection((ISelection)new StructuredSelection(object3), true);
            } else if (object3 == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iWorkbenchPart != this.fPreviousSelectionProvider && object != null && !object.equals(object2) && this.isInputResetBy(object, object2, iWorkbenchPart)) {
            if (!this.isAncestorOf(object, object2)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (iSelection.isEmpty() && !this.isInputResetBy(iWorkbenchPart)) {
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        if (object == null && iWorkbenchPart == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = iWorkbenchPart;
            return;
        }
        this.fPreviousSelectionProvider = iWorkbenchPart;
        this.adjustInputAndSetSelection(object);
    }

    void setHasWorkingSetFilter(boolean bl) {
        this.fHasWorkingSetFilter = bl;
    }

    void setHasCustomSetFilter(boolean bl) {
        this.fHasCustomFilter = bl;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    protected void setInput(Object object) {
        this.setViewerInput(object);
        this.updateTitle();
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private void setViewerInput(Object object) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(object);
        this.fProcessSelectionEvents = true;
    }

    protected void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object object) {
        IPath iPath;
        String string = !(object instanceof IResource) ? CElementLabels.getTextLabel(object, 1090519049) : ((iPath = ((IResource)object).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : iPath.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return string;
        }
        iPath = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String string2 = CBrowsingMessages.getFormattedString("CBrowsingPart.toolTip", new String[]{iPath.getName()});
        if (string.length() == 0) {
            return string2;
        }
        return CBrowsingMessages.getFormattedString("CBrowsingPart.toolTip2", new String[]{string, iPath.getName()});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected final void setViewer(StructuredViewer structuredViewer) {
        this.fViewer = structuredViewer;
    }

    protected abstract LabelProvider createLabelProvider();

    protected ILabelProvider createTitleProvider() {
        return new CElementLabelProvider(256);
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected StructuredViewer createViewer(Composite composite) {
        return new ProblemTableViewer(composite, 2);
    }

    protected int getLabelProviderFlags() {
        return 274;
    }

    protected void addFilters() {
    }

    protected abstract IContentProvider createContentProvider();

    protected void setInitialInput() {
        ISelection iSelection = this.getSite().getPage().getSelection();
        Object object = this.getSingleElementFromSelection(iSelection);
        if (!(object instanceof ICElement) && !(object instanceof ITypeInfo) && !((object = this.getSite().getPage().getInput()) instanceof ICElement) && object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = iAdaptable.getAdapter((Class)clazz);
        }
        this.setInput(this.findInputForElement(object));
    }

    protected void setInitialSelection() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        ISelection iSelection = null;
        if (iWorkbenchPage != null) {
            iSelection = iWorkbenchPage.getSelection();
        }
        if (iSelection instanceof ITextSelection && (iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)iWorkbenchPart));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (iSelection == null || iSelection.isEmpty()) {
            iSelection = this.restoreSelectionState(this.fMemento);
        }
        if (iSelection == null || iSelection.isEmpty()) {
            Object object = this.getSite().getPage().getInput();
            if (!(object instanceof ICElement)) {
                if (object instanceof IAdaptable) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    object = object.getAdapter((Class)clazz);
                } else {
                    return;
                }
            }
            iSelection = new StructuredSelection(object);
        }
        this.selectionChanged(null, iSelection);
    }

    protected final void setHelp() {
    }

    protected abstract String getHelpContextId();

    protected abstract String getLinkToEditorKey();

    protected void hookViewerListeners() {
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!CBrowsingPart.this.fProcessSelectionEvents) {
                    return;
                }
                CBrowsingPart.this.fPreviousSelectedElement = CBrowsingPart.this.getSingleElementFromSelection(selectionChangedEvent.getSelection());
                IWorkbenchPage iWorkbenchPage = CBrowsingPart.this.getSite().getPage();
                if (iWorkbenchPage == null) {
                    return;
                }
                if (iWorkbenchPage.equals(CUIPlugin.getActivePage()) && CBrowsingPart.this.equals(iWorkbenchPage.getActivePart())) {
                    CBrowsingPart.this.linkToEditor((IStructuredSelection)selectionChangedEvent.getSelection());
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                ISelection iSelection = openEvent.getSelection();
                if (iSelection != null) {
                    Object object = CBrowsingPart.this.getSingleElementFromSelection(iSelection);
                    if (object instanceof ICElement) {
                        CBrowsingPart.this.openInEditor((ICElement)object);
                    } else if (object instanceof ITypeInfo) {
                        CBrowsingPart.this.openTypeInEditor((ITypeInfo)object);
                    }
                }
            }
        });
    }

    protected void openTypeInEditor(ITypeInfo iTypeInfo) {
        Object object;
        Object object2;
        if (iTypeInfo == iTypeInfo.getCache().getGlobalNamespace()) {
            return;
        }
        ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
        if (iTypeReference == null) {
            object2 = new ITypeInfo[]{iTypeInfo};
            object = new IRunnableWithProgress((ITypeInfo[])object2){
                private final /* synthetic */ ITypeInfo[] val$typesToResolve;
                {
                    this.val$typesToResolve = iTypeInfoArray;
                }

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.resolveTypeLocation((ITypeInfo)this.val$typesToResolve[0], (IProgressMonitor)iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
            try {
                iProgressService.busyCursorWhile((IRunnableWithProgress)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String string2 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(invocationTargetException, string, string2);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            iTypeReference = iTypeInfo.getResolvedReference();
        }
        if (iTypeReference == null) {
            object2 = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            object = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", iTypeInfo.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)object2, (String)object);
        } else if (!this.openInEditor(iTypeReference)) {
            object2 = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            object = OpenTypeMessages.getFormattedString("OpenTypeAction.errorOpenEditor", iTypeReference.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)object2, (String)object);
        }
    }

    private boolean openInEditor(ITypeReference iTypeReference) {
        ITranslationUnit iTranslationUnit = iTypeReference.getTranslationUnit();
        IEditorPart iEditorPart = null;
        try {
            IPath iPath;
            if (iTranslationUnit != null) {
                iEditorPart = EditorUtility.openInEditor(iTranslationUnit);
            }
            if (iEditorPart == null && (iPath = iTypeReference.getLocation()) != null) {
                FileStorage fileStorage = new FileStorage(iPath);
                iEditorPart = EditorUtility.openInEditor(fileStorage);
            }
            if (iEditorPart != null && iEditorPart instanceof ITextEditor) {
                iPath = (ITextEditor)iEditorPart;
                iPath.selectAndReveal(iTypeReference.getOffset(), iTypeReference.getLength());
                return true;
            }
        }
        catch (CModelException cModelException) {
            cModelException.printStackTrace();
            return false;
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        return false;
    }

    protected boolean openInEditor(ICElement iCElement) {
        IEditorPart iEditorPart = null;
        try {
            if (iCElement != null) {
                iEditorPart = EditorUtility.openInEditor(iCElement);
            }
            if (iEditorPart == null) {
                return false;
            }
        }
        catch (CModelException cModelException) {
            cModelException.printStackTrace();
            return false;
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        if (iCElement != null && iEditorPart instanceof CEditor) {
            CEditor cEditor = (CEditor)iEditorPart;
            cEditor.setSelection(iCElement);
            return true;
        }
        return false;
    }

    void restoreSelection() {
    }

    void adjustInputAndSetSelection(Object object) {
        if (!(object instanceof ICElement) && !(object instanceof ITypeInfo)) {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        Object object2 = this.getSuitableElement(this.findElementToSelect(object));
        Object object3 = this.findInputForElement(object);
        Object object4 = null;
        if (this.getInput() instanceof ICElement || this.getInput() instanceof ITypeInfo) {
            object4 = this.getInput();
        }
        if (object2 == null && !this.isValidInput(object3) && object3 == null && !this.isAncestorOf(object, object4)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(object2, object4, object3)) {
            this.setInput(object3);
            object2 = this.getSuitableElement(object2);
        }
        if (object2 != null) {
            this.setSelection((ISelection)new StructuredSelection(object2), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    private boolean mustSetNewInput(Object object, Object object2, Object object3) {
        return !(object3 != null && object3.equals(object2) || object != null && object2 != null);
    }

    protected abstract Object findInputForElement(Object var1);

    protected abstract Object findElementToSelect(Object var1);

    Object getSuitableElement(Object object) {
        if (!(object instanceof ICElement) && !(object instanceof ITypeInfo)) {
            return null;
        }
        if (this.fTypeComparator.compare(object, 60) > 0) {
            return object;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Object getSingleElementFromSelection(ISelection iSelection) {
        Object e;
        if (!(iSelection instanceof StructuredSelection)) return null;
        if (iSelection.isEmpty()) {
            return null;
        }
        Iterator iterator = ((StructuredSelection)iSelection).iterator();
        Object e2 = iterator.next();
        if (!(e2 instanceof ICElement) && !(e2 instanceof ITypeInfo)) {
            Class<?> clazz;
            ICElement iCElement;
            if (!(e2 instanceof IAdaptable)) return e2;
            IAdaptable iAdaptable = (IAdaptable)e2;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$1 = clazz3;
            }
            if ((iCElement = (ICElement)iAdaptable.getAdapter((Class)clazz2)) != null) return iCElement;
            if (!(e2 instanceof IFile)) return iCElement;
            IContainer iContainer = ((IFile)e2).getParent();
            if (iContainer == null) return null;
            Class<?> clazz4 = class$1;
            Class<?> clazz5 = clazz4;
            if (clazz4 != null) return (ICElement)iContainer.getAdapter((Class)clazz5);
            try {
                clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$1 = clazz;
            return (ICElement)iContainer.getAdapter((Class)clazz5);
        }
        Object object = this.getViewer().getInput();
        if (object == null || !object.equals(this.findInputForElement(e2))) {
            if (!iterator.hasNext()) return e2;
            return null;
        }
        do {
            if (!iterator.hasNext()) {
                return e2;
            }
            e = iterator.next();
            if (e instanceof ICElement || e instanceof ITypeInfo) continue;
            return null;
        } while (object.equals(this.findInputForElement(e)));
        return null;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof ICElement) {
                EditorUtility.revealInEditor(iEditorPart, (ICElement)object);
            }
        }
    }

    private void setSelectionFromEditor(IWorkbenchPartReference iWorkbenchPartReference) {
        IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
        this.setSelectionFromEditor(iWorkbenchPart);
    }

    void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart) {
        if (!this.linkBrowsingViewSelectionToEditor()) {
            return;
        }
        if (iWorkbenchPart == null) {
            return;
        }
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        if (iWorkbenchPartSite == null) {
            return;
        }
        ISelectionProvider iSelectionProvider = iWorkbenchPartSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.setSelectionFromEditor(iWorkbenchPart, iSelectionProvider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof IEditorPart) {
            Object object;
            ICElement iCElement = null;
            if (iSelection instanceof IStructuredSelection && (object = this.getSingleElementFromSelection(iSelection)) instanceof ICElement) {
                iCElement = (ICElement)object;
            }
            object = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iSelection instanceof ITextSelection) {
                int n = ((ITextSelection)iSelection).getOffset();
                iCElement = this.getElementAt((IEditorInput)object, n);
            }
            if (iCElement != null) {
                this.adjustInputAndSetSelection(iCElement);
                return;
            }
            if (object instanceof IFileEditorInput) {
                IContainer iContainer;
                ICElement iCElement2;
                IFile iFile = ((IFileEditorInput)object).getFile();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iCElement2 = (ICElement)iFile.getAdapter((Class)clazz)) == null && (iContainer = ((IFileEditorInput)object).getFile().getParent()) != null) {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iCElement2 = (ICElement)iContainer.getAdapter((Class)clazz2);
                }
                if (iCElement2 == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(iCElement2);
            }
        }
    }

    Object getElementOfInput(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    protected void setSelection(ISelection iSelection, boolean bl) {
        if (iSelection != null && iSelection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(iSelection, bl);
        this.fProcessSelectionEvents = true;
    }

    protected static ICElement getWorkingCopy(ICElement iCElement) {
        return iCElement;
    }

    protected ICElement getElementAt(IEditorInput iEditorInput, int n) {
        IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy iWorkingCopy = iWorkingCopyManager.getWorkingCopy(iEditorInput);
        if (iWorkingCopy != null) {
            try {
                if (iWorkingCopy.isConsistent()) {
                    return iWorkingCopy.getElementAtOffset(n);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    void setProcessSelectionEvents(boolean bl) {
        this.fProcessSelectionEvents = bl;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        this.fLinkingEnabled = bl;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), bl);
        if (bl && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)iEditorPart);
        }
    }
}

