/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.util.ArrayList;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.StorageLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CUILabelProvider
extends LabelProvider
implements IColorProvider {
    protected static final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(4);
    protected CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private ArrayList fLabelDecorators = null;
    private int fImageFlags;
    private int fTextFlags;

    public CUILabelProvider() {
        this(1, 1);
    }

    public CUILabelProvider(int n, int n2) {
        this.fImageFlags = n2;
        this.fTextFlags = n;
    }

    public void addLabelDecorator(ILabelDecorator iLabelDecorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(iLabelDecorator);
    }

    public final void setTextFlags(int n) {
        this.fTextFlags = n;
    }

    public final void setImageFlags(int n) {
        this.fImageFlags = n;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final int getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object object) {
        return this.getImageFlags();
    }

    protected int evaluateTextFlags(Object object) {
        return this.getTextFlags();
    }

    protected Image decorateImage(Image image, Object object) {
        if (this.fLabelDecorators != null && image != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                image = iLabelDecorator.decorateImage(image, object);
                ++n;
            }
        }
        return image;
    }

    public Image getImage(Object object) {
        if (object instanceof ITypeInfo) {
            return fTypeInfoLabelProvider.getImage(object);
        }
        Image image = this.fImageLabelProvider.getImageLabel(object, this.evaluateImageFlags(object));
        if (image == null && object instanceof IStorage) {
            image = this.fStorageLabelProvider.getImage(object);
        }
        return this.decorateImage(image, object);
    }

    protected String decorateText(String string, Object object) {
        if (this.fLabelDecorators != null && string.length() > 0) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                string = iLabelDecorator.decorateText(string, object);
                ++n;
            }
        }
        return string;
    }

    public String getText(Object object) {
        if (object instanceof ITypeInfo) {
            return fTypeInfoLabelProvider.getText(object);
        }
        String string = CElementLabels.getTextLabel(object, this.evaluateTextFlags(object));
        if (string.length() == 0 && object instanceof IStorage) {
            string = this.fStorageLabelProvider.getText(object);
        }
        return this.decorateText(string, object);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.dispose();
                ++n;
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.addListener(iLabelProviderListener);
                ++n;
            }
        }
        super.addListener(iLabelProviderListener);
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fLabelDecorators != null) {
            int n = 0;
            while (n < this.fLabelDecorators.size()) {
                ILabelDecorator iLabelDecorator = (ILabelDecorator)this.fLabelDecorators.get(n);
                iLabelDecorator.removeListener(iLabelProviderListener);
                ++n;
            }
        }
        super.removeListener(iLabelProviderListener);
    }

    public static ILabelDecorator[] getDecorators(boolean bl, ILabelDecorator iLabelDecorator) {
        if (bl) {
            if (iLabelDecorator == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{iLabelDecorator};
        }
        if (iLabelDecorator != null) {
            return new ILabelDecorator[]{iLabelDecorator};
        }
        return null;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }
}

