/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.ListenerList;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry imageDescriptorRegistry) {
        this.fRegistry = imageDescriptorRegistry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : CUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        int n = this.computeAdornmentFlags(object);
        if (n != 0) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(image);
            Rectangle rectangle = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new CElementImageDescriptor(imageImageDescriptor, n, new Point(rectangle.width, rectangle.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object object) {
        try {
            if (object instanceof ICElement) {
                ICElement iCElement = (ICElement)object;
                int n = iCElement.getElementType();
                switch (n) {
                    case 11: 
                    case 12: {
                        return this.getErrorTicksFromMarkers(iCElement.getResource(), 2, null);
                    }
                }
            } else if (object instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)object, 2, null);
            }
        }
        catch (CoreException coreException) {
            boolean cfr_ignored_0 = coreException instanceof CModelException;
            if (coreException.getStatus().getCode() == 376) {
                return 0;
            }
            CUIPlugin.getDefault().log(coreException);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource iResource, int n, ISourceReference iSourceReference) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, n);
        if (iMarkerArray != null) {
            int n3 = 0;
            while (n3 < iMarkerArray.length && n2 != 64) {
                IMarker iMarker = iMarkerArray[n3];
                if (iSourceReference == null || this.isMarkerInRange(iMarker, iSourceReference)) {
                    int n4 = iMarker.getAttribute("severity", -1);
                    if (n4 == 1) {
                        n2 = 32;
                    } else if (n4 == 2) {
                        n2 = 64;
                    }
                }
                ++n3;
            }
        }
        return n2;
    }

    private boolean isMarkerInRange(IMarker iMarker, ISourceReference iSourceReference) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int n = iMarker.getAttribute("charStart", -1);
            return this.isInside(n, iSourceReference);
        }
        return false;
    }

    private int getErrorTicksFromWorkingCopy(ITranslationUnit iTranslationUnit, ISourceReference iSourceReference) throws CoreException {
        int n = 0;
        new FileEditorInput((IFile)iTranslationUnit.getResource());
        return n;
    }

    private IMarker isAnnotationInRange(IAnnotationModel iAnnotationModel, Annotation annotation, ISourceReference iSourceReference) throws CoreException {
        Position position;
        IMarker iMarker;
        if (annotation instanceof MarkerAnnotation && (iMarker = ((MarkerAnnotation)annotation).getMarker()).exists() && iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker") && (position = iAnnotationModel.getPosition(annotation)) != null && (iSourceReference == null || this.isInside(position.getOffset(), iSourceReference))) {
            return iMarker;
        }
        return null;
    }

    protected boolean isInside(int n, ISourceReference iSourceReference) throws CoreException {
        ISourceRange iSourceRange = iSourceReference.getSourceRange();
        if (iSourceRange != null) {
            int n2 = iSourceRange.getStartPos();
            return n2 <= n && n2 + iSourceRange.getLength() > n;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add(iLabelProviderListener);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(iLabelProviderListener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] iResourceArray, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent problemsLabelChangedEvent = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, iResourceArray, bl);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged((LabelProviderChangedEvent)problemsLabelChangedEvent);
                ++n;
            }
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if (n == 64) {
            iDecoration.addOverlay(CPluginImages.DESC_OVR_ERROR);
        } else if (n == 32) {
            iDecoration.addOverlay(CPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider iBaseLabelProvider, IResource[] iResourceArray, boolean bl) {
            super(iBaseLabelProvider, (Object[])iResourceArray);
            this.fMarkerChange = bl;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

