/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final int LABEL_FLAGS = 202713775;
    private final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(12);
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager iStatusLineManager) {
        this.fStatusLineManager = iStatusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        String string = this.formatMessage(selectionChangedEvent.getSelection());
        this.fStatusLineManager.setMessage(string);
    }

    protected String formatMessage(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            int n = iStructuredSelection.size();
            if (n > 1) {
                return CUIMessages.getFormattedString("StatusBarUpdater.num_elements_selected", String.valueOf(n));
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ICElement) {
                return this.formatCElementMessage((ICElement)object);
            }
            if (object instanceof ITypeInfo) {
                return this.formatTypeInfoMessage((ITypeInfo)object);
            }
            if (object instanceof IResource) {
                return this.formatResourceMessage((IResource)object);
            }
        }
        return "";
    }

    private String formatCElementMessage(ICElement iCElement) {
        return CElementLabels.getElementLabel(iCElement, 202713775);
    }

    private String formatTypeInfoMessage(ITypeInfo iTypeInfo) {
        return this.fTypeInfoLabelProvider.getText(iTypeInfo);
    }

    private String formatResourceMessage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iContainer != null && iContainer.getType() != 8) {
            return String.valueOf(iResource.getName()) + CElementLabels.CONCAT_STRING + iContainer.getFullPath().makeRelative().toString();
        }
        return iResource.getName();
    }
}

