/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeDialog;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction iAction) {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        TypeSearchScope typeSearchScope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)typeSearchScope)) {
            objectArray = new IRunnableWithProgress((ITypeSearchScope)typeSearchScope){
                private final /* synthetic */ ITypeSearchScope val$fScope;
                {
                    this.val$fScope = iTypeSearchScope;
                }

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)this.val$fScope, (IProgressMonitor)iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            object3 = PlatformUI.getWorkbench().getProgressService();
            try {
                object3.busyCursorWhile((IRunnableWithProgress)objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String string2 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(invocationTargetException, string, string2);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if ((objectArray = AllTypesCache.getAllTypes()).length == 0) {
            object3 = OpenTypeMessages.getString("OpenTypeAction.notypes.title");
            String string = OpenTypeMessages.getString("OpenTypeAction.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)object3, (String)string);
            return;
        }
        object3 = new OpenTypeDialog(this.getShell());
        object3.setElements(objectArray);
        int n = object3.open();
        if (n != 0) {
            return;
        }
        ITypeInfo iTypeInfo = (ITypeInfo)object3.getFirstResult();
        if (iTypeInfo == null) {
            return;
        }
        ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
        if (iTypeReference == null) {
            object2 = new ITypeInfo[]{iTypeInfo};
            object = new IRunnableWithProgress((ITypeInfo[])object2){
                private final /* synthetic */ ITypeInfo[] val$typesToResolve;
                {
                    this.val$typesToResolve = iTypeInfoArray;
                }

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.resolveTypeLocation((ITypeInfo)this.val$typesToResolve[0], (IProgressMonitor)iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
            try {
                iProgressService.busyCursorWhile((IRunnableWithProgress)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String string3 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(invocationTargetException, string, string3);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            iTypeReference = iTypeInfo.getResolvedReference();
        }
        if (iTypeReference == null) {
            object2 = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            object = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", iTypeInfo.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)object2, (String)object);
        } else if (!this.openTypeInEditor(iTypeReference)) {
            object2 = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            object = OpenTypeMessages.getFormattedString("OpenTypeAction.errorOpenEditor", iTypeReference.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)object2, (String)object);
        }
    }

    protected Shell getShell() {
        return CUIPlugin.getActiveWorkbenchShell();
    }

    private boolean openTypeInEditor(ITypeReference iTypeReference) {
        ITranslationUnit iTranslationUnit = iTypeReference.getTranslationUnit();
        IEditorPart iEditorPart = null;
        try {
            IPath iPath;
            if (iTranslationUnit != null) {
                iEditorPart = EditorUtility.openInEditor(iTranslationUnit);
            }
            if (iEditorPart == null && (iPath = iTypeReference.getLocation()) != null) {
                FileStorage fileStorage = new FileStorage(iPath);
                iEditorPart = EditorUtility.openInEditor(fileStorage);
            }
            if (iEditorPart != null && iEditorPart instanceof ITextEditor) {
                iPath = (ITextEditor)iEditorPart;
                iPath.selectAndReveal(iTypeReference.getOffset(), iTypeReference.getLength());
                return true;
            }
        }
        catch (CModelException cModelException) {
            cModelException.printStackTrace();
            return false;
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        return false;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

