/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    ListenerList listeners = new ListenerList(1);
    BuildConsole fConsole;
    private Map fConsoleMap = new HashMap();
    private Color infoColor;
    private Color outputColor;
    private Color errorColor;
    private BuildConsoleStream infoStream;
    private BuildConsoleStream outputStream;
    private BuildConsoleStream errorStream;
    public static final int BUILD_STREAM_TYPE_INFO = 0;
    public static final int BUILD_STREAM_TYPE_OUTPUT = 1;
    public static final int BUILD_STREAM_TYPE_ERROR = 2;

    protected void startConsoleActivity(IProject iProject) {
        Object[] objectArray = this.listeners.getListeners();
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                IBuildConsoleListener iBuildConsoleListener = (IBuildConsoleListener)objectArray[n];
                ConsoleEvent consoleEvent = new ConsoleEvent(this, iProject, 1);
                iBuildConsoleListener.consoleChange(consoleEvent);
                ++n;
            }
        }
        this.showConsole();
    }

    protected void showConsole() {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage;
                IWorkbenchWindow iWorkbenchWindow = CUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                    IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.ui.console.ConsoleView");
                    if (iViewPart == null && BuildConsolePreferencePage.isAutoOpenConsole()) {
                        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                        try {
                            iViewPart = iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView");
                        }
                        catch (PartInitException partInitException) {
                            CUIPlugin.getDefault().log(partInitException);
                        }
                        iWorkbenchPage.activate(iWorkbenchPart);
                    } else {
                        boolean bl = BuildConsoleManager.this.shouldBringToTop(iViewPart);
                        if (bl) {
                            iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
                        }
                    }
                    if (iViewPart instanceof IConsoleView) {
                        ((IConsoleView)iViewPart).display((org.eclipse.ui.console.IConsole)BuildConsoleManager.this.fConsole);
                    }
                }
            }
        });
    }

    boolean shouldBringToTop(IViewPart iViewPart) {
        boolean bl = false;
        if (iViewPart instanceof IConsoleView) {
            IConsoleView iConsoleView = (IConsoleView)iViewPart;
            return !iConsoleView.isPinned() && BuildConsolePreferencePage.isConsoleOnTop();
        }
        return bl;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IDocumentPartitioner iDocumentPartitioner;
        IResource iResource = iResourceChangeEvent.getResource();
        if (iResource != null && iResource.getType() == 4 && (iResourceChangeEvent.getType() == 4 || iResourceChangeEvent.getType() == 2) && (iDocumentPartitioner = (IDocumentPartitioner)this.fConsoleMap.remove(iResource)) != null) {
            iDocumentPartitioner.disconnect();
            Object[] objectArray = this.listeners.getListeners();
            if (objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    IBuildConsoleListener iBuildConsoleListener = (IBuildConsoleListener)objectArray[n];
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)iResource, 2);
                    iBuildConsoleListener.consoleChange(consoleEvent);
                    ++n;
                }
            }
        }
    }

    public void shutdown() {
        if (this.infoColor != null) {
            this.infoColor.dispose();
            this.outputColor.dispose();
            this.errorColor.dispose();
        }
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new org.eclipse.ui.console.IConsole[]{this.fConsole});
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void runUI(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void startup() {
        this.infoStream = new BuildConsoleStream();
        this.outputStream = new BuildConsoleStream();
        this.errorStream = new BuildConsoleStream();
        this.runUI(new Runnable(){

            public void run() {
                BuildConsoleManager.this.fConsole = new BuildConsole(BuildConsoleManager.this);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new org.eclipse.ui.console.IConsole[]{BuildConsoleManager.this.fConsole});
                BuildConsoleManager.this.infoStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.infoColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
                BuildConsoleManager.this.infoStream.setColor(BuildConsoleManager.this.infoColor);
                BuildConsoleManager.this.outputStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.outputColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
                BuildConsoleManager.this.outputStream.setColor(BuildConsoleManager.this.outputColor);
                BuildConsoleManager.this.errorStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.errorColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
                BuildConsoleManager.this.errorStream.setColor(BuildConsoleManager.this.errorColor);
            }
        });
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("buildConsoleInfoStreamColor")) {
            Color color = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
            this.infoStream.setColor(color);
            this.infoColor.dispose();
            this.infoColor = color;
        } else if (string.equals("buildConsoleOutputStreamColor")) {
            Color color = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
            this.outputStream.setColor(color);
            this.outputColor.dispose();
            this.outputColor = color;
        } else if (string.equals("buildConsoleErrorStreamColor")) {
            Color color = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
            this.errorStream.setColor(color);
            this.errorColor.dispose();
            this.errorColor = color;
        }
    }

    public BuildConsoleStream getStream(int n) throws CoreException {
        switch (n) {
            case 2: {
                return this.errorStream;
            }
            case 0: {
                return this.infoStream;
            }
            case 1: {
                return this.outputStream;
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", -1, "No Such Console", null));
    }

    private Color createColor(Display display, String string) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)CUIPlugin.getDefault().getPreferenceStore(), (String)string);
        return new Color((Device)display, rGB);
    }

    public IConsole getConsole(IProject iProject) {
        Assert.isNotNull((Object)iProject);
        return this.getConsolePartioner(iProject).getConsole();
    }

    private BuildConsolePartitioner getConsolePartioner(IProject iProject) {
        BuildConsolePartitioner buildConsolePartitioner = (BuildConsolePartitioner)this.fConsoleMap.get(iProject);
        if (buildConsolePartitioner == null) {
            buildConsolePartitioner = new BuildConsolePartitioner(this);
            this.fConsoleMap.put(iProject, buildConsolePartitioner);
        }
        return buildConsolePartitioner;
    }

    public IDocument getConsoleDocument(IProject iProject) {
        Assert.isNotNull((Object)iProject);
        return this.getConsolePartioner(iProject).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener iBuildConsoleListener) {
        this.listeners.add((Object)iBuildConsoleListener);
    }

    public void removeConsoleListener(IBuildConsoleListener iBuildConsoleListener) {
        this.listeners.remove((Object)iBuildConsoleListener);
    }
}

