/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleViewer;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages;
import org.eclipse.cdt.internal.ui.buildconsole.ScrollLockAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleEvent;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.console.actions.TextViewerGotoLineAction;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class BuildConsolePage
extends Page
implements ISelectionListener,
IPropertyChangeListener,
IBuildConsoleListener {
    private BuildConsole fConsole;
    private IConsoleView fConsoleView;
    private BuildConsoleViewer fViewer;
    private IProject fProject;
    private ISelectionChangedListener fTextListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            BuildConsolePage.this.updateSelectionDependentActions();
        }
    };
    private ClearOutputAction fClearOutputAction;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private Menu fMenu;
    private ScrollLockAction fScrollLockAction;
    private boolean fIsLocked;
    static /* synthetic */ Class class$0;

    public BuildConsolePage(IConsoleView iConsoleView, BuildConsole buildConsole) {
        this.fConsole = buildConsole;
        this.fConsoleView = iConsoleView;
    }

    protected void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected BuildConsole getConsole() {
        return this.fConsole;
    }

    protected IDocument setDocument() {
        IProject iProject = this.getProject();
        if (iProject != null) {
            this.getViewer().setDocument(this.getConsole().getConsoleManager().getConsoleDocument(iProject));
        }
        return null;
    }

    public void consoleChange(IBuildConsoleEvent iBuildConsoleEvent) {
        if ((iBuildConsoleEvent.getType() == 1 || iBuildConsoleEvent.getType() == 2) && this.isAvailable()) {
            Display display = this.getControl().getDisplay();
            if (iBuildConsoleEvent.getType() == 2 && this.getProject() != iBuildConsoleEvent.getProject()) {
                return;
            }
            this.setProject(iBuildConsoleEvent.getProject());
            display.asyncExec(new Runnable(){

                public void run() {
                    if (BuildConsolePage.this.isAvailable()) {
                        BuildConsolePage.this.setDocument();
                        BuildConsolePage.this.getConsole().setTitle(BuildConsolePage.this.getProject());
                    }
                }
            });
        }
    }

    boolean isAvailable() {
        return this.getControl() != null;
    }

    public void createControl(Composite composite) {
        this.fViewer = new BuildConsoleViewer(composite);
        MenuManager menuManager = new MenuManager("#MessageConsole", "#MessageConsole");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                BuildConsolePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        this.fMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(this.fMenu);
        IPageSite iPageSite = this.getSite();
        iPageSite.registerContextMenu("org.eclipse.cdt.ui.CBuildConole", menuManager, (ISelectionProvider)this.getViewer());
        iPageSite.setSelectionProvider((ISelectionProvider)this.getViewer());
        this.createActions();
        this.configureToolBar(iPageSite.getActionBars().getToolBarManager());
        this.fViewer.getSelectionProvider().addSelectionChangedListener(this.fTextListener);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.buildconsole.ConsoleFont"));
        this.setTabs(CUIPlugin.getDefault().getPluginPreferences().getInt("buildConsoleTabWith"));
        this.getConsole().addPropertyChangeListener(this);
        this.setDocument();
        this.getConsole().setTitle(this.getProject());
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        iMenuManager.add((IContributionItem)new Separator("FIND"));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        iMenuManager.add((IAction)this.fGlobalActions.get("GotoLine"));
        iMenuManager.add((IAction)this.fClearOutputAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getProperty();
        if ("org.eclipse.cdt.ui.CONSOLE_P_STREAM_COLOR".equals(string) && object instanceof BuildConsoleStream) {
            BuildConsoleStream buildConsoleStream = (BuildConsoleStream)object;
            if (((Object)((Object)buildConsoleStream.getConsole())).equals((Object)this.getConsole()) && this.getControl() != null) {
                Display display = this.getControl().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        BuildConsolePage.this.getViewer().getTextWidget().redraw();
                    }
                });
            } else if (string.equals("org.eclipse.cdt.ui.buildconsole.ConsoleFont")) {
                this.setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.buildconsole.ConsoleFont"));
            } else if (string.equals("buildConsoleTabWith")) {
                this.setTabs(CUIPlugin.getDefault().getPluginPreferences().getInt("buildConsoleTabWith"));
            }
        }
    }

    protected void createActions() {
        this.fClearOutputAction = new ClearOutputAction((ITextViewer)this.getViewer());
        this.fScrollLockAction = new ScrollLockAction(this.getViewer());
        this.fScrollLockAction.setChecked(this.fIsLocked);
        this.getViewer().setAutoScroll(!this.fIsLocked);
        IActionBars iActionBars = this.getSite().getActionBars();
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.getViewer(), 4);
        textViewerAction.configureAction(ConsoleMessages.getString("BuildConsolePage.&Copy@Ctrl+C_6"), ConsoleMessages.getString("BuildConsolePage.Copy_7"), ConsoleMessages.getString("BuildConsolePage.Copy_7"));
        textViewerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        textViewerAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        textViewerAction.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setGlobalAction(iActionBars, ActionFactory.COPY.getId(), (IAction)textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.getViewer(), 7);
        textViewerAction.configureAction(ConsoleMessages.getString("BuildConsolePage.Select_&All@Ctrl+A_12"), ConsoleMessages.getString("BuildConsolePage.Select_All"), ConsoleMessages.getString("BuildConsolePage.Select_All"));
        this.setGlobalAction(iActionBars, ActionFactory.SELECT_ALL.getId(), (IAction)textViewerAction);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages");
        this.setGlobalAction(iActionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(resourceBundle, "find_replace_action.", (IWorkbenchPart)this.getConsoleView()));
        textViewerAction = new TextViewerGotoLineAction((ITextViewer)this.getViewer());
        this.setGlobalAction(iActionBars, "GotoLine", (IAction)textViewerAction);
        iActionBars.updateActionBars();
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.appendToGroup("outputGroup", (IAction)this.fScrollLockAction);
        iToolBarManager.appendToGroup("outputGroup", (IAction)this.fClearOutputAction);
    }

    protected BuildConsoleViewer getViewer() {
        return this.fViewer;
    }

    protected IConsoleView getConsoleView() {
        return this.fConsoleView;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getConsole().getConsoleManager().addConsoleListener(this);
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        this.setProject(this.convertSelectionToProject(this.getSite().getPage().getSelection()));
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getConsole().getConsoleManager().addConsoleListener(this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IProject iProject = this.convertSelectionToProject(iSelection);
        IProject iProject2 = this.getProject();
        if (iProject2 == null || iProject != null && !iProject.equals((Object)iProject2)) {
            this.setProject(iProject);
            this.setDocument();
            this.getConsole().setTitle(this.getProject());
        }
    }

    IProject convertSelectionToProject(ISelection iSelection) {
        IAdaptable iAdaptable;
        IProject iProject = null;
        if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
            return iProject;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAdaptable && (iAdaptable = (IAdaptable)object) != null) {
            IResource iResource = null;
            if (iAdaptable instanceof IResource) {
                iResource = (IResource)iAdaptable;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null) {
                iProject = iResource.getProject();
            }
        }
        return iProject;
    }

    public Control getControl() {
        if (this.fViewer != null) {
            return this.fViewer.getControl();
        }
        return null;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
        this.updateSelectionDependentActions();
    }

    protected void setFont(Font font) {
        this.getViewer().getTextWidget().setFont(font);
    }

    protected void setTabs(int n) {
        this.getViewer().getTextWidget().setTabs(n);
    }

    protected void refresh() {
        this.getViewer().refresh();
    }
}

