/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    List fPartitions = new ArrayList(5);
    private int fMaxLines;
    BuildConsoleStream fLastStream = null;
    BuildConsoleDocument fDocument;
    boolean killed;
    BuildConsoleManager fManager;

    public BuildConsolePartitioner(BuildConsoleManager buildConsoleManager) {
        this.fManager = buildConsoleManager;
        this.fMaxLines = BuildConsolePreferencePage.buildConsoleLines();
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.connect((IDocument)this.fDocument);
    }

    public void appendToDocument(final String string, final BuildConsoleStream buildConsoleStream) {
        Runnable runnable = new Runnable(){

            public void run() {
                BuildConsolePartitioner.this.fLastStream = buildConsoleStream;
                try {
                    if (buildConsoleStream == null) {
                        BuildConsolePartitioner.this.fDocument.set(string);
                    } else {
                        BuildConsolePartitioner.this.fDocument.replace(BuildConsolePartitioner.this.fDocument.getLength(), 0, string);
                        BuildConsolePartitioner.this.checkOverflow();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int n) {
        this.fMaxLines = n;
        n = this.fDocument.getNumberOfLines();
        this.checkOverflow();
    }

    public void connect(IDocument iDocument) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.killed = true;
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        return this.documentChanged2(documentEvent) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int n) {
        ITypedRegion iTypedRegion = this.getPartition(n);
        if (iTypedRegion != null) {
            return iTypedRegion.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int n, int n2) {
        if (n == 0 && n2 == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int n3 = n + n2;
        ArrayList<ITypedRegion> arrayList = new ArrayList<ITypedRegion>();
        int n4 = 0;
        while (n4 < this.fPartitions.size()) {
            ITypedRegion iTypedRegion = (ITypedRegion)this.fPartitions.get(n4);
            int n5 = iTypedRegion.getOffset();
            int n6 = n5 + iTypedRegion.getLength();
            if (n >= n5 && n <= n6 || n < n5 && n3 >= n5) {
                arrayList.add(iTypedRegion);
            }
            ++n4;
        }
        return arrayList.toArray(new ITypedRegion[arrayList.size()]);
    }

    public ITypedRegion getPartition(int n) {
        int n2 = 0;
        while (n2 < this.fPartitions.size()) {
            ITypedRegion iTypedRegion = (ITypedRegion)this.fPartitions.get(n2);
            int n3 = iTypedRegion.getOffset();
            int n4 = n3 + iTypedRegion.getLength();
            if (n >= n3 && n < n4) {
                return iTypedRegion;
            }
            ++n2;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent documentEvent) {
        String string = documentEvent.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        this.addPartition(new BuildConsolePartition(this.fLastStream, documentEvent.getOffset(), string.length()));
        ITypedRegion[] iTypedRegionArray = this.computePartitioning(documentEvent.getOffset(), string.length());
        if (iTypedRegionArray.length == 0) {
            return null;
        }
        if (iTypedRegionArray.length == 1) {
            return iTypedRegionArray[0];
        }
        int n = iTypedRegionArray[0].getLength();
        int n2 = 1;
        while (n2 < iTypedRegionArray.length) {
            ITypedRegion iTypedRegion = iTypedRegionArray[n2];
            n += iTypedRegion.getLength();
            ++n2;
        }
        return new Region(iTypedRegionArray[0].getOffset(), n);
    }

    protected void checkOverflow() {
        int n;
        if (this.fMaxLines >= 0 && (n = this.fDocument.getNumberOfLines()) > this.fMaxLines + 1) {
            int n2 = 0;
            try {
                n2 = this.fDocument.getLineOffset(n - this.fMaxLines);
            }
            catch (BadLocationException badLocationException) {}
            ArrayList<BuildConsolePartition> arrayList = new ArrayList<BuildConsolePartition>(this.fPartitions.size());
            Iterator iterator = this.fPartitions.iterator();
            while (iterator.hasNext()) {
                ITypedRegion iTypedRegion = (ITypedRegion)iterator.next();
                if (!(iTypedRegion instanceof BuildConsolePartition)) continue;
                BuildConsolePartition buildConsolePartition = (BuildConsolePartition)iTypedRegion;
                BuildConsolePartition buildConsolePartition2 = null;
                int n3 = iTypedRegion.getOffset();
                if (n3 < n2) {
                    int n4 = n3 + iTypedRegion.getLength();
                    if (n4 >= n2) {
                        int n5 = n4 - n2;
                        buildConsolePartition2 = buildConsolePartition.createNewPartition(0, n5);
                    }
                } else {
                    buildConsolePartition2 = buildConsolePartition.createNewPartition(buildConsolePartition.getOffset() - n2, buildConsolePartition.getLength());
                }
                if (buildConsolePartition2 == null) continue;
                arrayList.add(buildConsolePartition2);
            }
            this.fPartitions = arrayList;
            try {
                this.fDocument.replace(0, n2, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private BuildConsolePartition addPartition(BuildConsolePartition buildConsolePartition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(buildConsolePartition);
        } else {
            int n = this.fPartitions.size() - 1;
            BuildConsolePartition buildConsolePartition2 = (BuildConsolePartition)((Object)this.fPartitions.get(n));
            if (buildConsolePartition2.canBeCombinedWith(buildConsolePartition)) {
                buildConsolePartition = buildConsolePartition2.combineWith(buildConsolePartition);
                this.fPartitions.set(n, buildConsolePartition);
            } else {
                this.fPartitions.add(buildConsolePartition);
            }
        }
        return buildConsolePartition;
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
    }

    public void start(IProject iProject) {
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null);
        }
        this.fManager.startConsoleActivity(iProject);
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(2));
    }

    public class BuildOutputStream
    extends ConsoleOutputStream {
        final BuildConsoleStream fStream;

        public BuildOutputStream(BuildConsoleStream buildConsoleStream) {
            this.fStream = buildConsoleStream;
        }

        public void flush() throws IOException {
            if (this.fBuffer.length() > 0) {
                BuildConsolePartitioner.this.appendToDocument(this.readBuffer(), this.fStream);
            }
            BuildConsolePartitioner.this.fManager.showConsole();
        }

        public void close() throws IOException {
            this.flush();
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            super.write(byArray, n, n2);
            if (this.fBuffer.length() > 4096) {
                this.flush();
            }
        }
    }
}

