/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class BuildConsoleViewer
extends TextViewer
implements LineStyleListener {
    protected InternalDocumentListener fInternalDocumentListener = new InternalDocumentListener();
    private boolean fAutoScroll = true;

    public void setAutoScroll(boolean bl) {
        this.fAutoScroll = bl;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public BuildConsoleViewer(Composite composite) {
        super(composite, BuildConsoleViewer.getSWTStyles());
        this.getTextWidget().setDoubleClickEnabled(true);
        this.getTextWidget().setFont(composite.getFont());
        this.getTextWidget().addLineStyleListener((LineStyleListener)this);
        this.getTextWidget().setEditable(false);
        this.getTextWidget().setWordWrap(true);
    }

    private static int getSWTStyles() {
        int n = 768;
        return n;
    }

    protected void revealEndOfDocument() {
        if (this.isAutoScroll()) {
            IDocument iDocument = this.getDocument();
            int n = iDocument.getNumberOfLines();
            try {
                int n2;
                int n3 = iDocument.getLineOffset(n - 1);
                StyledText styledText = this.getTextWidget();
                if (n3 > 0) {
                    styledText.setCaretOffset(n3);
                    styledText.showSelection();
                }
                if ((n2 = n3 + iDocument.getLineLength(n - 1)) > 0) {
                    styledText.setCaretOffset(n2);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setDocument(IDocument iDocument) {
        IDocument iDocument2 = this.getDocument();
        IDocument iDocument3 = iDocument;
        if (iDocument2 == null && iDocument3 == null) {
            return;
        }
        if (iDocument2 != null) {
            iDocument2.removeDocumentListener((IDocumentListener)this.fInternalDocumentListener);
            if (iDocument2.equals(iDocument3)) {
                iDocument3.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
                return;
            }
        }
        super.setDocument(iDocument3);
        if (iDocument3 != null) {
            this.revealEndOfDocument();
            iDocument3.addDocumentListener((IDocumentListener)this.fInternalDocumentListener);
        }
    }

    protected boolean canPerformFind() {
        return this.getTextWidget() != null && this.getVisibleDocument() != null && this.getVisibleDocument().getLength() > 0;
    }

    public void dispose() {
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        BuildConsolePartitioner buildConsolePartitioner;
        IDocument iDocument = this.getDocument();
        if (iDocument != null && (buildConsolePartitioner = (BuildConsolePartitioner)iDocument.getDocumentPartitioner()) != null) {
            ITypedRegion[] iTypedRegionArray = buildConsolePartitioner.computePartitioning(lineStyleEvent.lineOffset, lineStyleEvent.lineOffset + lineStyleEvent.lineText.length());
            StyleRange[] styleRangeArray = new StyleRange[iTypedRegionArray.length];
            int n = 0;
            while (n < iTypedRegionArray.length) {
                BuildConsolePartition buildConsolePartition = (BuildConsolePartition)iTypedRegionArray[n];
                Color color = buildConsolePartition.getStream().getColor();
                styleRangeArray[n] = new StyleRange(buildConsolePartition.getOffset(), buildConsolePartition.getLength(), color, null);
                ++n;
            }
            lineStyleEvent.styles = styleRangeArray;
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            BuildConsoleViewer.this.revealEndOfDocument();
        }
    }
}

