/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

class CViewDropAdapter
extends PluginDropAdapter
implements IOverwriteQuery {
    protected boolean isCanceled = false;
    protected boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    private static final int typeMask = 3;
    static /* synthetic */ Class class$0;

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        if (FileTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) && dropTargetEvent.detail == 16) {
            dropTargetEvent.detail = 1;
        }
        super.dragEnter(dropTargetEvent);
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        if (this.getCurrentOperation() == 2) {
            this.validateMove(dropTargetEvent);
        }
    }

    private void validateMove(DropTargetEvent dropTargetEvent) {
        ICElement iCElement = null;
        Object object = this.getCurrentTarget();
        if (!(object instanceof ICElement)) {
            return;
        }
        iCElement = (ICElement)object;
        if (!(iCElement instanceof ICContainer) && !(iCElement instanceof ICProject) || iCElement.isReadOnly()) {
            dropTargetEvent.detail = 0;
            return;
        }
        ISelection iSelection = this.getViewer().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)iSelection;
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                IResource iResource;
                ICElement iCElement2;
                ICElement iCElement3;
                Object e = iterator.next();
                if (e instanceof ICElement) {
                    if (e instanceof ICProject) {
                        dropTargetEvent.detail = 0;
                        break;
                    }
                    iCElement3 = (ICElement)e;
                    iCElement2 = iCElement3.getParent();
                    if (!iCElement2.equals(iCElement) && !iCElement3.equals(iCElement) && !iCElement3.equals(iCElement.getParent()) && !iCElement3.isReadOnly()) continue;
                    dropTargetEvent.detail = 0;
                    break;
                }
                if (!(e instanceof IResource)) continue;
                if (e instanceof IProject) {
                    dropTargetEvent.detail = 0;
                    break;
                }
                iCElement3 = (IResource)e;
                iCElement2 = iCElement3.getParent();
                if (!iCElement2.equals((Object)(iResource = iCElement.getResource())) && !iCElement3.equals((Object)iResource) && !iCElement3.equals((Object)iResource.getParent()) && !iCElement3.isReadOnly()) continue;
                dropTargetEvent.detail = 0;
                break;
            }
        }
    }

    protected IStatus error(String string, Throwable throwable) {
        return new Status(4, "org.eclipse.ui", 0, string, throwable);
    }

    protected IStatus error(String string) {
        return this.error(string, null);
    }

    protected IStatus error(IResource iResource, String string) {
        if (this.getCurrentOperation() == 1) {
            return this.error("Can Not Copy", null);
        }
        return this.error("Can Not Move", null);
    }

    protected IContainer getActualTarget(IResource iResource) {
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            return iResource.getParent();
        }
        if (iResource.getType() == 1) {
            return iResource.getParent();
        }
        return (IContainer)iResource;
    }

    protected Display getDisplay() {
        return this.getViewer().getControl().getDisplay();
    }

    protected Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected IStatus info(String string) {
        return new Status(1, "org.eclipse.ui", 0, string, null);
    }

    public CViewDropAdapter(StructuredViewer structuredViewer) {
        super(structuredViewer);
    }

    protected void mergeStatus(MultiStatus multiStatus, IStatus iStatus) {
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
        }
    }

    protected IStatus multiStatus(List list, String string) {
        IStatus[] iStatusArray = new IStatus[list.size()];
        list.toArray(iStatusArray);
        if (iStatusArray.length == 1) {
            return iStatusArray[0];
        }
        return new MultiStatus("org.eclipse.ui", 0, iStatusArray, string, null);
    }

    protected IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, "Ok", null);
    }

    protected void openError(IStatus iStatus) {
        if (iStatus == null) {
            return;
        }
        String string = "Error";
        int n = 6;
        if (!iStatus.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
            return;
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)iStatus.getMessage(), null, (IStatus)iStatusArray[0], (int)n);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
    }

    private IResource[] getSelectedResources() {
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection == null || !(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        IResource[] iResourceArray = iStructuredSelection.iterator();
        while (iResourceArray.hasNext()) {
            Object e = iResourceArray.next();
            IResource iResource = null;
            if (e instanceof IResource) {
                iResource = (IResource)e;
            } else if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource == null || (iResource.getType() & 3) == 0) continue;
            arrayList.add(iResource);
        }
        iResourceArray = new IResource[arrayList.size()];
        arrayList.toArray(iResourceArray);
        return iResourceArray;
    }

    public boolean performDrop(Object object) {
        this.isCanceled = false;
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || object == null) {
            return false;
        }
        boolean bl = false;
        IStatus iStatus = null;
        IResource[] iResourceArray = null;
        TransferData transferData = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = (IResource[])object;
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            iStatus = this.performFileDrop(object);
            bl = iStatus.isOK();
        } else {
            bl = super.performDrop(object);
        }
        if (iResourceArray != null) {
            iStatus = this.getCurrentOperation() == 1 ? this.performResourceCopy(this.getShell(), iResourceArray) : this.performResourceMove(iResourceArray);
        }
        this.openError(iStatus);
        return bl;
    }

    private IStatus performFileDrop(Object object) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, "ProblemI mporting", null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object object2 = this.getCurrentTarget();
        IResource iResource = null;
        if (object2 instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object2;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        final IContainer iContainer = this.getActualTarget(iResource);
        final String[] stringArray = (String[])object;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                CViewDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(CViewDropAdapter.this.getShell());
                copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
            }
        });
        return multiStatus;
    }

    private IStatus performResourceCopy(Shell shell, IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, "Problems Moving", null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object object = this.getCurrentTarget();
        IResource iResource = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(shell);
        copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        return multiStatus;
    }

    private IStatus performResourceMove(IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, "Problems Moving", null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object object = this.getCurrentTarget();
        IResource iResource = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.getShell(), "Move Resource Action", "Move Resource Action");
        iResourceArray = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
        MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.getShell());
        moveFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        return multiStatus;
    }

    public String queryOverwrite(String string) {
        final String[] stringArray = new String[]{"CANCEL"};
        final String string2 = String.valueOf(string) + " " + CUIPlugin.getResourceString("CViewDragNDrop.txt");
        final String[] stringArray2 = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog messageDialog = new MessageDialog(CViewDropAdapter.this.getShell(), "Question", null, string2, 3, stringArray2, 0);
                messageDialog.open();
                int n = messageDialog.getReturnCode();
                String[] stringArray3 = new String[]{"YES", "NO", "ALL", "CANCEL"};
                stringArray[0] = n < 0 ? "CANCEL" : stringArray3[n];
            }
        });
        return stringArray[0];
    }

    public boolean validateDrop(Object object, int n, TransferData transferData) {
        if (n != 0) {
            this.lastValidOperation = n;
        }
        if (FileTransfer.getInstance().isSupportedType(transferData) && this.lastValidOperation != 1) {
            return false;
        }
        if (super.validateDrop(object, n, transferData)) {
            return true;
        }
        return this.validateTarget(object, transferData).isOK();
    }

    private IStatus validateTarget(Object object, TransferData transferData) {
        IResource iResource;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                return this.info("Target Must Be Resource");
            }
            object = iResource;
        }
        if (!(object instanceof IResource)) {
            return this.info("Target Must Be Resource");
        }
        iResource = (IResource)object;
        if (!iResource.isAccessible()) {
            return this.error("Can Not Drop Into Closed Project");
        }
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer.getType() == 8) {
            return this.error("Resources Can Not Be Siblings");
        }
        String string = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (iResourceArray == null) {
                string = "Drop Operation Error Other";
            } else {
                Object object2 = this.lastValidOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                string = object2.validateDestination(iContainer, iResourceArray);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(transferData);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            string = copyFilesAndFoldersOperation.validateImportDestination(iContainer, stringArray);
        }
        if (string != null) {
            return this.error(string);
        }
        return this.ok();
    }
}

