/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.cview.BuildGroup;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.CollapseAllAction;
import org.eclipse.cdt.internal.ui.cview.GotoActionGroup;
import org.eclipse.cdt.internal.ui.cview.OpenFileGroup;
import org.eclipse.cdt.internal.ui.cview.OpenProjectGroup;
import org.eclipse.cdt.internal.ui.cview.RefactorActionGroup;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class MainActionGroup
extends CViewActionGroup {
    AddBookmarkAction addBookmarkAction;
    AddTaskAction addTaskAction;
    PropertyDialogAction propertyDialogAction;
    ImportResourcesAction importAction;
    ExportResourcesAction exportAction;
    OpenIncludeAction openIncludeAction;
    CollapseAllAction collapseAllAction;
    ToggleLinkingAction toggleLinkingAction;
    BuildGroup buildGroup;
    OpenFileGroup openFileGroup;
    GotoActionGroup gotoGroup;
    RefactorActionGroup refactorGroup;
    OpenProjectGroup openProjectGroup;
    WorkingSetFilterActionGroup workingSetGroup;
    CustomFiltersActionGroup fCustomFiltersActionGroup;
    SelectionSearchGroup selectionSearchGroup;
    RefactoringActionGroup refactoringActionGroup;
    static /* synthetic */ Class class$0;

    public MainActionGroup(CView cView) {
        super(cView);
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        this.refactorGroup.handleKeyPressed(keyEvent);
        this.openFileGroup.handleKeyPressed(keyEvent);
        this.openProjectGroup.handleKeyPressed(keyEvent);
        this.gotoGroup.handleKeyPressed(keyEvent);
        this.buildGroup.handleKeyPressed(keyEvent);
    }

    public void handleKeyReleased(KeyEvent keyEvent) {
        this.refactorGroup.handleKeyReleased(keyEvent);
        this.openFileGroup.handleKeyReleased(keyEvent);
        this.openProjectGroup.handleKeyReleased(keyEvent);
        this.gotoGroup.handleKeyReleased(keyEvent);
        this.buildGroup.handleKeyReleased(keyEvent);
    }

    protected void makeActions() {
        TreeViewer treeViewer = this.getCView().getViewer();
        Shell shell = this.getCView().getViewSite().getShell();
        this.openFileGroup = new OpenFileGroup(this.getCView());
        this.openProjectGroup = new OpenProjectGroup(this.getCView());
        this.gotoGroup = new GotoActionGroup(this.getCView());
        this.buildGroup = new BuildGroup(this.getCView());
        this.refactorGroup = new RefactorActionGroup(this.getCView());
        this.openIncludeAction = new OpenIncludeAction((ISelectionProvider)treeViewer);
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("changeWorkingSet".equals(string)) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof IWorkingSet) {
                        MainActionGroup.this.getCView().setWorkingSet((IWorkingSet)object);
                    } else if (object == null) {
                        MainActionGroup.this.getCView().setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, iPropertyChangeListener);
        this.workingSetGroup.setWorkingSet(this.getCView().getWorkingSet());
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.getCView(), (StructuredViewer)this.getCView().getViewer());
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)treeViewer);
        this.importAction = new ImportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.exportAction = new ExportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.collapseAllAction = new CollapseAllAction(this.getCView());
        this.toggleLinkingAction = new ToggleLinkingAction(this.getCView(), CViewMessages.getString("ToggleLinkingAction.label"));
        this.toggleLinkingAction.setToolTipText(CViewMessages.getString("ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/synced.gif"));
        this.selectionSearchGroup = new SelectionSearchGroup((IWorkbenchSite)this.getCView().getSite());
        this.refactoringActionGroup = new RefactoringActionGroup((IWorkbenchSite)this.getCView().getSite(), null);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getCView().getViewer().getSelection();
        IStructuredSelection iStructuredSelection2 = SelectionConverter.convertSelectionToResources((ISelection)iStructuredSelection);
        if (iStructuredSelection2.isEmpty()) {
            new NewWizardMenu(iMenuManager, this.getCView().getSite().getWorkbenchWindow(), false);
            iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
            this.refactoringActionGroup.fillContextMenu(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator());
            this.importAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.importAction);
            this.exportAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.exportAction);
            iMenuManager.add((IContributionItem)new Separator());
            this.addSearchMenu(iMenuManager, iStructuredSelection);
            iMenuManager.add((IContributionItem)new Separator("additions"));
            iMenuManager.add((IContributionItem)new Separator("additions-end"));
            iMenuManager.add((IContributionItem)new Separator());
            return;
        }
        this.addNewMenu(iMenuManager, iStructuredSelection2);
        iMenuManager.add((IContributionItem)new Separator());
        this.gotoGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.openFileGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.buildGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.refactorGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.importAction.selectionChanged(iStructuredSelection2);
        iMenuManager.add((IAction)this.importAction);
        this.exportAction.selectionChanged(iStructuredSelection2);
        iMenuManager.add((IAction)this.exportAction);
        iMenuManager.add((IContributionItem)new Separator());
        this.openProjectGroup.fillContextMenu(iMenuManager);
        this.addBookMarkMenu(iMenuManager, iStructuredSelection2);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        this.addPropertyMenu(iMenuManager, iStructuredSelection2);
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        this.gotoGroup.setContext(actionContext);
        this.openFileGroup.setContext(actionContext);
        this.openProjectGroup.setContext(actionContext);
        this.refactorGroup.setContext(actionContext);
        this.buildGroup.setContext(actionContext);
    }

    void addNewMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        MenuManager menuManager = new MenuManager(CViewMessages.getString("NewWizardsActionGroup.new"));
        new NewWizardMenu((IMenuManager)menuManager, this.getCView().getSite().getWorkbenchWindow(), false);
        iMenuManager.add((IContributionItem)menuManager);
    }

    void addBookMarkMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAdaptable) {
            IResource iResource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IFile) {
                this.addBookmarkAction.selectionChanged(iStructuredSelection);
                iMenuManager.add((IAction)this.addBookmarkAction);
            }
        }
    }

    void addPropertyMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        this.propertyDialogAction.selectionChanged(iStructuredSelection);
        if (this.propertyDialogAction.isApplicableForSelection()) {
            iMenuManager.add((IAction)this.propertyDialogAction);
        }
    }

    void addSearchMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        IAdaptable iAdaptable = (IAdaptable)iStructuredSelection.getFirstElement();
        if (iAdaptable instanceof ITranslationUnit || iAdaptable instanceof ICProject) {
            return;
        }
        if (SelectionSearchGroup.canActionBeAdded((ISelection)iStructuredSelection)) {
            this.selectionSearchGroup.fillContextMenu(iMenuManager);
        }
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        this.openFileGroup.runDefaultAction(iStructuredSelection);
        this.openProjectGroup.runDefaultAction(iStructuredSelection);
        this.gotoGroup.runDefaultAction(iStructuredSelection);
        this.buildGroup.runDefaultAction(iStructuredSelection);
        this.refactorGroup.runDefaultAction(iStructuredSelection);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyDialogAction.setEnabled(iStructuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(iStructuredSelection);
        this.addTaskAction.selectionChanged(iStructuredSelection);
        this.openFileGroup.updateActionBars();
        this.openProjectGroup.updateActionBars();
        this.gotoGroup.updateActionBars();
        this.buildGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workingSetGroup.updateActionBars();
        this.fCustomFiltersActionGroup.updateActionBars();
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        this.workingSetGroup.fillActionBars(iActionBars);
        this.fCustomFiltersActionGroup.fillActionBars(iActionBars);
        this.gotoGroup.fillActionBars(iActionBars);
        this.refactorGroup.fillActionBars(iActionBars);
        this.openFileGroup.fillActionBars(iActionBars);
        this.openProjectGroup.fillActionBars(iActionBars);
        this.buildGroup.fillActionBars(iActionBars);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.toggleLinkingAction);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.toggleLinkingAction);
    }

    public void restoreFilterAndSorterState(IMemento iMemento) {
        this.fCustomFiltersActionGroup.restoreState(iMemento);
    }

    public void saveFilterAndSorterState(IMemento iMemento) {
        this.fCustomFiltersActionGroup.saveState(iMemento);
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }

    public void dispose() {
        this.importAction.dispose();
        this.exportAction.dispose();
        this.refactorGroup.dispose();
        this.openFileGroup.dispose();
        this.openProjectGroup.dispose();
        this.gotoGroup.dispose();
        this.buildGroup.dispose();
        super.dispose();
    }
}

