/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMoveAction;
import org.eclipse.cdt.internal.ui.cview.CViewRenameAction;
import org.eclipse.cdt.internal.ui.cview.CopyAction;
import org.eclipse.cdt.internal.ui.cview.PasteAction;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;

public class RefactorActionGroup
extends CViewActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private CViewRenameAction renameAction;
    private CViewMoveAction moveAction;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(CView cView) {
        super(cView);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection iStructuredSelection2 = SelectionConverter.convertSelectionToResources((ISelection)iStructuredSelection);
        boolean bl = !iStructuredSelection2.isEmpty() && SelectionConverter.allResourcesAreOfType(iStructuredSelection2, 7);
        this.copyAction.selectionChanged(iStructuredSelection2);
        iMenuManager.add((IAction)this.copyAction);
        this.pasteAction.selectionChanged(iStructuredSelection2);
        iMenuManager.add((IAction)this.pasteAction);
        if (bl) {
            this.deleteAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.textActionHandler = new TextActionHandler(iActionBars);
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        iActionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
        } else if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0 && this.renameAction.isEnabled()) {
            this.renameAction.run();
        }
    }

    protected void makeActions() {
        TreeViewer treeViewer = this.getCView().getViewer();
        Shell shell = this.getCView().getSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.pasteAction = new PasteAction(shell, this.clipboard);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.copyAction = new CopyAction(shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.moveAction = new CViewMoveAction(shell, (StructuredViewer)treeViewer);
        this.renameAction = new CViewRenameAction(shell, treeViewer);
        this.deleteAction = new DeleteResourceAction(shell);
        this.deleteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection iStructuredSelection2 = SelectionConverter.convertSelectionToResources((ISelection)iStructuredSelection);
        this.copyAction.selectionChanged(iStructuredSelection2);
        this.pasteAction.selectionChanged(iStructuredSelection2);
        this.deleteAction.selectionChanged(iStructuredSelection2);
        this.moveAction.selectionChanged(iStructuredSelection2);
        this.renameAction.selectionChanged(iStructuredSelection2);
    }
}

