/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionConverter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IStructuredSelection convertSelectionToCElements(ISelection iSelection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iSelection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)iSelection).toArray();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof ICElement) {
                    arrayList.add(object);
                } else if (object instanceof IAdaptable) {
                    ICElement iCElement;
                    IAdaptable iAdaptable = (IAdaptable)object;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iCElement = (ICElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                        arrayList.add(iCElement);
                    }
                }
                ++n;
            }
        }
        return new StructuredSelection(arrayList.toArray());
    }

    public static IStructuredSelection convertSelectionToResources(ISelection iSelection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iSelection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)iSelection).toArray();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IResource) {
                    arrayList.add(object);
                } else if (object instanceof IAdaptable) {
                    IResource iResource;
                    IAdaptable iAdaptable = (IAdaptable)object;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        arrayList.add(iResource);
                    }
                }
                ++n;
            }
        }
        return new StructuredSelection(arrayList.toArray());
    }

    public static boolean allResourcesAreOfType(IStructuredSelection iStructuredSelection, int n) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)e;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                return false;
            }
            if (SelectionConverter.resourceIsType(iResource, n)) continue;
            return false;
        }
        return true;
    }

    public static IStructuredSelection allResources(IStructuredSelection iStructuredSelection, int n) {
        Iterator iterator = iStructuredSelection.iterator();
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return null;
                }
                if (!SelectionConverter.resourceIsType(iResource, n)) continue;
                arrayList.add(iResource);
                continue;
            }
            return null;
        }
        return new StructuredSelection(arrayList);
    }

    public static ICElement getElementAtOffset(ITextEditor iTextEditor) throws CModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(iTextEditor), (ITextSelection)iTextEditor.getSelectionProvider().getSelection());
    }

    public static ICElement getElementAtOffset(ICElement iCElement, ITextSelection iTextSelection) throws CModelException {
        if (iCElement instanceof ITranslationUnit) {
            ITranslationUnit iTranslationUnit;
            ITranslationUnit iTranslationUnit2 = (ITranslationUnit)iCElement;
            if (iTranslationUnit2.isWorkingCopy()) {
                iTranslationUnit = iTranslationUnit2;
                synchronized (iTranslationUnit) {
                    if (iTranslationUnit2 instanceof IWorkingCopy) {
                        ((IWorkingCopy)iTranslationUnit2).reconcile();
                    }
                }
            }
            if ((iTranslationUnit = iTranslationUnit2.getElementAtOffset(iTextSelection.getOffset())) == null) {
                return iCElement;
            }
            return iTranslationUnit;
        }
        return null;
    }

    public static ICElement getInput(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return null;
        }
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
        return iWorkingCopyManager.getWorkingCopy(iEditorInput);
    }

    public static boolean resourceIsType(IResource iResource, int n) {
        return (iResource.getType() & n) != 0;
    }
}

