/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MessageLine
extends CLabel {
    private String fMessageText;
    private String fErrorText;
    private Color fDefaultColor = this.getForeground();
    private RGB fErrorRGB;
    protected Color fErrorColor;
    private static RGB fgErrorRGB = new RGB(200, 0, 0);

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    public String getErrorMessage() {
        return this.fErrorText;
    }

    public String getMessage() {
        return this.fMessageText;
    }

    public MessageLine(Composite composite, int n, RGB rGB) {
        super(composite, n);
        this.fErrorRGB = rGB;
    }

    public MessageLine(Composite composite, int n) {
        super(composite, n);
        this.fErrorRGB = fgErrorRGB;
    }

    public MessageLine(Composite composite) {
        this(composite, 16384);
    }

    public static void setErrorColor(RGB rGB) {
        fgErrorRGB = rGB;
    }

    public void setErrorMessage(String string) {
        this.fErrorText = string;
        if (string == null) {
            this.setMessage(this.fMessageText);
        } else {
            if (this.fErrorColor == null) {
                this.fErrorColor = new Color((Device)this.getDisplay(), this.fErrorRGB);
                this.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        MessageLine.this.fErrorColor.dispose();
                    }
                });
            }
            this.setForeground(this.fErrorColor);
            this.setText(string);
        }
    }

    public void setMessage(String string) {
        this.fMessageText = string;
        if (string == null) {
            string = "";
        }
        if (this.fErrorText == null) {
            this.setForeground(this.fDefaultColor);
            this.setText(string);
        }
    }
}

