/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.dialogs.TabFolderOptionBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractPathOptionBlock
extends TabFolderOptionBlock
implements ICOptionContainer {
    private List fFilteredOut = new ArrayList();
    private StatusInfo fCPathStatus;
    private StatusInfo fBuildPathStatus;
    private ICProject fCurrCProject;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private int fPageIndex;
    private int fPageCount;
    private CPathBasePage fCurrPage;
    private IStatusChangeListener fContext;

    public AbstractPathOptionBlock(IStatusChangeListener iStatusChangeListener, int n) {
        super(false);
        this.fContext = iStatusChangeListener;
        this.fPageIndex = n;
        this.fCPathStatus = new StatusInfo();
        this.fBuildPathStatus = new StatusInfo();
        this.setOptionContainer(this);
    }

    public IPathEntry[] getRawCPath() {
        List list = this.getCPaths();
        int n = list.size();
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>();
        int n2 = 0;
        while (n2 < n) {
            CPElement cPElement = (CPElement)list.get(n2);
            arrayList.add(cPElement.getPathEntry());
            ++n2;
        }
        arrayList.addAll(this.fFilteredOut);
        return arrayList.toArray(new IPathEntry[arrayList.size()]);
    }

    public void init(ICElement iCElement, IPathEntry[] iPathEntryArray) {
        this.setCProject(iCElement.getCProject());
        ArrayList arrayList = null;
        if (iPathEntryArray == null) {
            try {
                iPathEntryArray = this.getCProject().getRawPathEntries();
            }
            catch (CModelException cModelException) {}
        }
        arrayList = iPathEntryArray != null ? this.getFilteredElements(iPathEntryArray, this.getFilteredTypes()) : new ArrayList();
        this.initialize(iCElement, arrayList);
    }

    protected abstract int[] getFilteredTypes();

    protected abstract void initialize(ICElement var1, List var2);

    protected ArrayList getFilteredElements(IPathEntry[] iPathEntryArray, int[] nArray) {
        ArrayList<CPElement> arrayList = new ArrayList<CPElement>();
        this.fFilteredOut.clear();
        int n = 0;
        while (n < iPathEntryArray.length) {
            IPathEntry iPathEntry = iPathEntryArray[n];
            if (this.contains(nArray, iPathEntry.getEntryKind())) {
                arrayList.add(CPElement.createFromExisting(iPathEntry, this.fCurrCProject));
            } else {
                this.fFilteredOut.add(iPathEntry);
            }
            ++n;
        }
        return arrayList;
    }

    private boolean contains(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract List getCPaths();

    private String getEncodedSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getCPaths().size();
        stringBuffer.append('[').append(n).append(']');
        int n2 = 0;
        while (n2 < n) {
            CPElement cPElement = (CPElement)this.getCPaths().get(n2);
            cPElement.appendEncodedSettings(stringBuffer);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean hasChangesInDialog() {
        String string = this.getEncodedSettings();
        return !string.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInCPathFile() {
        IFile iFile = this.fCurrCProject.getProject().getFile(".cdtproject");
        return this.fFileTimeStamp != iFile.getModificationStamp();
    }

    public void initializeTimeStamps() {
        IFile iFile = this.fCurrCProject.getProject().getFile(".cdtproject");
        this.fFileTimeStamp = iFile.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    protected abstract void addTabs();

    protected void setCProject(ICProject iCProject) {
        this.fCurrCProject = iCProject;
    }

    protected ICProject getCProject() {
        return this.fCurrCProject;
    }

    public IProject getProject() {
        return this.fCurrCProject.getProject();
    }

    protected void doStatusLineUpdate() {
        IStatus iStatus = this.findMostSevereStatus();
        this.fContext.statusChanged(iStatus);
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fCPathStatus, this.fBuildPathStatus});
    }

    protected StatusInfo getPathStatus() {
        return this.fCPathStatus;
    }

    public void setCurrentPage(ICOptionPage iCOptionPage) {
        List list;
        super.setCurrentPage(iCOptionPage);
        CPathBasePage cPathBasePage = (CPathBasePage)iCOptionPage;
        if (this.fCurrPage != null && !(list = this.fCurrPage.getSelection()).isEmpty()) {
            cPathBasePage.setSelection(list);
        }
        this.fCurrPage = (CPathBasePage)iCOptionPage;
    }

    public void updateContainer() {
        this.update();
    }

    protected void updateBuildPathStatus() {
        List list = this.getCPaths();
        IPathEntry[] iPathEntryArray = new IPathEntry[list.size()];
        int n = list.size() - 1;
        while (n >= 0) {
            CPElement cPElement = (CPElement)list.get(n);
            iPathEntryArray[n] = cPElement.getPathEntry();
            --n;
        }
        ICModelStatus iCModelStatus = CoreModel.validatePathEntries((ICProject)this.fCurrCProject, (IPathEntry[])iPathEntryArray);
        if (!iCModelStatus.isOK()) {
            this.fBuildPathStatus.setError(iCModelStatus.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    public Preferences getPreferences() {
        return null;
    }

    protected void addPage(CPathBasePage cPathBasePage) {
        this.addTab(cPathBasePage);
        if (this.fPageIndex == this.fPageCount) {
            this.fCurrPage = cPathBasePage;
        }
        ++this.fPageCount;
    }

    protected ICOptionPage getStartPage() {
        if (this.fCurrPage == null) {
            return super.getStartPage();
        }
        return this.fCurrPage;
    }

    protected void internalConfigureCProject(List list, IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        iProgressMonitor.worked(2);
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>(list.size() + this.fFilteredOut.size());
        int n = 0;
        while (n < list.size()) {
            CPElement cPElement = (CPElement)list.get(n);
            IResource iResource = cPElement.getResource();
            if (iResource instanceof IFolder && !iResource.exists()) {
                CoreUtility.createFolder((IFolder)iResource, true, true, null);
            }
            arrayList.add(cPElement.getPathEntry());
            ++n;
        }
        arrayList.addAll(this.fFilteredOut);
        iProgressMonitor.worked(1);
        this.getCProject().setRawPathEntries(arrayList.toArray(new IPathEntry[arrayList.size()]), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 7));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureCProject(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.setTaskName(CPathEntryMessages.getString("CPathsBlock.operationdesc_c"));
        iProgressMonitor.beginTask("", 10);
        try {
            this.internalConfigureCProject(this.getCPaths(), iProgressMonitor);
            this.initializeTimeStamps();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        iProgressMonitor.done();
    }
}

