/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ArchiveFileFilter
extends ViewerFilter {
    private static final String[] fgArchiveExtensions = new String[]{"a", "so", "dll"};
    private List fExcludes;
    private boolean fRecursive;

    public ArchiveFileFilter(IFile[] iFileArray, boolean bl) {
        this.fExcludes = iFileArray != null ? Arrays.asList(iFileArray) : null;
        this.fRecursive = bl;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof IFile) {
            if (this.fExcludes != null && this.fExcludes.contains(object2)) {
                return false;
            }
            return ArchiveFileFilter.isArchivePath(((IFile)object2).getFullPath());
        }
        if (object2 instanceof IContainer) {
            if (!this.fRecursive) {
                return true;
            }
            try {
                IResource[] iResourceArray = ((IContainer)object2).members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (this.select(viewer, object, iResourceArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log(coreException.getStatus());
            }
        }
        return false;
    }

    public static boolean isArchivePath(IPath iPath) {
        String string = iPath.getFileExtension();
        if (string != null && string.length() != 0) {
            return ArchiveFileFilter.isArchiveFileExtension(string);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String string) {
        int n = 0;
        while (n < fgArchiveExtensions.length) {
            if (string.equalsIgnoreCase(fgArchiveExtensions[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

