/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class CPElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String SOURCEATTACHMENTROOT = "rootpath";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUDE = "includepath";
    public static final String LIBRARY = "librarypath";
    public static final String SYSTEM_INCLUDE = "systeminclude";
    public static final String MACRO_NAME = "macroname";
    public static final String MACRO_VALUE = "macrovalue";
    public static final String BASE_REF = "base-ref";
    public static final String BASE = "base-path";
    public static final String PARENT = "parent";
    public static final String PARENT_CONTAINER = "parent-container";
    private final int fEntryKind;
    private final IPath fPath;
    private final ICProject fCProject;
    private final IResource fResource;
    private final ArrayList fChildren = new ArrayList(1);
    private boolean fIsExported;
    private IPathEntry fCachedEntry;
    private CPElement Inherited;
    private IStatus fStatus;

    public CPElement(CPElement cPElement, IPath iPath, IResource iResource) {
        this(cPElement.getCProject(), cPElement.getEntryKind(), iPath, iResource);
        this.setExported(cPElement.isExported());
        this.fChildren.clear();
        int n = 0;
        while (n < cPElement.fChildren.size()) {
            CPElementAttribute cPElementAttribute = (CPElementAttribute)cPElement.fChildren.get(n);
            this.fChildren.add(new CPElementAttribute(this, cPElementAttribute.getKey(), cPElementAttribute.getValue()));
            ++n;
        }
        this.Inherited = cPElement;
    }

    public CPElement(ICProject iCProject, int n, IPath iPath, IResource iResource) {
        this.fCProject = iCProject;
        this.fEntryKind = n;
        this.fPath = iPath;
        this.fResource = iResource;
        this.fIsExported = false;
        this.fCachedEntry = null;
        switch (n) {
            case 7: {
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 3: {
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 1: {
                this.createAttributeElement(LIBRARY, new Path(""));
                this.createAttributeElement(SOURCEATTACHMENT, null);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 4: {
                this.createAttributeElement(INCLUDE, new Path(""));
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(SYSTEM_INCLUDE, false);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 6: {
                this.createAttributeElement(MACRO_NAME, "");
                this.createAttributeElement(MACRO_VALUE, "");
                this.createAttributeElement(EXCLUSION, new Path[0]);
                this.createAttributeElement(BASE_REF, new Path(""));
                this.createAttributeElement(BASE, new Path(""));
                break;
            }
            case 5: {
                try {
                    IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)this.fPath, (ICProject)this.fCProject);
                    if (iPathEntryContainer == null) break;
                    IPathEntry[] iPathEntryArray = iPathEntryContainer.getPathEntries();
                    int n2 = 0;
                    while (n2 < iPathEntryArray.length) {
                        CPElement cPElement = CPElement.createFromExisting(iPathEntryArray[n2], this.fCProject);
                        cPElement.createAttributeElement(PARENT_CONTAINER, this);
                        CPElementGroup cPElementGroup = new CPElementGroup(this, cPElement.getEntryKind());
                        int n3 = this.fChildren.indexOf(cPElementGroup);
                        if (n3 == -1) {
                            this.fChildren.add(cPElementGroup);
                        } else {
                            cPElementGroup = (CPElementGroup)this.fChildren.get(n3);
                        }
                        cPElementGroup.addChild(cPElement);
                        ++n2;
                    }
                    break;
                }
                catch (CModelException cModelException) {}
            }
        }
    }

    public IPathEntry getPathEntry() {
        if (this.Inherited != null) {
            return null;
        }
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newPathEntry();
        }
        return this.fCachedEntry;
    }

    private IPathEntry newPathEntry() {
        IPath[] iPathArray = (IPath[])this.getAttribute(EXCLUSION);
        IPath iPath = (IPath)this.getAttribute(BASE);
        IPath iPath2 = (IPath)this.getAttribute(BASE_REF);
        switch (this.fEntryKind) {
            case 7: {
                return CoreModel.newOutputEntry((IPath)this.fPath, (IPath[])iPathArray);
            }
            case 3: {
                return CoreModel.newSourceEntry((IPath)this.fPath, (IPath[])iPathArray);
            }
            case 1: {
                IPath iPath3 = (IPath)this.getAttribute(LIBRARY);
                IPath iPath4 = (IPath)this.getAttribute(SOURCEATTACHMENT);
                if (!iPath2.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)this.fPath, (IPath)iPath2, (IPath)iPath3);
                }
                return CoreModel.newLibraryEntry((IPath)this.fPath, (IPath)iPath, (IPath)iPath3, (IPath)iPath4, null, null, (boolean)this.isExported());
            }
            case 2: {
                return CoreModel.newProjectEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 5: {
                return CoreModel.newContainerEntry((IPath)this.fPath, (boolean)this.isExported());
            }
            case 4: {
                IPath iPath5 = (IPath)this.getAttribute(INCLUDE);
                if (!iPath2.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)this.fPath, (IPath)iPath2, (IPath)iPath5);
                }
                return CoreModel.newIncludeEntry((IPath)this.fPath, (IPath)iPath, (IPath)iPath5, (boolean)((Boolean)this.getAttribute(SYSTEM_INCLUDE)), (IPath[])iPathArray, (boolean)this.isExported());
            }
            case 6: {
                String string = (String)this.getAttribute(MACRO_NAME);
                String string2 = (String)this.getAttribute(MACRO_VALUE);
                if (!iPath2.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)this.fPath, (IPath)iPath2, (String)string);
                }
                return CoreModel.newMacroEntry((IPath)this.fPath, (String)string, (String)string2, (IPath[])iPathArray, (boolean)this.isExported());
            }
        }
        return null;
    }

    public static StringBuffer appendEncodePath(IPath iPath, StringBuffer stringBuffer) {
        if (iPath != null) {
            String string = iPath.toString();
            stringBuffer.append('[').append(string.length()).append(']').append(string);
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer.append(';');
    }

    public StringBuffer appendEncodedSettings(StringBuffer stringBuffer) {
        stringBuffer.append(this.fEntryKind).append(';');
        CPElement.appendEncodePath(this.fPath, stringBuffer).append(';');
        stringBuffer.append((Object)this.fIsExported).append(';');
        switch (this.fEntryKind) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                IPath[] iPathArray = (IPath[])this.getAttribute(EXCLUSION);
                stringBuffer.append('[').append(iPathArray.length).append(']');
                int n = 0;
                while (n < iPathArray.length) {
                    CPElement.appendEncodePath(iPathArray[n], stringBuffer);
                    ++n;
                }
                switch (this.fEntryKind) {
                    case 4: {
                        IPath iPath = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(iPath, stringBuffer);
                        IPath iPath2 = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(iPath2, stringBuffer);
                        IPath iPath3 = (IPath)this.getAttribute(INCLUDE);
                        CPElement.appendEncodePath(iPath3, stringBuffer);
                        break;
                    }
                    case 6: {
                        IPath iPath = (IPath)this.getAttribute(BASE_REF);
                        CPElement.appendEncodePath(iPath, stringBuffer);
                        IPath iPath4 = (IPath)this.getAttribute(BASE);
                        CPElement.appendEncodePath(iPath4, stringBuffer);
                        String string = (String)this.getAttribute(MACRO_NAME);
                        stringBuffer.append(string).append(';');
                    }
                }
                break;
            }
            case 1: {
                IPath iPath = (IPath)this.getAttribute(BASE_REF);
                CPElement.appendEncodePath(iPath, stringBuffer);
                IPath iPath5 = (IPath)this.getAttribute(BASE);
                CPElement.appendEncodePath(iPath5, stringBuffer);
                IPath iPath6 = (IPath)this.getAttribute(SOURCEATTACHMENT);
                CPElement.appendEncodePath(iPath6, stringBuffer);
                IPath iPath7 = (IPath)this.getAttribute(LIBRARY);
                CPElement.appendEncodePath(iPath7, stringBuffer);
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPElement getParentContainer() {
        CPElementAttribute cPElementAttribute = this.findAttributeElement(PARENT_CONTAINER);
        if (cPElementAttribute != null) {
            return (CPElement)cPElementAttribute.getValue();
        }
        return null;
    }

    public void setParent(CPElementGroup cPElementGroup) {
        CPElementAttribute cPElementAttribute = this.findAttributeElement(PARENT);
        if (cPElementAttribute == null && cPElementGroup != null) {
            this.createAttributeElement(PARENT, cPElementGroup);
            return;
        }
        cPElementAttribute.setValue(cPElementGroup);
    }

    public CPElementGroup getParent() {
        CPElementAttribute cPElementAttribute = this.findAttributeElement(PARENT);
        if (cPElementAttribute != null) {
            return (CPElementGroup)cPElementAttribute.getValue();
        }
        return null;
    }

    public CPElementAttribute setAttribute(String string, Object object) {
        CPElementAttribute cPElementAttribute = this.findAttributeElement(string);
        if (cPElementAttribute == null) {
            return null;
        }
        cPElementAttribute.setValue(object);
        this.attributeChanged(string);
        return cPElementAttribute;
    }

    private CPElementAttribute findAttributeElement(String string) {
        int n = 0;
        while (n < this.fChildren.size()) {
            CPElementAttribute cPElementAttribute;
            Object e = this.fChildren.get(n);
            if (e instanceof CPElementAttribute && string.equals((cPElementAttribute = (CPElementAttribute)e).getKey())) {
                return cPElementAttribute;
            }
            ++n;
        }
        return null;
    }

    public Object getAttribute(String string) {
        CPElementAttribute cPElementAttribute = this.findAttributeElement(string);
        if (cPElementAttribute != null) {
            return cPElementAttribute.getValue();
        }
        return null;
    }

    private void createAttributeElement(String string, Object object) {
        this.fChildren.add(new CPElementAttribute(this, string, object));
    }

    public Object[] getChildren() {
        switch (this.fEntryKind) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.getInherited() != null || this.getParentContainer() != null) break;
                return new Object[]{this.findAttributeElement(EXCLUSION)};
            }
            case 5: {
                ArrayList arrayList = new ArrayList();
                int n = 0;
                while (n < this.fChildren.size()) {
                    Object e = this.fChildren.get(n);
                    if (e instanceof CPElementGroup) {
                        arrayList.add(e);
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
        }
        return new Object[0];
    }

    private void attributeChanged(String string) {
        this.fCachedEntry = null;
        this.fStatus = null;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            CPElement cPElement = (CPElement)object;
            if (cPElement.fEntryKind != this.fEntryKind || !cPElement.fPath.equals((Object)this.fPath)) {
                return false;
            }
            switch (this.fEntryKind) {
                case 1: {
                    return this.getAttribute(LIBRARY).equals(cPElement.getAttribute(LIBRARY)) && this.getAttribute(BASE).equals(cPElement.getAttribute(BASE)) && this.getAttribute(BASE_REF).equals(cPElement.getAttribute(BASE_REF));
                }
                case 4: {
                    return this.getAttribute(INCLUDE).equals(cPElement.getAttribute(INCLUDE)) && this.getAttribute(BASE_REF).equals(cPElement.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(cPElement.getAttribute(BASE));
                }
                case 6: {
                    return this.getAttribute(MACRO_NAME).equals(cPElement.getAttribute(MACRO_NAME)) && this.getAttribute(BASE_REF).equals(cPElement.getAttribute(BASE_REF)) && this.getAttribute(BASE).equals(cPElement.getAttribute(BASE));
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.fPath.hashCode() + this.fEntryKind;
        switch (this.fEntryKind) {
            case 1: {
                n = n * 89 + this.getAttribute(LIBRARY).hashCode();
                n = n * 89 + this.getAttribute(BASE).hashCode();
                n = n * 89 + this.getAttribute(BASE_REF).hashCode();
                break;
            }
            case 4: {
                n = n * 89 + this.getAttribute(INCLUDE).hashCode();
                n = n * 89 + this.getAttribute(BASE_REF).hashCode();
                n = n * 89 + this.getAttribute(BASE).hashCode();
                break;
            }
            case 6: {
                n = n * 89 + this.getAttribute(MACRO_NAME).hashCode();
                n = n * 89 + this.getAttribute(BASE_REF).hashCode();
                n = n * 89 + this.getAttribute(BASE).hashCode();
            }
        }
        return n;
    }

    public String toString() {
        return this.getPathEntry().toString();
    }

    public IStatus getStatus() {
        if (this.Inherited != null) {
            return this.Inherited.getStatus();
        }
        if (this.fStatus == null) {
            this.fStatus = Status.OK_STATUS;
            IResource iResource = null;
            IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
            IPathEntry iPathEntry = this.getPathEntry();
            switch (this.getEntryKind()) {
                case 5: {
                    try {
                        if (CoreModel.getPathEntryContainer((IPath)this.fPath, (ICProject)this.fCProject) != null) break;
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.pathContainerMissing"), null);
                    }
                    catch (CModelException cModelException) {}
                    break;
                }
                case 1: {
                    if (((ILibraryEntry)iPathEntry).getFullLibraryPath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.libraryPathNotFound"), null);
                    break;
                }
                case 3: {
                    IPath iPath = this.fPath.removeTrailingSeparator();
                    iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource != null) break;
                    if (iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.sourcePathMissing"), null);
                    break;
                }
                case 7: {
                    IPath iPath = this.fPath.removeTrailingSeparator();
                    iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource != null) break;
                    if (iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.outputPathMissing"), null);
                    break;
                }
                case 4: {
                    IPath iPath = this.fPath.removeTrailingSeparator();
                    iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    if (iResource.getType() != 8 && iResource.getType() != 4 && this.fCProject != null && !this.fCProject.isOnSourceRoot(iResource)) {
                        this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.notOnSourcePath"), null);
                    }
                    if (((IIncludeEntry)iPathEntry).getFullIncludePath().toFile().exists()) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.includePathNotFound"), null);
                    break;
                }
                case 6: {
                    IPath iPath = this.fPath.removeTrailingSeparator();
                    iResource = iWorkspaceRoot.findMember(iPath);
                    if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    if (iResource.getType() == 8 || iResource.getType() == 4 || this.fCProject == null || this.fCProject.isOnSourceRoot(iResource)) break;
                    this.fStatus = new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.notOnSourcePath"), null);
                    break;
                }
                case 2: {
                    iResource = iWorkspaceRoot.findMember(this.fPath);
                    if (iResource != null) break;
                    this.fStatus = new Status(4, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getString("CPElement.status.missingProjectPath"), null);
                }
            }
        }
        return this.fStatus;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean bl) {
        if (bl != this.fIsExported) {
            this.fIsExported = bl;
            this.attributeChanged(null);
        }
    }

    public CPElement getInherited() {
        return this.Inherited;
    }

    public ICProject getCProject() {
        return this.fCProject;
    }

    public static CPElement createFromExisting(IPathEntry iPathEntry, ICProject iCProject) {
        IPath iPath = iPathEntry.getPath();
        IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        IPath iPath2 = null;
        IPath[] iPathArray = null;
        IPath iPath3 = null;
        IPath iPath4 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        IPath iPath5 = null;
        IPath iPath6 = null;
        IResource iResource = null;
        switch (iPathEntry.getEntryKind()) {
            case 5: {
                iResource = null;
                break;
            }
            case 1: {
                iPath4 = ((ILibraryEntry)iPathEntry).getLibraryPath();
                iPath2 = ((ILibraryEntry)iPathEntry).getSourceAttachmentPath();
                iPath6 = ((ILibraryEntry)iPathEntry).getBasePath();
                iPath5 = ((ILibraryEntry)iPathEntry).getBaseReference();
                break;
            }
            case 3: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                iPathArray = ((ISourceEntry)iPathEntry).getExclusionPatterns();
                break;
            }
            case 7: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                iPathArray = ((IOutputEntry)iPathEntry).getExclusionPatterns();
                break;
            }
            case 4: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                iPathArray = ((IIncludeEntry)iPathEntry).getExclusionPatterns();
                bl = ((IIncludeEntry)iPathEntry).isSystemInclude();
                iPath5 = ((IIncludeEntry)iPathEntry).getBaseReference();
                iPath6 = ((IIncludeEntry)iPathEntry).getBasePath();
                iPath3 = ((IIncludeEntry)iPathEntry).getIncludePath();
                break;
            }
            case 6: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                    iResource = iWorkspaceRoot.getFolder(iPath);
                }
                iPathArray = ((IMacroEntry)iPathEntry).getExclusionPatterns();
                string = ((IMacroEntry)iPathEntry).getMacroName();
                string2 = ((IMacroEntry)iPathEntry).getMacroValue();
                iPath5 = ((IMacroEntry)iPathEntry).getBaseReference();
                iPath6 = ((IMacroEntry)iPathEntry).getBasePath();
                break;
            }
            case 2: {
                iResource = iWorkspaceRoot.findMember(iPath);
            }
        }
        CPElement cPElement = new CPElement(iCProject, iPathEntry.getEntryKind(), iPath, iResource);
        cPElement.setAttribute(SOURCEATTACHMENT, iPath2);
        cPElement.setAttribute(EXCLUSION, iPathArray);
        cPElement.setAttribute(INCLUDE, iPath3);
        cPElement.setAttribute(LIBRARY, iPath4);
        cPElement.setAttribute(MACRO_NAME, string);
        cPElement.setAttribute(MACRO_VALUE, string2);
        cPElement.setAttribute(SYSTEM_INCLUDE, bl);
        cPElement.setAttribute(BASE_REF, iPath5);
        cPElement.setAttribute(BASE, iPath6);
        cPElement.setExported(iPathEntry.isExported());
        return cPElement;
    }
}

