/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CPElementGroup {
    private CPElement parent;
    private final int kind;
    private IResource resource;
    private Map childrenListMap;
    private List childrenList;

    public CPElementGroup(IResource iResource) {
        this.kind = -1;
        this.resource = iResource;
        this.childrenListMap = new HashMap(2);
    }

    public CPElementGroup(CPElement cPElement, int n) {
        this.parent = cPElement;
        this.kind = n;
        this.childrenList = new ArrayList();
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getPath() {
        return this.resource != null ? this.resource.getFullPath() : this.parent.getPath();
    }

    public CPElement getParent() {
        return this.parent;
    }

    public int getEntryKind() {
        return this.kind;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CPElementGroup) {
            CPElementGroup cPElementGroup = (CPElementGroup)object;
            return this.kind == cPElementGroup.kind && (this.parent == null && cPElementGroup.parent == null || this.parent.equals(cPElementGroup.parent)) && (this.resource == null && cPElementGroup.resource == null || this.resource.equals((Object)cPElementGroup.resource));
        }
        return false;
    }

    public int hashCode() {
        int n = this.parent != null ? this.parent.hashCode() : 0;
        return (n += this.resource != null ? this.resource.hashCode() : 0) + this.kind;
    }

    public int indexof(CPElement cPElement) {
        List list = this.getChildrenList(cPElement.getEntryKind(), false);
        return list != null ? list.indexOf(cPElement) : -1;
    }

    public void addChild(CPElement cPElement, int n) {
        List list = this.getChildrenList(cPElement.getEntryKind(), true);
        list.add(n, cPElement);
        cPElement.setParent(this);
    }

    public void addChild(CPElement cPElement) {
        List list = this.getChildrenList(cPElement.getEntryKind(), true);
        int n = list.indexOf(cPElement);
        if (n == -1) {
            n = list.size();
            if (cPElement.getInherited() == null) {
                int n2 = 0;
                while (n2 < list.size()) {
                    CPElement cPElement2 = (CPElement)list.get(n2);
                    if (cPElement2.getInherited() != null) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
            list.add(n, cPElement);
            cPElement.setParent(this);
        } else {
            IPath iPath;
            IPath iPath2;
            CPElement cPElement3 = (CPElement)list.get(n);
            if (cPElement3.getInherited() != null && cPElement.getInherited() != null && !(iPath2 = cPElement3.getInherited().getPath()).equals((Object)(iPath = cPElement.getInherited().getPath())) && iPath2.isPrefixOf(iPath)) {
                list.remove(n);
                cPElement3.setParent(null);
                list.add(cPElement);
                cPElement.setParent(this);
            }
        }
    }

    public void setChildren(CPElement[] cPElementArray) {
        if (cPElementArray.length > 0) {
            if (this.childrenListMap != null) {
                this.childrenListMap.put(new Integer(cPElementArray[0].getEntryKind()), new ArrayList<CPElement>(Arrays.asList(cPElementArray)));
            } else {
                this.childrenList = new ArrayList<CPElement>(Arrays.asList(cPElementArray));
            }
        }
    }

    public void addChildren(CPElement[] cPElementArray) {
        int n = 0;
        while (n < cPElementArray.length) {
            this.addChild(cPElementArray[n]);
            ++n;
        }
    }

    public boolean removeChild(CPElement cPElement) {
        List list = this.getChildrenList(cPElement.getEntryKind(), false);
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(cPElement);
        if (bl) {
            cPElement.setParent(null);
        }
        return bl;
    }

    public CPElement[] getChildren(int n) {
        List list = this.getChildrenList(n, true);
        return list.toArray(new CPElement[list.size()]);
    }

    public CPElement[] getChildren() {
        if (this.childrenList != null) {
            return this.childrenList.toArray(new CPElement[this.childrenList.size()]);
        }
        Collection collection = this.childrenListMap.values();
        Iterator iterator = collection.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.addAll((List)iterator.next());
        }
        return arrayList.toArray(new CPElement[arrayList.size()]);
    }

    public boolean contains(CPElement cPElement) {
        List list = this.getChildrenList(cPElement.getEntryKind(), false);
        if (list == null) {
            return false;
        }
        return list.contains(cPElement);
    }

    public void replaceChild(CPElement cPElement, CPElement cPElement2) {
        List list = this.getChildrenList(cPElement.getEntryKind(), false);
        if (list == null) {
            return;
        }
        int n = list.indexOf(cPElement);
        if (n != -1) {
            list.remove(n);
            list.add(n, cPElement2);
        }
    }

    private List getChildrenList(int n, boolean bl) {
        List list = null;
        if (this.childrenList != null) {
            list = this.childrenList;
        } else {
            list = (List)this.childrenListMap.get(new Integer(n));
            if (list == null && bl) {
                list = new ArrayList();
                this.childrenListMap.put(new Integer(n), list);
            }
        }
        return list;
    }
}

