/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPListImageDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

class CPElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private final Color inDirect = new Color((Device)Display.getDefault(), new RGB(170, 170, 170));
    private String fNewLabel = CPathEntryMessages.getString("CPElementLabelProvider.new");
    private String fCreateLabel = CPathEntryMessages.getString("CPElementLabelProvider.willbecreated");
    private ImageDescriptor fIncludeIcon;
    private ImageDescriptor fMacroIcon;
    private ImageDescriptor fLibWSrcIcon;
    private ImageDescriptor fLibIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fOutputImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fContainerImage;
    private boolean bShowExported;
    private boolean bShowParentInfo;
    private ImageDescriptorRegistry fRegistry = CUIPlugin.getImageDescriptorRegistry();
    private CElementImageProvider fCImages = new CElementImageProvider();
    private static final Point SMALL_SIZE = new Point(16, 16);

    public CPElementLabelProvider() {
        this(true, false);
    }

    public CPElementLabelProvider(boolean bl, boolean bl2) {
        this.fLibIcon = CPluginImages.DESC_OBJS_ARCHIVE;
        this.fLibWSrcIcon = CPluginImages.DESC_OBJS_ARCHIVE_WSRC;
        this.fIncludeIcon = CPluginImages.DESC_OBJS_INCLUDES_FOLDER;
        this.fMacroIcon = CPluginImages.DESC_OBJS_MACRO;
        this.fFolderImage = CPluginImages.DESC_OBJS_SOURCE_ROOT;
        this.fOutputImage = CPluginImages.DESC_OBJS_CONTAINER;
        this.fContainerImage = CPluginImages.DESC_OBJS_LIBRARY;
        IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
        this.fProjectImage = iWorkbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.bShowExported = bl;
        this.bShowParentInfo = bl2;
    }

    public String getText(Object object) {
        if (object instanceof CPElement) {
            return this.getCPElementText((CPElement)object);
        }
        if (object instanceof CPElementAttribute) {
            return this.getCPElementAttributeText((CPElementAttribute)object);
        }
        if (object instanceof IPathEntry) {
            return this.getCPElementText(CPElement.createFromExisting((IPathEntry)object, null));
        }
        if (object instanceof CPElementGroup) {
            return this.getCPContainerGroupText((CPElementGroup)object);
        }
        return super.getText(object);
    }

    private String getCPContainerGroupText(CPElementGroup cPElementGroup) {
        switch (cPElementGroup.getEntryKind()) {
            case 4: {
                return CPathEntryMessages.getString("CPElementLabelProvider.Includes");
            }
            case 6: {
                return CPathEntryMessages.getString("CPElementLabelProvider.PreprocessorSymbols");
            }
            case 1: {
                return CPathEntryMessages.getString("CPElementLabelProvider.Libraries");
            }
            case -1: {
                if (cPElementGroup.getResource().getType() == 4) {
                    return cPElementGroup.getResource().getName();
                }
                return cPElementGroup.getResource().getProjectRelativePath().toString();
            }
        }
        return "";
    }

    public String getCPElementAttributeText(CPElementAttribute cPElementAttribute) {
        IPath[] iPathArray;
        String string = CPathEntryMessages.getString("CPElementLabelProvider.none");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = cPElementAttribute.getKey();
        if (string2.equals("sourcepath")) {
            stringBuffer.append(CPathEntryMessages.getString("CPElementLabelProvider.source_attachment.label"));
            iPathArray = (IPath[])cPElementAttribute.getValue();
            if (iPathArray != null && !iPathArray.isEmpty()) {
                stringBuffer.append(this.getPathString((IPath)iPathArray, iPathArray.getDevice() != null));
            } else {
                stringBuffer.append(string);
            }
        } else if (string2.equals("rootpath")) {
            stringBuffer.append(CPathEntryMessages.getString("CPElementLabelProvider.source_attachment_root.label"));
            iPathArray = (IPath)cPElementAttribute.getValue();
            if (iPathArray != null && !iPathArray.isEmpty()) {
                stringBuffer.append(iPathArray.toString());
            } else {
                stringBuffer.append(string);
            }
        }
        if (string2.equals("exclusion")) {
            stringBuffer.append(CPathEntryMessages.getString("CPElementLabelProvider.exclusion_filter.label"));
            iPathArray = (IPath[])cPElementAttribute.getValue();
            if (iPathArray != null && iPathArray.length > 0) {
                int n = 0;
                while (n < iPathArray.length) {
                    if (n > 0) {
                        stringBuffer.append(CPathEntryMessages.getString("CPElementLabelProvider.exclusion_filter_separator"));
                    }
                    stringBuffer.append(iPathArray[n].toString());
                    ++n;
                }
            } else {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getCPElementText(CPElement cPElement) {
        IPath iPath = cPElement.getPath();
        switch (cPElement.getEntryKind()) {
            case 1: {
                IPath iPath2 = (IPath)cPElement.getAttribute("librarypath");
                StringBuffer stringBuffer = new StringBuffer();
                this.addBaseString(iPath2, cPElement, stringBuffer);
                this.addExport(cPElement, stringBuffer);
                this.addParentInfo(cPElement, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: {
                return iPath.lastSegment();
            }
            case 4: {
                IPath iPath3 = (IPath)cPElement.getAttribute("includepath");
                StringBuffer stringBuffer = new StringBuffer();
                this.addBaseString(iPath3, cPElement, stringBuffer);
                this.addExport(cPElement, stringBuffer);
                this.addParentInfo(cPElement, stringBuffer);
                return stringBuffer.toString();
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf((String)cPElement.getAttribute("macroname")) + "=" + (String)cPElement.getAttribute("macrovalue"));
                this.addBaseString(null, cPElement, stringBuffer);
                this.addExport(cPElement, stringBuffer);
                this.addParentInfo(cPElement, stringBuffer);
                return stringBuffer.toString();
            }
            case 5: {
                StringBuffer stringBuffer = new StringBuffer(iPath.toString());
                try {
                    IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)cPElement.getPath(), (ICProject)cPElement.getCProject());
                    if (iPathEntryContainer != null) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(iPathEntryContainer.getDescription());
                    }
                }
                catch (CModelException cModelException) {}
                this.addExport(cPElement, stringBuffer);
                return stringBuffer.toString();
            }
            case 3: 
            case 7: {
                StringBuffer stringBuffer = new StringBuffer(iPath.makeRelative().toString());
                IResource iResource = cPElement.getResource();
                if (iResource != null && !iResource.exists()) {
                    stringBuffer.append(' ');
                    if (cPElement.getStatus().getSeverity() != 0) {
                        stringBuffer.append(this.fCreateLabel);
                    } else {
                        stringBuffer.append(this.fNewLabel);
                    }
                }
                return stringBuffer.toString();
            }
        }
        return CPathEntryMessages.getString("CPElementLabelProvider.unknown_element.label");
    }

    private void addParentInfo(CPElement cPElement, StringBuffer stringBuffer) {
        CPElement cPElement2;
        if (this.bShowParentInfo && (cPElement2 = cPElement.getParentContainer()) != null) {
            stringBuffer.append(" [");
            try {
                IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)cPElement.getPath(), (ICProject)cPElement.getCProject());
                if (iPathEntryContainer != null) {
                    stringBuffer.append(iPathEntryContainer.getDescription());
                }
            }
            catch (CModelException cModelException) {
                stringBuffer.append(cPElement2.getPath());
            }
            stringBuffer.append(']');
        }
    }

    private void addExport(CPElement cPElement, StringBuffer stringBuffer) {
        if (this.bShowExported && cPElement.isExported()) {
            stringBuffer.append(' ');
            stringBuffer.append(CPathEntryMessages.getString("CPElementLabelProvider.export.label"));
        }
    }

    private void addBaseString(IPath iPath, CPElement cPElement, StringBuffer stringBuffer) {
        IPath iPath2 = (IPath)cPElement.getAttribute("base-ref");
        if (!iPath2.isEmpty()) {
            if (iPath2.isAbsolute()) {
                IPath iPath3 = iPath2;
                if (iPath != null) {
                    iPath3 = iPath3.append(iPath);
                }
                stringBuffer.append(iPath3.makeRelative().toOSString());
            } else {
                if (iPath != null) {
                    stringBuffer.append(iPath.toOSString());
                }
                stringBuffer.append(" - (");
                try {
                    IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)iPath2, (ICProject)cPElement.getCProject());
                    if (iPathEntryContainer != null) {
                        stringBuffer.append(iPathEntryContainer.getDescription());
                    }
                }
                catch (CModelException cModelException) {}
                stringBuffer.append(')');
            }
        } else {
            IPath iPath4 = (IPath)cPElement.getAttribute("base-path");
            if (!iPath4.isEmpty()) {
                if (iPath != null) {
                    iPath4 = iPath4.append(iPath);
                }
                stringBuffer.insert(0, iPath4.toOSString());
            } else if (iPath != null) {
                stringBuffer.insert(0, iPath.toOSString());
            }
        }
    }

    private String getPathString(IPath iPath, boolean bl) {
        return bl ? iPath.toOSString() : iPath.makeRelative().toString();
    }

    private ImageDescriptor getCPElementBaseImage(CPElement cPElement) {
        switch (cPElement.getEntryKind()) {
            case 7: {
                if (cPElement.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fOutputImage;
            }
            case 3: {
                if (cPElement.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                IPath iPath = (IPath)cPElement.getAttribute("sourcepath");
                if (iPath == null || iPath.isEmpty()) {
                    return this.fLibIcon;
                }
                return this.fLibWSrcIcon;
            }
            case 2: {
                return this.fProjectImage;
            }
            case 5: {
                return this.fContainerImage;
            }
            case 4: {
                return this.fIncludeIcon;
            }
            case 6: {
                return this.fMacroIcon;
            }
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof CPElement) {
            CPElement cPElement = (CPElement)object;
            Object object2 = this.getCPElementBaseImage(cPElement);
            if (object2 != null) {
                switch (cPElement.getStatus().getSeverity()) {
                    case 2: {
                        object2 = new CPListImageDescriptor((ImageDescriptor)object2, 1, SMALL_SIZE);
                        break;
                    }
                    case 4: {
                        object2 = new CPListImageDescriptor((ImageDescriptor)object2, 2, SMALL_SIZE);
                    }
                }
                if (cPElement.getInherited() != null) {
                    object2 = new CPListImageDescriptor((ImageDescriptor)object2, 4, SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)object2);
            }
        } else if (object instanceof CPElementAttribute) {
            String string = ((CPElementAttribute)object).getKey();
            if (string.equals("sourcepath")) {
                return this.fRegistry.get(CPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
            }
            if (string.equals("exclusion")) {
                return CPluginImages.get("org.eclipse.cdt.ui.exclusion_filter_attrib.gif");
            }
        } else {
            if (object instanceof IPathEntry) {
                return this.getImage(CPElement.createFromExisting((IPathEntry)object, null));
            }
            if (object instanceof CPElementGroup) {
                switch (((CPElementGroup)object).getEntryKind()) {
                    case 4: {
                        return CPluginImages.get("org.eclipse.cdt.ui.includes_container.gif");
                    }
                    case 6: {
                        return this.fRegistry.get(this.fMacroIcon);
                    }
                    case 1: {
                        return CPluginImages.get("org.eclipse.cdt.ui.lib_obj.gif");
                    }
                    case -1: {
                        return this.fCImages.getImageLabel(((CPElementGroup)object).getResource(), 2);
                    }
                }
            }
        }
        return null;
    }

    public Color getForeground(Object object) {
        if (object instanceof CPElement && ((CPElement)object).getInherited() != null) {
            return this.inDirect;
        }
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }
}

