/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CPListImageDescriptor
extends CompositeImageDescriptor {
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PATH_INHERIT = 4;
    private ImageDescriptor fBaseImage;
    private int flags;
    private Point fSize;

    public CPListImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        this.flags = n;
        this.fSize = point;
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData imageData = this.fBaseImage.getImageData();
            this.setSize(new Point(imageData.width, imageData.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CPListImageDescriptor)) {
            return false;
        }
        CPListImageDescriptor cPListImageDescriptor = (CPListImageDescriptor)((Object)object);
        return this.fBaseImage.equals(cPListImageDescriptor.fBaseImage) && this.flags == cPListImageDescriptor.flags && this.fSize.equals((Object)cPListImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() & this.flags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.fBaseImage.getImageData();
        if (imageData == null) {
            imageData = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        this.drawImage(imageData, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        Point point = this.getSize();
        ImageData imageData = null;
        int n = this.getSize().x;
        if ((this.flags & 4) == 4) {
            imageData = CPluginImages.DESC_OVR_PATH_INHERIT.getImageData();
            this.drawImage(imageData, n, 0);
        }
        n = 0;
        if ((this.flags & 2) != 0) {
            imageData = CPluginImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
        if ((this.flags & 1) != 0) {
            imageData = CPluginImages.DESC_OVR_WARNING.getImageData();
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }

    protected void setSize(Point point) {
        this.fSize = point;
    }
}

