/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CPathContainerDefaultPage
extends NewElementWizardPage
implements ICPathContainerPage {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public CPathContainerDefaultPage() {
        super("CPathContainerDefaultPage");
        this.setTitle(CPathEntryMessages.getString("CPathContainerDefaultPage.title"));
        this.setDescription(CPathEntryMessages.getString("CPathContainerDefaultPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(CPathEntryMessages.getString("CPathContainerDefaultPage.path.label"));
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                CPathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fEntryField.getText();
        if (string.length() == 0) {
            statusInfo.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.enterpath"));
        } else if (!Path.ROOT.isValidPath(string)) {
            statusInfo.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.invalidpath"));
        } else {
            Path path = new Path(string);
            if (path.segmentCount() == 0) {
                statusInfo.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.needssegment"));
            } else if (this.fUsedPaths.contains(path)) {
                statusInfo.setError(CPathEntryMessages.getString("CPathContainerDefaultPage.path.error.alreadyexists"));
            }
        }
        this.updateStatus(statusInfo);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fEntryField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public boolean finish() {
        return true;
    }

    public IPathEntry[] getContainerEntries() {
        return new IPathEntry[]{CoreModel.newContainerEntry((IPath)new Path(this.fEntryField.getText()))};
    }

    public void initialize(ICProject iCProject, IPathEntry[] iPathEntryArray) {
        int n = 0;
        while (n < iPathEntryArray.length) {
            IPathEntry iPathEntry = iPathEntryArray[n];
            if (iPathEntry.getEntryKind() == 5) {
                this.fUsedPaths.add(iPathEntry.getPath());
            }
            ++n;
        }
    }

    public void setSelection(IPathEntry iPathEntry) {
        if (iPathEntry != null) {
            this.fUsedPaths.remove(iPathEntry.getPath());
            this.fEntryField.setText(iPathEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

