/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class CPathContainerDescriptor
implements IContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private static final String ATT_EXTENSION = "PathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PAGE_CLASS = "class";
    private Image pageImage;
    static /* synthetic */ Class class$0;

    public CPathContainerDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fConfigElement = iConfigurationElement;
        String string = this.fConfigElement.getAttribute(ATT_ID);
        String string2 = iConfigurationElement.getAttribute(ATT_NAME);
        String string3 = iConfigurationElement.getAttribute(ATT_PAGE_CLASS);
        if (string2 == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing name): " + string, null));
        }
        if (string3 == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (missing page class name): " + string, null));
        }
    }

    public ICPathContainerPage createPage() throws CoreException {
        Object object = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
        if (object instanceof ICPathContainerPage) {
            return (ICPathContainerPage)object;
        }
        String string = this.fConfigElement.getAttribute(ATT_ID);
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + string, null));
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public Image getImage() {
        String string;
        if (this.pageImage == null && (string = this.fConfigElement.getAttribute(ATT_ICON)) != null) {
            Image image;
            IExtension iExtension = this.fConfigElement.getDeclaringExtension();
            String string2 = iExtension.getNamespace();
            this.pageImage = image = this.getImageFromPlugin(string2, string);
        }
        return this.pageImage;
    }

    public Image getImageFromPlugin(String string, String string2) {
        Bundle bundle = Platform.getBundle((String)string);
        URL uRL = bundle.getEntry("/");
        return this.getImageFromURL(uRL, string2);
    }

    public Image getImageFromURL(URL uRL, String string) {
        Image image = null;
        try {
            URL uRL2 = new URL(uRL, string);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL2);
            image = imageDescriptor.createImage();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (SWTException sWTException) {}
        return image;
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(IPathEntry iPathEntry) {
        String string = this.fConfigElement.getAttribute(ATT_ID);
        if (iPathEntry.getEntryKind() == 5) {
            String string2 = iPathEntry.getPath().segment(0);
            return string.equals(string2);
        }
        return false;
    }

    public static IContainerDescriptor[] getDescriptors() {
        ArrayList<CPathContainerDescriptor> arrayList = new ArrayList<CPathContainerDescriptor>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", ATT_EXTENSION);
        if (iExtensionPoint != null) {
            CPathContainerDescriptor cPathContainerDescriptor = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDefaultPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                try {
                    CPathContainerDescriptor cPathContainerDescriptor2 = new CPathContainerDescriptor(iConfigurationElementArray[n]);
                    if (string.equals(cPathContainerDescriptor2.getPageClass())) {
                        cPathContainerDescriptor = cPathContainerDescriptor2;
                    } else {
                        arrayList.add(cPathContainerDescriptor2);
                    }
                }
                catch (CoreException coreException) {
                    CUIPlugin.getDefault().log(coreException);
                }
                ++n;
            }
            if (string != null && arrayList.isEmpty()) {
                arrayList.add(cPathContainerDescriptor);
            }
        }
        return arrayList.toArray(new CPathContainerDescriptor[arrayList.size()]);
    }
}

