/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class CPathContainerEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private TreeListDialogField fContainersList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private final int IDX_EXPORT = 5;

    public CPathContainerEntryPage(ListDialogField listDialogField) {
        super(CPathEntryMessages.getString("ContainerEntryPage.title"));
        this.fCPathList = listDialogField;
        String[] stringArray = new String[6];
        stringArray[0] = CPathEntryMessages.getString("ContainerEntryPage.add.button");
        stringArray[2] = CPathEntryMessages.getString("ContainerEntryPage.edit.button");
        stringArray[3] = CPathEntryMessages.getString("ContainerEntryPage.remove.button");
        stringArray[5] = CPathEntryMessages.getString("ContainerEntryPage.export.button");
        String[] stringArray2 = stringArray;
        ContainersAdapter containersAdapter = new ContainersAdapter();
        this.fContainersList = new TreeListDialogField(containersAdapter, stringArray2, (ILabelProvider)new CPElementLabelProvider());
        this.fContainersList.setDialogFieldListener(containersAdapter);
        this.fContainersList.setLabelText(CPathEntryMessages.getString("ContainerEntryPage.libraries.label"));
        this.fContainersList.enableButton(3, false);
        this.fContainersList.enableButton(2, false);
        this.fContainersList.enableButton(5, false);
        this.fContainersList.setViewerSorter(new CPElementSorter());
    }

    public void init(ICProject iCProject) {
        this.fCurrCProject = iCProject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List list = this.fCPathList.getElements();
        ArrayList<CPElement> arrayList = new ArrayList<CPElement>(list.size());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            CPElement cPElement = (CPElement)list.get(n2);
            if (this.isEntryKind(cPElement.getEntryKind())) {
                arrayList.add(cPElement);
            }
            ++n2;
        }
        this.fContainersList.setElements(arrayList);
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fContainersList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fContainersList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fContainersList.setButtonsMinWidth(n);
        this.fContainersList.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof CPElementGroup) {
                    return ((CPElementGroup)object2).getChildren().length != 0;
                }
                return true;
            }
        });
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_containers");
    }

    private void containerPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 0: {
                objectArray = this.openContainerSelectionDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
            case 5: {
                this.exportEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fContainersList.getElements();
            ArrayList<CPElement> arrayList = new ArrayList<CPElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                CPElement cPElement = objectArray[n3];
                if (!list.contains(cPElement) && !arrayList.contains(cPElement)) {
                    arrayList.add(cPElement);
                }
                ++n3;
            }
            this.fContainersList.addElements(arrayList);
            if (n == 0) {
                this.fContainersList.refresh();
            }
            this.fContainersList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    protected void containerPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fContainersList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void containerPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fContainersList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPElement) {
                CPElement cPElement = (CPElement)e;
                if (cPElement.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void removeEntry() {
        List list = this.fContainersList.getSelectedElements();
        this.fContainersList.removeElements(list);
    }

    private boolean canExport(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPElement) {
                CPElement cPElement = (CPElement)e;
                if (cPElement.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void exportEntry() {
        List list = this.fContainersList.getSelectedElements();
        if (list.size() == 0) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPElement) {
                ((CPElement)e).setExported(!((CPElement)e).isExported());
            }
            ++n;
        }
        this.fContainersList.refresh();
    }

    private void editEntry() {
        List list = this.fContainersList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fContainersList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPElement)e);
        } else if (e instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)e);
        }
    }

    private void editAttributeEntry(CPElementAttribute cPElementAttribute) {
    }

    private void editElementEntry(CPElement cPElement) {
        CPElement[] cPElementArray = null;
        cPElementArray = this.openContainerSelectionDialog(cPElement);
        if (cPElementArray != null && cPElementArray.length > 0) {
            CPElement cPElement2 = cPElementArray[0];
            cPElement2.setExported(cPElement.isExported());
            this.fContainersList.replaceElement(cPElement, cPElement2);
        }
    }

    private void containerPageSelectionChanged(DialogField dialogField) {
        List list = this.fContainersList.getSelectedElements();
        this.fContainersList.enableButton(2, this.canEdit(list));
        this.fContainersList.enableButton(3, this.canRemove(list));
        this.fContainersList.enableButton(5, this.canExport(list));
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            CPElement cPElement = (CPElement)e;
            return !(cPElement.getResource() instanceof IFolder) && cPElement.getParentContainer() == null;
        }
        return e instanceof CPElementAttribute;
    }

    private void containerPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrCProject != null) {
            this.updateCPathList();
        }
    }

    private void updateCPathList() {
        int n;
        List list = this.fContainersList.getElements();
        List list2 = this.fCPathList.getElements();
        int n2 = n = list2.size();
        int n3 = n - 1;
        while (n3 >= 0) {
            CPElement cPElement = (CPElement)list2.get(n3);
            int n4 = cPElement.getEntryKind();
            if (this.isEntryKind(n4) && !list.remove(cPElement)) {
                list2.remove(n3);
                n2 = n3;
            }
            --n3;
        }
        list2.addAll(n2, list);
        if (n2 != n || !list.isEmpty()) {
            this.fCPathList.setElements(list2);
        }
    }

    private CPElement[] openContainerSelectionDialog(CPElement cPElement) {
        IPathEntry[] iPathEntryArray;
        String string;
        IPathEntry iPathEntry = null;
        if (cPElement == null) {
            string = CPathEntryMessages.getString("ContainerEntryPage.ContainerDialog.new.title");
        } else {
            string = CPathEntryMessages.getString("ContainerEntryPage.ContainerDialog.edit.title");
            iPathEntry = cPElement.getPathEntry();
        }
        CPathContainerWizard cPathContainerWizard = new CPathContainerWizard(iPathEntry, (ICElement)this.fCurrCProject, this.getRawClasspath());
        cPathContainerWizard.setWindowTitle(string);
        if (CPathContainerWizard.openWizard(this.getShell(), cPathContainerWizard) == 0 && (iPathEntryArray = cPathContainerWizard.getContainers()) != null) {
            CPElement[] cPElementArray = new CPElement[iPathEntryArray.length];
            int n = 0;
            while (n < cPElementArray.length) {
                cPElementArray[n] = new CPElement(this.fCurrCProject, 5, iPathEntryArray[n].getPath(), null);
                ++n;
            }
            return cPElementArray;
        }
        return null;
    }

    private IPathEntry[] getRawClasspath() {
        IPathEntry[] iPathEntryArray = new IPathEntry[this.fCPathList.getSize()];
        int n = 0;
        while (n < iPathEntryArray.length) {
            CPElement cPElement = (CPElement)this.fCPathList.getElement(n);
            iPathEntryArray[n] = cPElement.getPathEntry();
            ++n;
        }
        return iPathEntryArray;
    }

    public boolean isEntryKind(int n) {
        return n == 5;
    }

    public List getSelection() {
        return this.fContainersList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fContainersList.selectElements((ISelection)new StructuredSelection(list));
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    private class ContainersAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        ContainersAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CPathContainerEntryPage.this.containerPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            CPathContainerEntryPage.this.containerPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            CPathContainerEntryPage.this.containerPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            CPathContainerEntryPage.this.containerPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren();
            }
            if (object instanceof CPElementGroup) {
                return ((CPElementGroup)object).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementAttribute) {
                return ((CPElementAttribute)object).getParent();
            }
            if (object instanceof CPElementGroup) {
                return ((CPElementGroup)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementGroup) {
                return true;
            }
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren().length != 0;
            }
            return false;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CPathContainerEntryPage.this.containerPageDialogFieldChanged(dialogField);
        }
    }
}

