/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDefaultPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerSelectionPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathFilterPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ProjectContainerDescriptor;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CPathContainerWizard
extends Wizard {
    private IContainerDescriptor fPageDesc;
    private IPathEntry fEntryToEdit;
    private IPathEntry[] fNewEntries;
    private IPathEntry[] fContainerEntries;
    private ICPathContainerPage fContainerPage;
    private ICElement fCurrElement;
    private IPathEntry[] fCurrCPath;
    private CPathFilterPage fFilterPage;
    private CPathContainerSelectionPage fSelectionWizardPage;
    private int[] fFilterType;

    public CPathContainerWizard(IPathEntry iPathEntry, ICElement iCElement, IPathEntry[] iPathEntryArray) {
        this(iPathEntry, null, iCElement, iPathEntryArray, null);
    }

    public CPathContainerWizard(IContainerDescriptor iContainerDescriptor, ICElement iCElement, IPathEntry[] iPathEntryArray) {
        this(null, iContainerDescriptor, iCElement, iPathEntryArray, null);
    }

    public CPathContainerWizard(IPathEntry iPathEntry, IContainerDescriptor iContainerDescriptor, ICElement iCElement, IPathEntry[] iPathEntryArray, int[] nArray) {
        this.fEntryToEdit = iPathEntry;
        this.fPageDesc = iContainerDescriptor;
        this.fNewEntries = null;
        this.fFilterType = nArray;
        this.fCurrElement = iCElement;
        this.fCurrCPath = iPathEntryArray;
    }

    public IPathEntry getEntriesParent() {
        return this.fContainerEntries[0];
    }

    public IPathEntry[] getEntries() {
        return this.fNewEntries;
    }

    public IPathEntry[] getContainers() {
        return this.fContainerEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            this.fContainerEntries = this.fContainerPage.getContainerEntries();
            if (this.fFilterPage != null && this.fFilterPage.isPageComplete()) {
                this.fNewEntries = this.fFilterPage.getSelectedEntries();
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            IContainerDescriptor[] iContainerDescriptorArray = CPathContainerDescriptor.getDescriptors();
            ArrayList<IContainerDescriptor> arrayList = new ArrayList<IContainerDescriptor>(Arrays.asList(iContainerDescriptorArray));
            if (this.fFilterType != null) {
                arrayList.add(0, new ProjectContainerDescriptor(this.fFilterType));
            }
            this.fSelectionWizardPage = new CPathContainerSelectionPage(arrayList.toArray(new IContainerDescriptor[0]));
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new CPathContainerDefaultPage();
            this.addPage(this.fContainerPage);
            if (this.fFilterType != null) {
                this.fFilterPage = new CPathFilterPage(this.fCurrElement, this.fFilterType);
                this.addPage((IWizardPage)this.fFilterPage);
            }
        } else {
            IContainerDescriptor[] iContainerDescriptorArray = CPathContainerDescriptor.getDescriptors();
            IContainerDescriptor iContainerDescriptor = this.findDescriptorPage(iContainerDescriptorArray, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(iContainerDescriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private ICPathContainerPage getContainerPage(IContainerDescriptor iContainerDescriptor) {
        ICPathContainerPage iCPathContainerPage = null;
        if (iContainerDescriptor != null) {
            try {
                iCPathContainerPage = iContainerDescriptor.createPage();
            }
            catch (CoreException coreException) {
                this.handlePageCreationFailed(coreException);
                iCPathContainerPage = null;
            }
        }
        if (iCPathContainerPage == null) {
            iCPathContainerPage = new CPathContainerDefaultPage();
        }
        iCPathContainerPage.initialize(this.fCurrElement.getCProject(), this.fCurrCPath);
        iCPathContainerPage.setSelection(this.fEntryToEdit);
        iCPathContainerPage.setWizard((IWizard)this);
        return iCPathContainerPage;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fSelectionWizardPage) {
            IContainerDescriptor iContainerDescriptor = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(iContainerDescriptor);
            return this.fContainerPage;
        }
        if (iWizardPage == this.fContainerPage && this.fFilterPage != null) {
            if (this.fContainerPage.finish() && this.fContainerPage.getContainerEntries().length > 0 && this.fContainerPage.getContainerEntries()[0] != null) {
                this.fFilterPage.setParentEntry(this.fContainerPage.getContainerEntries()[0]);
            }
            return this.fFilterPage;
        }
        return super.getNextPage(iWizardPage);
    }

    private void handlePageCreationFailed(CoreException coreException) {
        String string = CPathEntryMessages.getString("CPathContainerWizard.pagecreationerror.title");
        String string2 = CPathEntryMessages.getString("CPathContainerWizard.pagecreationerror.message");
        ExceptionHandler.handle(coreException, this.getShell(), string, string2);
    }

    private IContainerDescriptor findDescriptorPage(IContainerDescriptor[] iContainerDescriptorArray, IPathEntry iPathEntry) {
        int n = 0;
        while (n < iContainerDescriptorArray.length) {
            if (iContainerDescriptorArray[n].canEdit(iPathEntry)) {
                return iContainerDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        boolean bl = false;
        if (this.fContainerPage != null) {
            bl = this.fContainerPage.isPageComplete();
        }
        if (bl && this.fFilterPage != null) {
            bl = this.fFilterPage.isPageComplete();
        }
        return bl;
    }

    public static int openWizard(Shell shell, CPathContainerWizard cPathContainerWizard) {
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)cPathContainerWizard);
        PixelConverter pixelConverter = new PixelConverter((Control)shell);
        wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
        wizardDialog.create();
        return wizardDialog.open();
    }
}

