/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CPathFilterPage
extends WizardPage {
    private final int[] fFilterType;
    private CheckboxTableViewer viewer;
    private IPathEntry fParentEntry;
    private List fPaths;
    private List fExclusions;
    private ViewerFilter filter;
    protected ICElement fCElement;

    protected CPathFilterPage(ICElement iCElement, int[] nArray) {
        super("CPathFilterPage");
        this.setTitle(CPathEntryMessages.getString("CPathFilterPage.title"));
        this.setDescription(CPathEntryMessages.getString("CPathFilterPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fFilterType = nArray;
        this.fCElement = iCElement;
        this.validatePage();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(CPathEntryMessages.getString("CPathFilterPage.label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2816);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CPElementLabelProvider(false, false));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CPathFilterPage.this.validatePage();
            }
        });
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public void setVisible(boolean bl) {
        if (this.fPaths != null) {
            this.viewer.setInput((Object)this.fPaths);
        }
        super.setVisible(bl);
    }

    public void setParentEntry(IPathEntry iPathEntry) {
        this.fParentEntry = iPathEntry;
        if (this.fParentEntry.getEntryKind() == 2) {
            IProject iProject = CUIPlugin.getWorkspace().getRoot().getProject(this.fParentEntry.getPath().segment(0));
            if (iProject.isAccessible()) {
                ICProject iCProject = CoreModel.getDefault().create(iProject);
                try {
                    this.fPaths = Arrays.asList(iCProject.getRawPathEntries());
                }
                catch (CModelException cModelException) {}
            }
        } else if (this.fParentEntry.getEntryKind() == 5) {
            try {
                IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)this.fParentEntry.getPath(), (ICProject)this.fCElement.getCProject());
                if (iPathEntryContainer != null) {
                    this.fPaths = Arrays.asList(iPathEntryContainer.getPathEntries());
                }
            }
            catch (CModelException cModelException) {}
        }
        this.createExlusions(this.fParentEntry.getEntryKind() == 2);
    }

    private void createExlusions(boolean bl) {
        this.fExclusions = new ArrayList();
        if (this.filter != null) {
            this.viewer.removeFilter(this.filter);
        }
        this.filter = new CPElementFilter(this.fExclusions.toArray(), this.fFilterType, bl, false);
        this.viewer.addFilter(this.filter);
    }

    private void validatePage() {
        this.setPageComplete(this.getSelectedEntries().length > 0);
    }

    public IPathEntry[] getSelectedEntries() {
        if (this.viewer != null) {
            Object[] objectArray = this.viewer.getCheckedElements();
            IPathEntry[] iPathEntryArray = new IPathEntry[objectArray.length];
            System.arraycopy(objectArray, 0, iPathEntryArray, 0, iPathEntryArray.length);
            return iPathEntryArray;
        }
        return new IPathEntry[0];
    }
}

