/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathIncludeSymbolEntryPage
extends CPathBasePage {
    private TreeListDialogField fIncludeSymPathsList;
    private SelectionButtonDialogField fShowInheritedPaths;
    private ICProject fCurrCProject;
    private CPElementFilter fFilter;
    private IStatusChangeListener fContext;
    private final int IDX_ADD_FOLDER_FILE = 0;
    private final int IDX_ADD_SYMBOL = 2;
    private final int IDX_ADD_EXT_INCLUDE = 4;
    private final int IDX_ADD_WS_INCLUDE = 5;
    private final int IDX_ADD_CONTRIBUTED = 7;
    private final int IDX_EDIT = 9;
    private final int IDX_REMOVE = 10;
    private final int IDX_EXPORT = 12;
    private final int IDX_UP = 14;
    private final int IDX_DOWN = 15;
    private static final String[] buttonLabel;
    private CPElementGroup fProjectGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        String[] stringArray = new String[16];
        stringArray[0] = CPathEntryMessages.getString("IncludeSymbolEntryPage.addFolderFile");
        stringArray[2] = CPathEntryMessages.getString("IncludeSymbolEntryPage.addUserSymbol");
        stringArray[4] = CPathEntryMessages.getString("IncludeSymbolEntryPage.addExternalInclude");
        stringArray[5] = CPathEntryMessages.getString("IncludeSymbolEntryPage.addFromWorkspace");
        stringArray[7] = CPathEntryMessages.getString("IncludeSymbolEntryPage.addContributed");
        stringArray[9] = CPathEntryMessages.getString("IncludeSymbolEntryPage.edit");
        stringArray[10] = CPathEntryMessages.getString("IncludeSymbolEntryPage.remove");
        stringArray[12] = CPathEntryMessages.getString("IncludeSymbolEntryPage.export");
        stringArray[14] = CPathEntryMessages.getString("IncludeSymbolEntryPage.up");
        stringArray[15] = CPathEntryMessages.getString("IncludeSymbolEntryPage.down");
        buttonLabel = stringArray;
    }

    public CPathIncludeSymbolEntryPage(IStatusChangeListener iStatusChangeListener) {
        super(CPathEntryMessages.getString("IncludeSymbolEntryPage.title"));
        this.fContext = iStatusChangeListener;
        IncludeSymbolAdapter includeSymbolAdapter = new IncludeSymbolAdapter();
        this.fIncludeSymPathsList = new TreeListDialogField(includeSymbolAdapter, buttonLabel, (ILabelProvider)new CPElementLabelProvider(true, false)){

            protected int getTreeStyle() {
                return super.getTreeStyle() & 0xFFFFFFFD;
            }
        };
        this.fIncludeSymPathsList.setLabelText(CPathEntryMessages.getString("IncludeSymbolEntryPage.label"));
        this.fIncludeSymPathsList.enableButton(10, false);
        this.fIncludeSymPathsList.enableButton(9, false);
        this.fIncludeSymPathsList.enableButton(7, false);
        this.fIncludeSymPathsList.enableButton(4, false);
        this.fIncludeSymPathsList.enableButton(5, false);
        this.fIncludeSymPathsList.enableButton(2, false);
        this.fIncludeSymPathsList.enableButton(12, false);
        this.fIncludeSymPathsList.enableButton(14, false);
        this.fIncludeSymPathsList.enableButton(15, false);
        this.fShowInheritedPaths = new SelectionButtonDialogField(32);
        this.fShowInheritedPaths.setSelection(true);
        this.fShowInheritedPaths.setLabelText(CPathEntryMessages.getString("IncludeSymbolsEntryPage.show_inherited.check"));
        this.fShowInheritedPaths.setDialogFieldListener(includeSymbolAdapter);
        this.fFilter = new CPElementFilter(new int[]{-1, 4, 6, 5}, false, true);
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fIncludeSymPathsList, this.fShowInheritedPaths}, true);
        LayoutUtil.setHorizontalGrabbing(this.fIncludeSymPathsList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fIncludeSymPathsList.setButtonsMinWidth(n);
        this.setControl((Control)composite2);
        this.fIncludeSymPathsList.getTreeViewer().addFilter((ViewerFilter)this.fFilter);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_include");
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.includes_container.gif");
    }

    public void init(ICProject iCProject, List list) {
        this.fCurrCProject = iCProject;
        List list2 = this.createGroups(list);
        this.fIncludeSymPathsList.setElements(list2);
        this.updateStatus();
    }

    private void updateStatus() {
        CPElement cPElement = null;
        int n = 0;
        Object object = Status.OK_STATUS;
        List list = this.getCPaths();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            CPElement cPElement2 = (CPElement)list.get(n2);
            if (cPElement2.getStatus().getSeverity() != 0) {
                ++n;
                if (cPElement == null) {
                    cPElement = cPElement2;
                }
            }
            --n2;
        }
        if (n > 0) {
            object = n == 1 ? cPElement.getStatus() : new Status(2, "org.eclipse.cdt.ui", -1, CPathEntryMessages.getFormattedString("CPElement.status.multiplePathErrors", String.valueOf(n)), null);
        }
        this.fContext.statusChanged((IStatus)object);
    }

    private void updateStatus(List list) {
        if (list.size() != 1) {
            this.updateStatus();
            return;
        }
        CPElement cPElement = null;
        if (list.get(0) instanceof CPElement) {
            cPElement = (CPElement)list.get(0);
        } else if (list.get(0) instanceof CPElementAttribute) {
            cPElement = ((CPElementAttribute)list.get(0)).getParent();
        }
        if (cPElement == null || cPElement.getStatus().getSeverity() == 0) {
            this.updateStatus();
            return;
        }
        this.fContext.statusChanged(cPElement.getStatus());
    }

    private List createGroups(List list) {
        CPElement cPElement;
        ArrayList<CPElementGroup> arrayList = new ArrayList<CPElementGroup>(5);
        this.fProjectGroup = new CPElementGroup(this.fCurrCProject.getResource());
        arrayList.add(this.fProjectGroup);
        int n = 0;
        while (n < list.size()) {
            cPElement = (CPElement)list.get(n);
            switch (cPElement.getEntryKind()) {
                case 5: {
                    this.fProjectGroup.addChild(cPElement);
                    break;
                }
                case 4: 
                case 6: {
                    CPElementGroup cPElementGroup = new CPElementGroup(cPElement.getResource());
                    int n2 = arrayList.indexOf(cPElementGroup);
                    if (n2 == -1) {
                        arrayList.add(cPElementGroup);
                    } else {
                        cPElementGroup = (CPElementGroup)arrayList.get(n2);
                    }
                    cPElementGroup.addChild(cPElement);
                }
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            cPElement = (CPElement)list.get(n);
            switch (cPElement.getEntryKind()) {
                case 4: 
                case 6: {
                    this.addPathToResourceGroups(cPElement, null, arrayList);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void addPathToResourceGroup(CPElement cPElement, CPElementGroup cPElementGroup, CPElementGroup cPElementGroup2) {
        IPath iPath = cPElement.getPath();
        IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
        if (!(cPElementGroup2 == cPElementGroup && cPElementGroup2.getResource().equals((Object)cPElement.getResource()) || !iPath.isPrefixOf(cPElementGroup2.getPath()) || !iPath.equals((Object)cPElementGroup2.getPath()) && CoreModelUtil.isExcludedPath((IPath)cPElementGroup2.getResource().getFullPath().removeFirstSegments(iPath.segmentCount()), (IPath[])iPathArray))) {
            if (cPElementGroup != null) {
                int n = -1;
                int n2 = cPElementGroup.indexof(cPElement);
                if (n2 != -1) {
                    CPElement[] cPElementArray = cPElementGroup.getChildren(cPElement.getEntryKind());
                    int n3 = n2;
                    while (n3 < cPElementArray.length) {
                        n = cPElementGroup2.indexof(new CPElement(cPElementArray[n3], cPElementGroup2.getPath(), cPElementGroup2.getResource()));
                        if (n != -1) {
                            cPElementGroup2.addChild(new CPElement(cPElement, cPElementGroup2.getPath(), cPElementGroup2.getResource()), n);
                            break;
                        }
                        ++n3;
                    }
                }
                if (n == -1) {
                    cPElementGroup2.addChild(new CPElement(cPElement, cPElementGroup2.getPath(), cPElementGroup2.getResource()));
                }
            } else {
                cPElementGroup2.addChild(new CPElement(cPElement, cPElementGroup2.getPath(), cPElementGroup2.getResource()));
            }
        }
    }

    private void addPathToResourceGroups(CPElement cPElement, CPElementGroup cPElementGroup, List list) {
        if (cPElementGroup != null) {
            cPElementGroup.addChild(cPElement);
        }
        int n = 0;
        while (n < list.size()) {
            CPElementGroup cPElementGroup2 = (CPElementGroup)list.get(n);
            this.addPathToResourceGroup(cPElement, cPElementGroup, cPElementGroup2);
            ++n;
        }
    }

    private void updatePathOnResourceGroups(CPElement cPElement, List list) {
        CPElementGroup cPElementGroup = cPElement.getParent();
        IPath iPath = cPElement.getPath();
        IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
        int n = 0;
        while (n < list.size()) {
            CPElementGroup cPElementGroup2 = (CPElementGroup)list.get(n);
            if (cPElementGroup2 != cPElementGroup) {
                boolean bl = false;
                CPElement[] cPElementArray = cPElementGroup2.getChildren(cPElement.getEntryKind());
                int n2 = 0;
                while (n2 < cPElementArray.length) {
                    if (cPElementArray[n2].getInherited() == cPElement) {
                        bl = true;
                        if (!CoreModelUtil.isExcludedPath((IPath)cPElementGroup2.getResource().getFullPath().removeFirstSegments(iPath.segmentCount()), (IPath[])iPathArray)) {
                            cPElementGroup2.replaceChild(cPElementArray[n2], new CPElement(cPElement, cPElementGroup2.getPath(), cPElementGroup2.getResource()));
                            break;
                        }
                        cPElementGroup2.removeChild(cPElementArray[n2]);
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.addPathToResourceGroup(cPElement, cPElementGroup, cPElementGroup2);
                }
            }
            ++n;
        }
    }

    private CPElement removePathFromResourceGroups(CPElement cPElement, List list) {
        CPElement cPElement2 = cPElement.getInherited();
        CPElementGroup cPElementGroup = cPElement.getParent();
        cPElementGroup.removeChild(cPElement);
        if (cPElement2 != null) {
            IPath iPath = cPElement.getPath().removeFirstSegments(cPElement2.getPath().segmentCount());
            IPath[] iPathArray = (IPath[])cPElement2.getAttribute("exclusion");
            IPath[] iPathArray2 = new IPath[iPathArray.length + 1];
            System.arraycopy(iPathArray, 0, iPathArray2, 0, iPathArray.length);
            iPathArray2[iPathArray.length] = iPath;
            cPElement2.setAttribute("exclusion", iPathArray2);
            return null;
        }
        int n = 0;
        while (n < list.size()) {
            CPElementGroup cPElementGroup2 = (CPElementGroup)list.get(n);
            CPElement[] cPElementArray = cPElementGroup2.getChildren(cPElement.getEntryKind());
            int n2 = 0;
            while (n2 < cPElementArray.length) {
                if (cPElementArray[n2].getInherited() == cPElement) {
                    cPElementGroup2.removeChild(cPElementArray[n2]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return cPElement;
    }

    private boolean canAddPath(List list) {
        CPElementGroup cPElementGroup = this.getSelectedGroup();
        if (cPElementGroup != null) {
            return cPElementGroup.getEntryKind() == -1;
        }
        return false;
    }

    private boolean canRemove(List list) {
        CPElementAttribute cPElementAttribute;
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            CPElement cPElement = (CPElement)e;
            if (cPElement.getParentContainer() == null) {
                return cPElement.getEntryKind() == 4 || cPElement.getEntryKind() == 6;
            }
        } else if (e instanceof CPElementAttribute && (cPElementAttribute = (CPElementAttribute)e).getKey().equals("exclusion") && ((IPath[])cPElementAttribute.getValue()).length > 0) {
            return true;
        }
        return false;
    }

    private void removeEntry() {
        List list = this.getSelection();
        Object e = list.get(0);
        if (e instanceof CPElement) {
            CPElement cPElement = (CPElement)e;
            CPElementGroup cPElementGroup = cPElement.getParent();
            if (this.removePathFromResourceGroups(cPElement, this.fIncludeSymPathsList.getElements()) == null) {
                this.updatePathOnResourceGroups(cPElement.getInherited(), this.fIncludeSymPathsList.getElements());
            }
            this.fIncludeSymPathsList.refresh();
            this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElementGroup));
        } else if (e instanceof CPElementAttribute) {
            CPElementAttribute cPElementAttribute = (CPElementAttribute)e;
            String string = cPElementAttribute.getKey();
            Path[] pathArray = string.equals("exclusion") ? new Path[]{} : null;
            cPElementAttribute.getParent().setAttribute(string, pathArray);
            this.updatePathOnResourceGroups(cPElementAttribute.getParent(), this.fIncludeSymPathsList.getElements());
            this.fIncludeSymPathsList.refresh();
        }
        this.updateStatus();
    }

    private boolean canEdit(List list) {
        CPElement cPElement;
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement && (cPElement = (CPElement)list.get(0)).getParentContainer() == null && cPElement.getInherited() == null) {
            IPath iPath = (IPath)cPElement.getAttribute("base-ref");
            if (iPath != null && !iPath.equals((Object)Path.EMPTY)) {
                return false;
            }
            return cPElement.getEntryKind() == 4 || cPElement.getEntryKind() == 6 || cPElement.getEntryKind() == 5;
        }
        return e instanceof CPElementAttribute;
    }

    private void editEntry() {
        List list = this.fIncludeSymPathsList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            this.editElementEntry((CPElement)e);
        } else if (e instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)e);
        }
    }

    private void editElementEntry(CPElement cPElement) {
        IPath iPath = (IPath)cPElement.getAttribute("base-ref");
        if (iPath != null && !iPath.equals((Object)Path.EMPTY)) {
            return;
        }
        if (cPElement.getEntryKind() == 6) {
            this.addSymbol(cPElement);
        } else if (cPElement.getEntryKind() == 4) {
            iPath = (IPath)cPElement.getAttribute("base-path");
            if (iPath != null && !iPath.equals((Object)Path.EMPTY)) {
                CPElement[] cPElementArray = this.openWorkspacePathEntryDialog(null);
                if (cPElementArray != null && cPElementArray.length > 0) {
                    cPElementArray[0].setExported(cPElement.isExported());
                }
            } else {
                this.addInclude(cPElement);
            }
        } else if (cPElement.getEntryKind() == 5) {
            CPElement[] cPElementArray = null;
            cPElementArray = this.openContainerSelectionDialog(cPElement);
            if (cPElementArray != null && cPElementArray.length > 0) {
                CPElement cPElement2 = cPElementArray[0];
                cPElement2.setExported(cPElement.isExported());
                this.fProjectGroup.replaceChild(cPElement, cPElement2);
                this.fIncludeSymPathsList.refresh();
            }
        }
    }

    private void editAttributeEntry(CPElementAttribute cPElementAttribute) {
        String string = cPElementAttribute.getKey();
        if (string.equals("exclusion")) {
            CPElement cPElement = cPElementAttribute.getParent();
            ExclusionPatternDialog exclusionPatternDialog = new ExclusionPatternDialog(this.getShell(), cPElement);
            if (exclusionPatternDialog.open() == 0) {
                cPElement.setAttribute("exclusion", exclusionPatternDialog.getExclusionPattern());
                this.updatePathOnResourceGroups(cPElement, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
                this.updateStatus();
            }
        }
    }

    private void exportEntry() {
        CPElement cPElement;
        cPElement.setExported(!(cPElement = (CPElement)this.getSelection().get(0)).isExported());
        this.fIncludeSymPathsList.refresh(cPElement);
    }

    private boolean canExport(List list) {
        CPElement cPElement;
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement && (cPElement = (CPElement)list.get(0)).getParentContainer() == null && cPElement.getInherited() == null) {
            IPath iPath = (IPath)cPElement.getAttribute("base-ref");
            if (iPath != null && !iPath.equals((Object)Path.EMPTY)) {
                return false;
            }
            return cPElement.getEntryKind() == 4 || cPElement.getEntryKind() == 6;
        }
        return false;
    }

    private boolean canMove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (!(e instanceof CPElement)) {
                return false;
            }
            CPElement cPElement = (CPElement)e;
            if (cPElement.getEntryKind() != 4 && cPElement.getEntryKind() != 6) {
                return false;
            }
            if (cPElement.getParentContainer() != null || cPElement.getInherited() != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean canMoveUp(List list) {
        if (!this.canMove(list)) {
            return false;
        }
        CPElement cPElement = (CPElement)list.get(0);
        CPElementGroup cPElementGroup = cPElement.getParent();
        CPElement[] cPElementArray = cPElementGroup.getChildren(cPElement.getEntryKind());
        int n = Arrays.asList(cPElementArray).indexOf(cPElement);
        return n > 0;
    }

    private boolean canMoveDown(List list) {
        if (!this.canMove(list)) {
            return false;
        }
        CPElement cPElement = (CPElement)list.get(list.size() - 1);
        CPElementGroup cPElementGroup = cPElement.getParent();
        CPElement[] cPElementArray = cPElementGroup.getChildren(cPElement.getEntryKind());
        int n = Arrays.asList(cPElementArray).indexOf(cPElement);
        return n < cPElementArray.length - 1 && cPElementArray[n + 1].getInherited() == null;
    }

    private boolean moveUp(CPElement cPElement) {
        boolean bl = false;
        int n = cPElement.getEntryKind();
        Iterator iterator = this.fIncludeSymPathsList.getElements().iterator();
        while (iterator.hasNext()) {
            CPElementGroup cPElementGroup = (CPElementGroup)iterator.next();
            CPElement[] cPElementArray = cPElementGroup.getChildren(n);
            int n2 = 0;
            while (n2 < cPElementArray.length) {
                CPElement cPElement2 = cPElementArray[n2];
                if (cPElement.equals(cPElement2) || cPElement2.getInherited() != null && cPElement2.getInherited().equals(cPElement)) {
                    if (cPElement2.getInherited() != null && n2 > 0 && cPElementArray[n2 - 1].getInherited() == null) break;
                    int n3 = n2 - 1;
                    if (n3 >= 0) {
                        cPElementArray[n2] = cPElementArray[n3];
                        cPElementArray[n3] = cPElement2;
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
            cPElementGroup.setChildren(cPElementArray);
        }
        this.fIncludeSymPathsList.refresh();
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement));
        this.fIncludeSymPathsList.setFocus();
        return bl;
    }

    private boolean moveDown(CPElement cPElement) {
        boolean bl = false;
        int n = cPElement.getEntryKind();
        Iterator iterator = this.fIncludeSymPathsList.getElements().iterator();
        while (iterator.hasNext()) {
            CPElementGroup cPElementGroup = (CPElementGroup)iterator.next();
            CPElement[] cPElementArray = cPElementGroup.getChildren(n);
            int n2 = cPElementArray.length - 1;
            while (n2 >= 0) {
                int n3;
                CPElement cPElement2 = cPElementArray[n2];
                if ((cPElement.equals(cPElement2) || cPElement2.getInherited() != null && cPElement2.getInherited().equals(cPElement)) && (n3 = n2 + 1) < cPElementArray.length) {
                    cPElementArray[n2] = cPElementArray[n3];
                    cPElementArray[n3] = cPElement2;
                    bl = true;
                    break;
                }
                --n2;
            }
            cPElementGroup.setChildren(cPElementArray);
        }
        this.fIncludeSymPathsList.refresh();
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement));
        this.fIncludeSymPathsList.setFocus();
        return bl;
    }

    private CPElementGroup getSelectedGroup() {
        List list = this.fIncludeSymPathsList.getSelectedElements();
        if (!list.isEmpty()) {
            Object object = list.get(0);
            if (object instanceof CPElement) {
                object = ((CPElement)object).getParent();
            }
            if (object instanceof CPElementGroup) {
                return (CPElementGroup)object;
            }
        }
        return null;
    }

    protected void listPageDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fShowInheritedPaths) {
            boolean bl = this.fShowInheritedPaths.isSelected();
            if (this.fFilter != null) {
                this.fIncludeSymPathsList.getTreeViewer().removeFilter((ViewerFilter)this.fFilter);
            }
            this.fFilter = new CPElementFilter(new int[]{-1, 4, 6, 5}, false, bl);
            this.fIncludeSymPathsList.getTreeViewer().addFilter((ViewerFilter)this.fFilter);
            this.fIncludeSymPathsList.refresh();
        }
        this.updateStatus();
    }

    protected void listPageSelectionChanged(TreeListDialogField treeListDialogField) {
        List list = treeListDialogField.getSelectedElements();
        treeListDialogField.enableButton(10, this.canRemove(list));
        treeListDialogField.enableButton(9, this.canEdit(list));
        treeListDialogField.enableButton(7, this.canAddPath(list));
        treeListDialogField.enableButton(4, this.canAddPath(list));
        treeListDialogField.enableButton(5, this.canAddPath(list));
        treeListDialogField.enableButton(2, this.canAddPath(list));
        treeListDialogField.enableButton(12, this.canExport(list));
        treeListDialogField.enableButton(15, this.canMoveDown(list));
        treeListDialogField.enableButton(14, this.canMoveUp(list));
        this.updateStatus(list);
    }

    protected void ListCustomButtonPressed(TreeListDialogField treeListDialogField, int n) {
        switch (n) {
            case 0: {
                this.addNewPathResource();
                break;
            }
            case 2: {
                this.addSymbol(null);
                break;
            }
            case 4: {
                this.addInclude(null);
                break;
            }
            case 5: {
                this.addFromWorkspace();
                break;
            }
            case 7: {
                this.addContributed();
                break;
            }
            case 9: {
                if (!this.canEdit(treeListDialogField.getSelectedElements())) break;
                this.editEntry();
                break;
            }
            case 10: {
                if (!this.canRemove(treeListDialogField.getSelectedElements())) break;
                this.removeEntry();
                break;
            }
            case 15: {
                if (!this.canMoveDown(treeListDialogField.getSelectedElements())) break;
                this.moveDown((CPElement)treeListDialogField.getSelectedElements().get(0));
                break;
            }
            case 14: {
                if (!this.canMoveUp(treeListDialogField.getSelectedElements())) break;
                this.moveUp((CPElement)treeListDialogField.getSelectedElements().get(0));
                break;
            }
            case 12: {
                if (!this.canExport(treeListDialogField.getSelectedElements())) break;
                this.exportEntry();
            }
        }
    }

    protected void ListPageDoubleClicked(TreeListDialogField treeListDialogField) {
        if (this.canEdit(this.fIncludeSymPathsList.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void ListPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fIncludeSymPathsList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canEdit(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected IPathEntry[] getRawPathEntries() {
        List list = this.getCPaths();
        IPathEntry[] iPathEntryArray = new IPathEntry[list.size()];
        int n = 0;
        while (n < iPathEntryArray.length) {
            CPElement cPElement = (CPElement)list.get(n);
            iPathEntryArray[n] = cPElement.getPathEntry();
            ++n;
        }
        return iPathEntryArray;
    }

    protected void addNewPathResource() {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.core.model.ITranslationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        String string = CPathEntryMessages.getString("IncludeSymbolEntryPage.newResource.title");
        String string2 = CPathEntryMessages.getString("IncludeSymbolEntryPage.newResource.description");
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new CElementContentProvider());
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)this.fCurrCProject);
        elementTreeSelectionDialog.setInitialSelection((Object)this.fCurrCProject);
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            IResource iResource = objectArray[0] instanceof IResource ? (IResource)objectArray[0] : ((ICElement)objectArray[0]).getResource();
            CPElementGroup cPElementGroup = new CPElementGroup(iResource);
            if (!this.fIncludeSymPathsList.getElements().contains(cPElementGroup)) {
                List list = this.fIncludeSymPathsList.getElements();
                int n = 0;
                while (n < list.size()) {
                    CPElementGroup cPElementGroup2 = (CPElementGroup)list.get(n);
                    if (cPElementGroup2.getPath().isPrefixOf(cPElementGroup.getPath())) {
                        CPElement[] cPElementArray = cPElementGroup2.getChildren();
                        int n2 = 0;
                        while (n2 < cPElementArray.length) {
                            if (cPElementArray[n2].getInherited() == null) {
                                switch (cPElementArray[n2].getEntryKind()) {
                                    case 4: 
                                    case 6: {
                                        this.addPathToResourceGroup(cPElementArray[n2], null, cPElementGroup);
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
                this.fIncludeSymPathsList.addElement(cPElementGroup);
            }
            this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElementGroup));
            this.fIncludeSymPathsList.expandElement(cPElementGroup, 1);
        }
    }

    protected void addSymbol(CPElement cPElement) {
        CharSequence charSequence;
        InputDialog inputDialog;
        if (cPElement == null) {
            inputDialog = new InputDialog(this.getShell(), CPathEntryMessages.getString("IncludeSymbolEntryPage.addSymbol.title"), CPathEntryMessages.getString("IncludeSymbolEntryPage.addSymbol.message"), "", null);
        } else {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append((String)cPElement.getAttribute("macroname"));
            ((StringBuffer)charSequence).append('=');
            ((StringBuffer)charSequence).append((String)cPElement.getAttribute("macrovalue"));
            inputDialog = new InputDialog(this.getShell(), CPathEntryMessages.getString("IncludeSymbolEntryPage.editSymbol.title"), CPathEntryMessages.getString("IncludeSymbolEntryPage.editSymbol.message"), ((StringBuffer)charSequence).toString(), null);
        }
        charSequence = null;
        if (inputDialog.open() == 0 && (charSequence = inputDialog.getValue()) != null && ((String)charSequence).length() > 0) {
            String string;
            CPElementGroup cPElementGroup = this.getSelectedGroup();
            CPElement cPElement2 = new CPElement(this.fCurrCProject, 6, cPElementGroup.getResource().getFullPath(), cPElementGroup.getResource());
            String string2 = "";
            int n = ((String)charSequence).indexOf("=");
            if (n != -1) {
                string = ((String)charSequence).substring(0, n).trim();
                string2 = ((String)charSequence).substring(n + 1).trim();
            } else {
                string = ((String)charSequence).trim();
            }
            if (cPElement != null) {
                cPElement.setAttribute("macroname", string);
                cPElement.setAttribute("macrovalue", string2);
                this.updatePathOnResourceGroups(cPElement, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
            } else {
                cPElement2.setAttribute("macroname", string);
                cPElement2.setAttribute("macrovalue", string2);
                if (!cPElementGroup.contains(cPElement2)) {
                    this.addPathToResourceGroups(cPElement2, cPElementGroup, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement2));
                }
                this.updateStatus();
            }
        }
    }

    protected void addInclude(CPElement cPElement) {
        SelectPathInputDialog selectPathInputDialog = cPElement == null ? new SelectPathInputDialog(this.getShell(), CPathEntryMessages.getString("IncludeSymbolEntryPage.addExternal.title"), CPathEntryMessages.getString("IncludeSymbolEntryPage.addExternal.message"), null, null) : new SelectPathInputDialog(this.getShell(), CPathEntryMessages.getString("IncludeSymbolEntryPage.editExternal.title"), CPathEntryMessages.getString("IncludeSymbolEntryPage.editExternal.message"), ((IPath)cPElement.getAttribute("includepath")).toOSString(), null);
        String string = null;
        if (selectPathInputDialog.open() == 0 && (string = selectPathInputDialog.getValue()) != null && !string.equals("")) {
            if (cPElement == null) {
                CPElementGroup cPElementGroup = this.getSelectedGroup();
                CPElement cPElement2 = new CPElement(this.fCurrCProject, 4, cPElementGroup.getResource().getFullPath(), cPElementGroup.getResource());
                cPElement2.setAttribute("includepath", new Path(string));
                if (!cPElementGroup.contains(cPElement2)) {
                    this.addPathToResourceGroups(cPElement2, cPElementGroup, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement2));
                }
            } else {
                cPElement.setAttribute("includepath", new Path(string));
                this.updatePathOnResourceGroups(cPElement, this.fIncludeSymPathsList.getElements());
                this.fIncludeSymPathsList.refresh();
            }
            this.updateStatus();
        }
    }

    protected void addFromWorkspace() {
        CPElement[] cPElementArray = this.openWorkspacePathEntryDialog(null);
        if (cPElementArray != null && cPElementArray.length > 0) {
            int n = cPElementArray.length;
            CPElementGroup cPElementGroup = this.getSelectedGroup();
            int n2 = 0;
            while (n2 < n) {
                CPElement cPElement = cPElementArray[n2];
                if (!cPElementGroup.contains(cPElement)) {
                    this.addPathToResourceGroups(cPElement, cPElementGroup, this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement));
                    this.updateStatus();
                }
                ++n2;
            }
        }
    }

    protected void addContributed() {
        CPElement[] cPElementArray = this.openContainerSelectionDialog(null);
        if (cPElementArray != null && cPElementArray.length > 0) {
            int n = cPElementArray.length;
            CPElementGroup cPElementGroup = this.getSelectedGroup();
            int n2 = 0;
            while (n2 < n) {
                CPElement cPElement = cPElementArray[n2];
                if (!cPElementGroup.contains(cPElement)) {
                    this.addPathToResourceGroups(cPElement, this.getSelectedGroup(), this.fIncludeSymPathsList.getElements());
                    this.fIncludeSymPathsList.refresh();
                    this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection((Object)cPElement));
                    this.updateStatus();
                }
                ++n2;
            }
        }
    }

    protected CPElement[] openWorkspacePathEntryDialog(CPElement cPElement) {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, cPElement == null);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        String string = cPElement == null ? CPathEntryMessages.getString("IncludeSymbolEntryPage.fromWorkspaceDialog.new.title") : CPathEntryMessages.getString("IncludeSymbolEntryPage.fromWorkspaceDialog.edit.title");
        String string2 = cPElement == null ? CPathEntryMessages.getString("IncludeSymbolEntryPage.fromWorkspaceDialog.new.description") : CPathEntryMessages.getString("IncludeSymbolEntryPage.fromWorkspaceDialog.edit.description");
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new CElementContentProvider());
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)CoreModel.getDefault().getCModel());
        if (cPElement == null) {
            elementTreeSelectionDialog.setInitialSelection((Object)this.fCurrCProject);
        } else {
            elementTreeSelectionDialog.setInitialSelection((Object)cPElement.getCProject());
        }
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            CPElement[] cPElementArray = new CPElement[objectArray.length];
            int n = 0;
            while (n < cPElementArray.length) {
                IPath iPath;
                IProject iProject;
                if (objectArray[n] instanceof IResource) {
                    iProject = ((IResource)objectArray[n]).getProject();
                    iPath = ((IResource)objectArray[n]).getProjectRelativePath();
                } else {
                    iProject = ((ICElement)objectArray[n]).getCProject().getProject();
                    iPath = ((ICElement)objectArray[n]).getResource().getProjectRelativePath();
                }
                CPElementGroup cPElementGroup = this.getSelectedGroup();
                cPElementArray[n] = new CPElement(this.fCurrCProject, 4, cPElementGroup.getResource().getFullPath(), cPElementGroup.getResource());
                cPElementArray[n].setAttribute("base-path", iProject.getFullPath().makeRelative());
                cPElementArray[n].setAttribute("includepath", iPath);
                ++n;
            }
            return cPElementArray;
        }
        return null;
    }

    protected CPElement[] openContainerSelectionDialog(CPElement cPElement) {
        String string;
        IPathEntry iPathEntry = null;
        if (cPElement == null) {
            string = CPathEntryMessages.getString("IncludeSymbolEntryPage.ContainerDialog.new.title");
        } else {
            string = CPathEntryMessages.getString("IncludeSymbolEntryPage.ContainerDialog.edit.title");
            iPathEntry = cPElement.getPathEntry();
        }
        CPathContainerWizard cPathContainerWizard = new CPathContainerWizard(iPathEntry, null, (ICElement)this.fCurrCProject, this.getRawPathEntries(), new int[]{4, 6});
        cPathContainerWizard.setWindowTitle(string);
        if (CPathContainerWizard.openWizard(this.getShell(), cPathContainerWizard) == 0) {
            IPathEntry iPathEntry2 = cPathContainerWizard.getEntriesParent();
            IPathEntry[] iPathEntryArray = cPathContainerWizard.getEntries();
            if (iPathEntryArray != null) {
                CPElement[] cPElementArray = new CPElement[iPathEntryArray.length];
                CPElementGroup cPElementGroup = this.getSelectedGroup();
                int n = 0;
                while (n < cPElementArray.length) {
                    if (iPathEntryArray[n].getEntryKind() == 4) {
                        cPElementArray[n] = new CPElement(this.fCurrCProject, 4, cPElementGroup.getResource().getFullPath(), cPElementGroup.getResource());
                        cPElementArray[n].setAttribute("includepath", ((IIncludeEntry)iPathEntryArray[n]).getIncludePath());
                        cPElementArray[n].setAttribute("base-ref", iPathEntry2.getPath());
                    } else if (iPathEntryArray[n].getEntryKind() == 6) {
                        cPElementArray[n] = new CPElement(this.fCurrCProject, 6, cPElementGroup.getResource().getFullPath(), cPElementGroup.getResource());
                        cPElementArray[n].setAttribute("macroname", ((IMacroEntry)iPathEntryArray[n]).getMacroName());
                        cPElementArray[n].setAttribute("base-ref", iPathEntry2.getPath());
                    }
                    ++n;
                }
                return cPElementArray;
            }
            return new CPElement[]{CPElement.createFromExisting(iPathEntry2, this.fCurrCProject)};
        }
        return null;
    }

    public List getSelection() {
        return this.fIncludeSymPathsList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fIncludeSymPathsList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 4 || n == 6;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    public List getCPaths() {
        ArrayList<CPElement> arrayList = new ArrayList<CPElement>();
        List list = this.fIncludeSymPathsList.getElements();
        int n = 0;
        while (n < list.size()) {
            CPElementGroup cPElementGroup = (CPElementGroup)list.get(n);
            CPElement[] cPElementArray = cPElementGroup.getChildren();
            int n2 = 0;
            while (n2 < cPElementArray.length) {
                if (cPElementArray[n2].getInherited() == null) {
                    arrayList.add(cPElementArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private class IncludeSymbolAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        IncludeSymbolAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CPathIncludeSymbolEntryPage.this.ListCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            CPathIncludeSymbolEntryPage.this.listPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            CPathIncludeSymbolEntryPage.this.ListPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            CPathIncludeSymbolEntryPage.this.ListPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren();
            }
            if (object instanceof CPElementGroup) {
                return ((CPElementGroup)object).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementGroup) {
                return ((CPElementGroup)object).getParent();
            }
            if (object instanceof CPElement) {
                return ((CPElement)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementGroup) {
                return true;
            }
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren().length > 0;
            }
            return false;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CPathIncludeSymbolEntryPage.this.listPageDialogFieldChanged(dialogField);
        }
    }

    private class SelectPathInputDialog
    extends InputDialog {
        public SelectPathInputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
            super(shell, string, string2, string3, iInputValidator);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            Button button = this.createButton(composite, 3, CPathEntryMessages.getString("IncludeSymbolEntryPage.addExternal.button.browse"), false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SelectPathInputDialog this$1;
                {
                    this.this$1 = selectPathInputDialog;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string;
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.this$1.getShell(), 4096);
                    directoryDialog.setText(CPathEntryMessages.getString("IncludeSymbolEntryPage.browseForFolder"));
                    String string2 = SelectPathInputDialog.access$0(this.this$1).getText();
                    if (string2 != null && string2.trim().length() != 0) {
                        directoryDialog.setFilterPath(string2);
                    }
                    if ((string = directoryDialog.open()) != null) {
                        SelectPathInputDialog.access$0(this.this$1).setText(string);
                    }
                }
            });
        }

        static /* synthetic */ Text access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

