/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ArchiveFileFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.SourceAttachmentDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathLibraryEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private TreeListDialogField fLibrariesList;
    private IWorkspaceRoot fWorkspaceRoot;
    private final int IDX_ADD_LIBEXT = 0;
    private final int IDX_ADD_LIB = 1;
    private final int IDX_ADD_CONTRIBUTED = 2;
    private final int IDX_EDIT = 4;
    private final int IDX_REMOVE = 5;
    private final int IDX_EXPORT = 7;
    static /* synthetic */ Class class$0;

    public CPathLibraryEntryPage(ListDialogField listDialogField) {
        super(CPathEntryMessages.getString("LibrariesEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("LibrariesEntryPage.description"));
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = listDialogField;
        LibrariesAdapter librariesAdapter = new LibrariesAdapter();
        String[] stringArray = new String[8];
        stringArray[0] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.addextlib.button");
        stringArray[1] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.addworkspacelib.button");
        stringArray[2] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.addcontriblib.button");
        stringArray[4] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.edit.button");
        stringArray[5] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.remove.button");
        stringArray[7] = CPathEntryMessages.getString("LibrariesEntryPage.libraries.export.button");
        String[] stringArray2 = stringArray;
        this.fLibrariesList = new TreeListDialogField(librariesAdapter, stringArray2, (ILabelProvider)new CPElementLabelProvider());
        this.fLibrariesList.setDialogFieldListener(librariesAdapter);
        this.fLibrariesList.setLabelText(CPathEntryMessages.getString("LibrariesEntryPage.libraries.label"));
        this.fLibrariesList.setViewerSorter(new CPElementSorter());
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.enableButton(5, false);
        this.fLibrariesList.enableButton(7, false);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.ar_obj.gif");
    }

    public void init(ICProject iCProject) {
        this.fCurrCProject = iCProject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List list = this.filterList(this.fCPathList.getElements());
        this.fLibrariesList.setElements(list);
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 1;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fLibrariesList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(n);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPElementSorter());
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_libraries");
    }

    private void libraryPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 1: {
                objectArray = this.openLibFileDialog(null);
                break;
            }
            case 0: {
                objectArray = this.openExtLibFileDialog(null);
                break;
            }
            case 2: {
                objectArray = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                this.editEntry();
                return;
            }
            case 5: {
                this.removeEntry();
                return;
            }
            case 7: {
                this.exportEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fLibrariesList.getElements();
            ArrayList<CPElement> arrayList = new ArrayList<CPElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                CPElement cPElement = objectArray[n3];
                if (!list.contains(cPElement) && !arrayList.contains(cPElement)) {
                    arrayList.add(cPElement);
                }
                ++n3;
            }
            this.fLibrariesList.addElements(arrayList);
            this.fCPathList.addElements(arrayList);
            if (n == 1) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    private boolean canExport(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPElement) {
                CPElement cPElement = (CPElement)e;
                if (cPElement.getParentContainer() != null) {
                    return false;
                }
                IPath iPath = (IPath)cPElement.getAttribute("base-ref");
                if (iPath != null && !iPath.equals((Object)Path.EMPTY)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private void exportEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fLibrariesList.getIndexOfElement(e) != -1) {
            ((CPElement)e).setExported(!((CPElement)e).isExported());
            this.fLibrariesList.refresh(e);
        }
    }

    protected void libraryPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void libraryPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fLibrariesList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof CPElementAttribute) {
                CPElementAttribute cPElementAttribute = (CPElementAttribute)e;
                cPElementAttribute.getParent().setAttribute(cPElementAttribute.getKey(), null);
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fCPathList.removeElements(list);
            this.fLibrariesList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            CPElement cPElement;
            Object e = list.get(n);
            if (e instanceof CPElementAttribute ? ((CPElementAttribute)e).getValue() == null : e instanceof CPElement && (cPElement = (CPElement)e).getParentContainer() != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void editEntry() {
        List list = this.fLibrariesList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fLibrariesList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPElement)e);
        } else if (e instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)e);
        }
    }

    private void editAttributeEntry(CPElementAttribute cPElementAttribute) {
        String string = cPElementAttribute.getKey();
        if (string.equals("sourcepath")) {
            CPElement cPElement = cPElementAttribute.getParent();
            ILibraryEntry iLibraryEntry = (ILibraryEntry)cPElement.getPathEntry();
            SourceAttachmentDialog sourceAttachmentDialog = new SourceAttachmentDialog(this.getShell(), iLibraryEntry, this.fCurrCProject, true);
            if (sourceAttachmentDialog.open() == 0) {
                cPElement.setAttribute("sourcepath", sourceAttachmentDialog.getSourceAttachmentPath());
                this.fLibrariesList.refresh();
                this.fCPathList.refresh();
            }
        }
    }

    private void editElementEntry(CPElement cPElement) {
        Object object;
        CPElement[] cPElementArray = null;
        switch (cPElement.getEntryKind()) {
            case 1: {
                object = (IPath)cPElement.getAttribute("librarypath");
                cPElementArray = object.isAbsolute() ? this.openExtLibFileDialog(cPElement) : this.openLibFileDialog(cPElement);
            }
        }
        if (cPElementArray != null && cPElementArray.length > 0) {
            object = cPElementArray[0];
            ((CPElement)object).setExported(cPElement.isExported());
            this.fLibrariesList.replaceElement(cPElement, object);
        }
    }

    private void libraryPageSelectionChanged(DialogField dialogField) {
        List list = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(4, this.canEdit(list));
        this.fLibrariesList.enableButton(5, this.canRemove(list));
        this.fLibrariesList.enableButton(7, this.canExport(list));
    }

    private IFile[] getUsedLibFiles(CPElement cPElement) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        List list = this.fLibrariesList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            CPElement cPElement2 = (CPElement)list.get(n);
            if (cPElement2.getEntryKind() == 1 && cPElement2 != cPElement && (iResource = cPElement2.getResource()) instanceof IFile) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private CPElement newCPLibraryElement(IPath iPath) {
        CPElement cPElement = new CPElement(this.fCurrCProject, 1, this.fProjPath, null);
        cPElement.setAttribute("librarypath", iPath);
        return cPElement;
    }

    private CPElement[] openExtLibFileDialog(CPElement cPElement) {
        String string;
        String string2 = CPathEntryMessages.getString("LibrariesEntryPage.ExtLibDialog.new.title");
        FileDialog fileDialog = new FileDialog(this.getShell(), cPElement == null ? 2 : 4);
        fileDialog.setText(string2);
        fileDialog.setFilterExtensions(new String[]{"*.a;*.so;*.dll;*.lib"});
        if (cPElement != null) {
            fileDialog.setFileName(cPElement.getPath().lastSegment());
        }
        if ((string = fileDialog.open()) == null) {
            return null;
        }
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        Path path = new Path(fileDialog.getFilterPath());
        CPElement[] cPElementArray = new CPElement[n];
        int n2 = 0;
        while (n2 < n) {
            IPath iPath = path.append(stringArray[n2]).makeAbsolute();
            cPElementArray[n2] = this.newCPLibraryElement(iPath);
            ++n2;
        }
        return cPElementArray;
    }

    private CPElement[] openLibFileDialog(CPElement cPElement) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, cPElement == null);
        ArchiveFileFilter archiveFileFilter = new ArchiveFileFilter(this.getUsedLibFiles(cPElement), true);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        String string = cPElement == null ? CPathEntryMessages.getString("LibrariesEntryPage.ExtLibDialog.new.title") : CPathEntryMessages.getString("LibrariesEntryPage.ExtLibDialog.edit.title");
        String string2 = cPElement == null ? CPathEntryMessages.getString("LibrariesEntryPage.ExtLibDialog.new.description") : CPathEntryMessages.getString("LibrariesEntryPage.ExtLibDialog.edit.description");
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.addFilter((ViewerFilter)archiveFileFilter);
        elementTreeSelectionDialog.setInput((Object)this.fWorkspaceRoot);
        elementTreeSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (cPElement == null) {
            elementTreeSelectionDialog.setInitialSelection((Object)this.fCurrCProject.getProject());
        } else {
            elementTreeSelectionDialog.setInitialSelection((Object)cPElement.getResource());
        }
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            CPElement[] cPElementArray = new CPElement[objectArray.length];
            int n = 0;
            while (n < cPElementArray.length) {
                IPath iPath = ((IResource)objectArray[n]).getLocation();
                cPElementArray[n] = this.newCPLibraryElement(iPath);
                ++n;
            }
            return cPElementArray;
        }
        return null;
    }

    protected IPathEntry[] getRawPathEntries() {
        IPathEntry[] iPathEntryArray = new IPathEntry[this.fCPathList.getSize()];
        int n = 0;
        while (n < iPathEntryArray.length) {
            CPElement cPElement = (CPElement)this.fCPathList.getElement(n);
            iPathEntryArray[n] = cPElement.getPathEntry();
            ++n;
        }
        return iPathEntryArray;
    }

    protected CPElement[] openContainerSelectionDialog(CPElement cPElement) {
        String string;
        IPathEntry iPathEntry = null;
        if (cPElement == null) {
            string = CPathEntryMessages.getString("LibrariesEntryPage.ContainerDialog.new.title");
        } else {
            string = CPathEntryMessages.getString("LibrariesEntryPage.ContainerDialog.edit.title");
            iPathEntry = cPElement.getPathEntry();
        }
        CPathContainerWizard cPathContainerWizard = new CPathContainerWizard(iPathEntry, null, (ICElement)this.fCurrCProject, this.getRawPathEntries(), new int[]{1});
        cPathContainerWizard.setWindowTitle(string);
        if (CPathContainerWizard.openWizard(this.getShell(), cPathContainerWizard) == 0) {
            IPathEntry iPathEntry2 = cPathContainerWizard.getEntriesParent();
            IPathEntry[] iPathEntryArray = cPathContainerWizard.getEntries();
            if (iPathEntryArray != null) {
                CPElement[] cPElementArray = new CPElement[iPathEntryArray.length];
                int n = 0;
                while (n < cPElementArray.length) {
                    cPElementArray[n] = new CPElement(this.fCurrCProject, 1, this.fProjPath, null);
                    cPElementArray[n].setAttribute("librarypath", ((ILibraryEntry)iPathEntryArray[n]).getLibraryPath());
                    cPElementArray[n].setAttribute("base-ref", iPathEntry2.getPath());
                    ++n;
                }
                return cPElementArray;
            }
        }
        return null;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            CPElement cPElement = (CPElement)e;
            return !(cPElement.getResource() instanceof IFolder) && cPElement.getParentContainer() == null;
        }
        return e instanceof CPElementAttribute;
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CPathLibraryEntryPage.this.libraryPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            CPathLibraryEntryPage.this.libraryPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            CPathLibraryEntryPage.this.libraryPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            CPathLibraryEntryPage.this.libraryPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementAttribute) {
                return ((CPElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return false;
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

