/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.MultipleFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewSourceFolderDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathOutputEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fOutputList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPathOutputEntryPage(ListDialogField listDialogField) {
        super(CPathEntryMessages.getString("OutputPathEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("OutputPathEntryPage.description"));
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = listDialogField;
        OutputContainerAdapter outputContainerAdapter = new OutputContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = CPathEntryMessages.getString("OutputPathEntryPage.folders.add.button");
        stringArray[2] = CPathEntryMessages.getString("OutputPathEntryPage.folders.edit.button");
        stringArray[3] = CPathEntryMessages.getString("OutputPathEntryPage.folders.remove.button");
        String[] stringArray2 = stringArray;
        this.fOutputList = new TreeListDialogField(outputContainerAdapter, stringArray2, (ILabelProvider)new CPElementLabelProvider());
        this.fOutputList.setDialogFieldListener(outputContainerAdapter);
        this.fOutputList.setLabelText(CPathEntryMessages.getString("OutputPathEntryPage.folders.label"));
        this.fOutputList.setViewerSorter(new CPElementSorter());
        this.fOutputList.enableButton(2, false);
        this.fOutputList.enableButton(3, false);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.container_obj.gif");
    }

    public void init(ICProject iCProject) {
        this.fCurrCProject = iCProject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        List list = this.filterList(this.fCPathList.getElements());
        this.fOutputList.setElements(list);
        int n = 0;
        while (n < list.size()) {
            CPElement cPElement = (CPElement)list.get(n);
            IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
            if (iPathArray.length > 0) {
                this.fOutputList.expandElement(cPElement, 3);
            }
            ++n;
        }
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fOutputList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fOutputList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fOutputList.setButtonsMinWidth(n);
        List list = this.fOutputList.getElements();
        int n2 = 0;
        while (n2 < list.size()) {
            CPElement cPElement = (CPElement)list.get(n2);
            IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
            if (iPathArray.length > 0) {
                this.fOutputList.expandElement(cPElement, 3);
            }
            ++n2;
        }
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_output");
    }

    protected void outputPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fOutputList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void outputPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list;
        if (treeListDialogField == this.fOutputList && this.canEdit(list = treeListDialogField.getSelectedElements())) {
            this.editEntry();
        }
    }

    private boolean hasFolders(IContainer iContainer) {
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IContainer) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void outputPageCustomButtonPressed(DialogField dialogField, int n) {
        if (dialogField == this.fOutputList) {
            if (n == 0) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>(10);
                IProject iProject = this.fCurrCProject.getProject();
                if (iProject.exists()) {
                    if (this.hasFolders((IContainer)iProject)) {
                        object = this.openOutputContainerDialog(null);
                        if (object != null) {
                            int n2 = 0;
                            while (n2 < ((CPElement[])object).length) {
                                arrayList.add(object[n2]);
                                ++n2;
                            }
                        }
                    } else {
                        object = this.openNewOutputContainerDialog(null, true);
                        if (object != null) {
                            arrayList.add(object);
                        }
                    }
                } else {
                    object = this.openNewOutputContainerDialog(null, false);
                    if (object != null) {
                        arrayList.add(object);
                    }
                }
                if (!arrayList.isEmpty()) {
                    object = new HashSet();
                    this.askForAddingExclusionPatternsDialog(arrayList, (Set)object);
                    this.fOutputList.addElements(arrayList);
                    this.fOutputList.postSetSelection((ISelection)new StructuredSelection(arrayList));
                    if (!((HashSet)object).isEmpty()) {
                        Iterator iterator = ((HashSet)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.fOutputList.refresh(e);
                            this.fOutputList.expandElement(e, 3);
                        }
                    }
                }
            } else if (n == 2) {
                this.editEntry();
            } else if (n == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List list = this.fOutputList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fOutputList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPElement)e);
        } else if (e instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)e);
        }
    }

    private void editElementEntry(CPElement cPElement) {
        CPElement cPElement2 = null;
        cPElement2 = this.openNewOutputContainerDialog(cPElement, true);
        if (cPElement2 != null) {
            this.fOutputList.replaceElement(cPElement, cPElement2);
        }
    }

    private void editAttributeEntry(CPElementAttribute cPElementAttribute) {
        String string = cPElementAttribute.getKey();
        if (string.equals("exclusion")) {
            CPElement cPElement = cPElementAttribute.getParent();
            ExclusionPatternDialog exclusionPatternDialog = new ExclusionPatternDialog(this.getShell(), cPElement);
            if (exclusionPatternDialog.open() == 0) {
                cPElement.setAttribute("exclusion", exclusionPatternDialog.getExclusionPattern());
                this.fOutputList.refresh();
                this.fCPathList.dialogFieldChanged();
            }
        }
    }

    protected void outputPageSelectionChanged(DialogField dialogField) {
        List list = this.fOutputList.getSelectedElements();
        this.fOutputList.enableButton(2, this.canEdit(list));
        this.fOutputList.enableButton(3, this.canRemove(list));
    }

    private void removeEntry() {
        List list = this.fOutputList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof CPElementAttribute) {
                CPElementAttribute cPElementAttribute = (CPElementAttribute)e;
                String string = cPElementAttribute.getKey();
                Path[] pathArray = string.equals("exclusion") ? new Path[]{} : null;
                cPElementAttribute.getParent().setAttribute(string, pathArray);
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fOutputList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fOutputList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            if (e instanceof CPElementAttribute ? (((CPElementAttribute)(object = (CPElementAttribute)e)).getKey().equals("exclusion") ? ((IPath[])((CPElementAttribute)object).getValue()).length == 0 : ((CPElementAttribute)object).getValue() == null) : e instanceof CPElement && ((CPElement)(object = (CPElement)e)).getParentContainer() != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            return false;
        }
        return e instanceof CPElementAttribute;
    }

    private void outputPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrCProject == null) {
            return;
        }
        if (dialogField == this.fOutputList) {
            this.updateCPathList();
        }
    }

    private void updateCPathList() {
        int n;
        List list = this.fOutputList.getElements();
        List list2 = this.fCPathList.getElements();
        int n2 = n = list2.size();
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            CPElement cPElement = (CPElement)list2.get(n4);
            int n5 = cPElement.getEntryKind();
            if (this.isEntryKind(n5)) {
                if (!list.remove(cPElement)) {
                    list2.remove(n4);
                    n2 = n4;
                } else if (n2 == n) {
                    n3 = n4 + 1;
                }
            }
            --n4;
        }
        if (!list.isEmpty()) {
            n4 = Math.min(n3, n2);
            list2.addAll(n4, list);
        }
        if (n2 != n || !list.isEmpty()) {
            this.fCPathList.setElements(list2);
        }
    }

    private CPElement openNewOutputContainerDialog(CPElement cPElement, boolean bl) {
        if (bl) {
            NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrCProject.getProject());
            if (newFolderDialog.open() == 0) {
                IResource iResource = (IResource)newFolderDialog.getResult()[0];
                return this.newCPOutputElement(iResource);
            }
            return null;
        }
        String string = cPElement == null ? CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.new.title") : CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.edit.title");
        IProject iProject = this.fCurrCProject.getProject();
        NewSourceFolderDialog newSourceFolderDialog = new NewSourceFolderDialog(this.getShell(), string, iProject, this.getExistingContainers(cPElement), cPElement);
        newSourceFolderDialog.setMessage(CPathEntryMessages.getFormattedString("SourcePathEntryPage.NewSourceFolderDialog.description", this.fProjPath.toString()));
        if (newSourceFolderDialog.open() == 0) {
            IContainer iContainer = newSourceFolderDialog.getSourceFolder();
            return this.newCPOutputElement((IResource)iContainer);
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List list, Set set) {
        this.fixNestingConflicts(list, this.fOutputList.getElements(), set);
        if (!set.isEmpty()) {
            String string = CPathEntryMessages.getString("OutputPathEntryPage.exclusion_added.title");
            String string2 = CPathEntryMessages.getString("OutputPathEntryPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
        }
    }

    private CPElement[] openOutputContainerDialog(CPElement cPElement) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        List list = this.getExistingContainers(null);
        IProject[] iProjectArray = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
        IProject iProject = this.fCurrCProject.getProject();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].equals((Object)iProject)) {
                arrayList.add(iProjectArray[n]);
            }
            ++n;
        }
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2, arrayList.toArray());
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider baseWorkbenchContentProvider = new BaseWorkbenchContentProvider();
        String string = cPElement == null ? CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.new.title") : CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.edit.title");
        String string2 = cPElement == null ? CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.new.description") : CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.edit.description");
        MultipleFolderSelectionDialog multipleFolderSelectionDialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)baseWorkbenchContentProvider);
        multipleFolderSelectionDialog.setExisting(list.toArray());
        multipleFolderSelectionDialog.setTitle(string);
        multipleFolderSelectionDialog.setMessage(string2);
        multipleFolderSelectionDialog.addFilter(typedViewerFilter);
        multipleFolderSelectionDialog.setInput(this.fCurrCProject.getProject().getParent());
        if (cPElement == null) {
            multipleFolderSelectionDialog.setInitialFocus(this.fCurrCProject.getProject());
        } else {
            multipleFolderSelectionDialog.setInitialFocus(cPElement.getResource());
        }
        if (multipleFolderSelectionDialog.open() == 0) {
            Object[] objectArray = multipleFolderSelectionDialog.getResult();
            CPElement[] cPElementArray = new CPElement[objectArray.length];
            int n2 = 0;
            while (n2 < cPElementArray.length) {
                IResource iResource = (IResource)objectArray[n2];
                cPElementArray[n2] = this.newCPOutputElement(iResource);
                ++n2;
            }
            return cPElementArray;
        }
        return null;
    }

    private List getExistingContainers(CPElement cPElement) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        List list = this.fOutputList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            CPElement cPElement2 = (CPElement)list.get(n);
            if (cPElement2 != cPElement && (iResource = cPElement2.getResource()) instanceof IContainer) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList;
    }

    private CPElement newCPOutputElement(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        return new CPElement(this.fCurrCProject, 7, iResource.getFullPath(), iResource);
    }

    public List getSelection() {
        return this.fOutputList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fOutputList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 7;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    private class OutputContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        OutputContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CPathOutputEntryPage.this.outputPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            CPathOutputEntryPage.this.outputPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            CPathOutputEntryPage.this.outputPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            CPathOutputEntryPage.this.outputPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementAttribute) {
                return ((CPElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return object instanceof CPElement;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CPathOutputEntryPage.this.outputPageDialogFieldChanged(dialogField);
        }
    }
}

