/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class CPathProjectsEntryPage
extends CPathBasePage {
    private CheckedListDialogField fProjectsList;
    ICProject fCurrCProject;
    private ListDialogField fCPathList;

    public CPathProjectsEntryPage(ListDialogField listDialogField) {
        super(CPathEntryMessages.getString("ProjectsEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectsEntryPage.description"));
        ProjectsListListener projectsListListener = new ProjectsListListener();
        String[] stringArray = new String[]{CPathEntryMessages.getString("ProjectsEntryPage.projects.checkall.button"), CPathEntryMessages.getString("ProjectsEntryWorkbookPage.projects.uncheckall.button")};
        this.fProjectsList = new CheckedListDialogField(null, stringArray, (ILabelProvider)new CPElementLabelProvider());
        this.fProjectsList.setDialogFieldListener(projectsListListener);
        this.fProjectsList.setLabelText(CPathEntryMessages.getString("ProjectsEntryPage.projects.label"));
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.fProjectsList.setViewerSorter(new CPElementSorter());
        this.fCPathList = listDialogField;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fProjectsList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getListControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(n);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_projects");
    }

    public void init(ICProject iCProject) {
        this.updateProjectsList(iCProject);
    }

    void updateProjectsList(ICProject iCProject) {
        ICModel iCModel = iCProject.getCModel();
        ArrayList<CPElement> arrayList = new ArrayList<CPElement>();
        ArrayList<CPElement> arrayList2 = new ArrayList<CPElement>();
        try {
            CPElement cPElement;
            ICProject[] iCProjectArray = iCModel.getCProjects();
            ArrayList<Object> arrayList3 = new ArrayList<Object>(iCProjectArray.length);
            arrayList3.add(iCProject.getProject());
            List list = this.fCPathList.getElements();
            int n = list.size() - 1;
            while (n >= 0) {
                cPElement = (CPElement)list.get(n);
                if (this.isEntryKind(cPElement.getEntryKind())) {
                    arrayList3.add(cPElement.getResource());
                    arrayList.add(cPElement);
                    arrayList2.add(cPElement);
                }
                --n;
            }
            n = 0;
            while (n < iCProjectArray.length) {
                cPElement = iCProjectArray[n].getProject();
                if (!arrayList3.contains(cPElement)) {
                    arrayList.add(new CPElement(this.fCurrCProject, 2, cPElement.getFullPath(), (IResource)cPElement));
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {
            CUIPlugin.getDefault().log(cModelException);
        }
        this.fProjectsList.setElements(arrayList);
        this.fProjectsList.setCheckedElements(arrayList2);
        this.fCurrCProject = iCProject;
    }

    void updateCPathList() {
        List list = this.fProjectsList.getCheckedElements();
        boolean bl = false;
        List list2 = this.fCPathList.getElements();
        int n = list2.size() - 1;
        while (n >= 0) {
            CPElement cPElement = (CPElement)list2.get(n);
            if (this.isEntryKind(cPElement.getEntryKind()) && !list.remove(cPElement)) {
                list2.remove(n);
                bl = true;
            }
            --n;
        }
        n = 0;
        while (n < list.size()) {
            list2.add(list.get(n));
            ++n;
        }
        if (bl || list.size() > 0) {
            this.fCPathList.setElements(list2);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 2;
    }

    private class ProjectsListListener
    implements IDialogFieldListener {
        ProjectsListListener() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (CPathProjectsEntryPage.this.fCurrCProject != null) {
                CPathProjectsEntryPage.this.updateCPathList();
            }
        }
    }
}

