/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.MultipleFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewSourceFolderDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathSourceEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fFoldersList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPathSourceEntryPage(ListDialogField listDialogField) {
        super(CPathEntryMessages.getString("SourcePathEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("SourcePathEntryPage.description"));
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = listDialogField;
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = CPathEntryMessages.getString("SourcePathEntryPage.folders.add.button");
        stringArray[2] = CPathEntryMessages.getString("SourcePathEntryPath.folders.edit.button");
        stringArray[3] = CPathEntryMessages.getString("SourcePathEntryPage.folders.remove.button");
        String[] stringArray2 = stringArray;
        this.fFoldersList = new TreeListDialogField(sourceContainerAdapter, stringArray2, (ILabelProvider)new CPElementLabelProvider());
        this.fFoldersList.setDialogFieldListener(sourceContainerAdapter);
        this.fFoldersList.setLabelText(CPathEntryMessages.getString("SourcePathEntryPage.folders.label"));
        this.fFoldersList.setViewerSorter(new CPElementSorter());
        this.fFoldersList.enableButton(2, false);
        this.fFoldersList.enableButton(3, false);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.sroot_obj.gif");
    }

    public void init(ICProject iCProject) {
        this.fCurrCProject = iCProject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        List list = this.filterList(this.fCPathList.getElements());
        this.fFoldersList.setElements(list);
        int n = 0;
        while (n < list.size()) {
            CPElement cPElement = (CPElement)list.get(n);
            IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
            if (iPathArray.length > 0) {
                this.fFoldersList.expandElement(cPElement, 3);
            }
            ++n;
        }
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fFoldersList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(n);
        List list = this.fFoldersList.getElements();
        int n2 = 0;
        while (n2 < list.size()) {
            CPElement cPElement = (CPElement)list.get(n2);
            IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
            if (iPathArray.length > 0) {
                this.fFoldersList.expandElement(cPElement, 3);
            }
            ++n2;
        }
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_source");
    }

    protected void sourcePageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fFoldersList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list;
        if (treeListDialogField == this.fFoldersList && this.canEdit(list = treeListDialogField.getSelectedElements())) {
            this.editEntry();
        }
    }

    private boolean hasFolders(IContainer iContainer) {
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IContainer) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void sourcePageCustomButtonPressed(DialogField dialogField, int n) {
        if (dialogField == this.fFoldersList) {
            if (n == 0) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>(10);
                IProject iProject = this.fCurrCProject.getProject();
                if (iProject.exists()) {
                    if (this.hasFolders((IContainer)iProject)) {
                        object = this.openSourceContainerDialog(null);
                        if (object != null) {
                            int n2 = 0;
                            while (n2 < ((CPElement[])object).length) {
                                arrayList.add(object[n2]);
                                ++n2;
                            }
                        }
                    } else {
                        object = this.openNewSourceContainerDialog(null, true);
                        if (object != null) {
                            arrayList.add(object);
                        }
                    }
                } else {
                    object = this.openNewSourceContainerDialog(null, false);
                    if (object != null) {
                        arrayList.add(object);
                    }
                }
                if (!arrayList.isEmpty()) {
                    object = new HashSet();
                    this.askForAddingExclusionPatternsDialog(arrayList, (Set)object);
                    this.fFoldersList.addElements(arrayList);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(arrayList));
                    if (!((HashSet)object).isEmpty()) {
                        Iterator iterator = ((HashSet)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.fFoldersList.refresh(e);
                            this.fFoldersList.expandElement(e, 3);
                        }
                    }
                }
            } else if (n == 2) {
                this.editEntry();
            } else if (n == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List list = this.fFoldersList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fFoldersList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPElement)e);
        } else if (e instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)e);
        }
    }

    private void editElementEntry(CPElement cPElement) {
        CPElement cPElement2 = null;
        cPElement2 = this.openNewSourceContainerDialog(cPElement, true);
        if (cPElement2 != null) {
            this.fFoldersList.replaceElement(cPElement, cPElement2);
        }
    }

    private void editAttributeEntry(CPElementAttribute cPElementAttribute) {
        String string = cPElementAttribute.getKey();
        if (string.equals("exclusion")) {
            CPElement cPElement = cPElementAttribute.getParent();
            ExclusionPatternDialog exclusionPatternDialog = new ExclusionPatternDialog(this.getShell(), cPElement);
            if (exclusionPatternDialog.open() == 0) {
                cPElement.setAttribute("exclusion", exclusionPatternDialog.getExclusionPattern());
                this.fFoldersList.refresh();
                this.fCPathList.dialogFieldChanged();
            }
        }
    }

    protected void sourcePageSelectionChanged(DialogField dialogField) {
        List list = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(list));
        this.fFoldersList.enableButton(3, this.canRemove(list));
    }

    private void removeEntry() {
        List list = this.fFoldersList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof CPElementAttribute) {
                CPElementAttribute cPElementAttribute = (CPElementAttribute)e;
                String string = cPElementAttribute.getKey();
                Path[] pathArray = string.equals("exclusion") ? new Path[]{} : null;
                cPElementAttribute.getParent().setAttribute(string, pathArray);
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fFoldersList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object object;
            Object e = list.get(n);
            if (e instanceof CPElementAttribute ? (((CPElementAttribute)(object = (CPElementAttribute)e)).getKey().equals("exclusion") ? ((IPath[])((CPElementAttribute)object).getValue()).length == 0 : ((CPElementAttribute)object).getValue() == null) : e instanceof CPElement && ((CPElement)(object = (CPElement)e)).getParentContainer() != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPElement) {
            return false;
        }
        return e instanceof CPElementAttribute;
    }

    private void sourcePageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrCProject == null) {
            return;
        }
        if (dialogField == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int n;
        List list = this.fFoldersList.getElements();
        List list2 = this.fCPathList.getElements();
        int n2 = n = list2.size();
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            CPElement cPElement = (CPElement)list2.get(n4);
            int n5 = cPElement.getEntryKind();
            if (this.isEntryKind(n5)) {
                if (!list.remove(cPElement)) {
                    list2.remove(n4);
                    n2 = n4;
                } else if (n2 == n) {
                    n3 = n4 + 1;
                }
            }
            --n4;
        }
        if (!list.isEmpty()) {
            n4 = Math.min(n3, n2);
            list2.addAll(n4, list);
        }
        if (n2 != n || !list.isEmpty()) {
            this.fCPathList.setElements(list2);
        }
    }

    private CPElement openNewSourceContainerDialog(CPElement cPElement, boolean bl) {
        if (bl) {
            NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrCProject.getProject());
            if (newFolderDialog.open() == 0) {
                IResource iResource = (IResource)newFolderDialog.getResult()[0];
                return this.newCPSourceElement(iResource);
            }
            return null;
        }
        String string = cPElement == null ? CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.new.title") : CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.edit.title");
        IProject iProject = this.fCurrCProject.getProject();
        NewSourceFolderDialog newSourceFolderDialog = new NewSourceFolderDialog(this.getShell(), string, iProject, this.getExistingContainers(cPElement), cPElement);
        newSourceFolderDialog.setMessage(CPathEntryMessages.getFormattedString("SourcePathEntryPage.NewSourceFolderDialog.description", this.fProjPath.toString()));
        if (newSourceFolderDialog.open() == 0) {
            IContainer iContainer = newSourceFolderDialog.getSourceFolder();
            return this.newCPSourceElement((IResource)iContainer);
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List list, Set set) {
        this.fixNestingConflicts(list, this.fFoldersList.getElements(), set);
        if (!set.isEmpty()) {
            String string = CPathEntryMessages.getString("SourcePathEntryPage.exclusion_added.title");
            String string2 = CPathEntryMessages.getString("SourcePathEntryPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
        }
    }

    private CPElement[] openSourceContainerDialog(CPElement cPElement) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        List list = this.getExistingContainers(null);
        IProject[] iProjectArray = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray.length);
        IProject iProject = this.fCurrCProject.getProject();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].equals((Object)iProject)) {
                arrayList.add(iProjectArray[n]);
            }
            ++n;
        }
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2, arrayList.toArray());
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider baseWorkbenchContentProvider = new BaseWorkbenchContentProvider();
        String string = cPElement == null ? CPathEntryMessages.getString("SourcePathEntryPage.ExistingSourceFolderDialog.new.title") : CPathEntryMessages.getString("SourcePathEntryPage.ExistingSourceFolderDialog.edit.title");
        String string2 = cPElement == null ? CPathEntryMessages.getString("SourcePathEntryPage.ExistingSourceFolderDialog.new.description") : CPathEntryMessages.getString("SourcePathEntryPage.ExistingSourceFolderDialog.edit.description");
        MultipleFolderSelectionDialog multipleFolderSelectionDialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)baseWorkbenchContentProvider);
        multipleFolderSelectionDialog.setExisting(list.toArray());
        multipleFolderSelectionDialog.setTitle(string);
        multipleFolderSelectionDialog.setMessage(string2);
        multipleFolderSelectionDialog.addFilter(typedViewerFilter);
        multipleFolderSelectionDialog.setInput(this.fCurrCProject.getProject().getParent());
        if (cPElement == null) {
            multipleFolderSelectionDialog.setInitialFocus(this.fCurrCProject.getProject());
        } else {
            multipleFolderSelectionDialog.setInitialFocus(cPElement.getResource());
        }
        if (multipleFolderSelectionDialog.open() == 0) {
            Object[] objectArray = multipleFolderSelectionDialog.getResult();
            CPElement[] cPElementArray = new CPElement[objectArray.length];
            int n2 = 0;
            while (n2 < cPElementArray.length) {
                IResource iResource = (IResource)objectArray[n2];
                cPElementArray[n2] = this.newCPSourceElement(iResource);
                ++n2;
            }
            return cPElementArray;
        }
        return null;
    }

    private List getExistingContainers(CPElement cPElement) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        List list = this.fFoldersList.getElements();
        int n = 0;
        while (n < list.size()) {
            IResource iResource;
            CPElement cPElement2 = (CPElement)list.get(n);
            if (cPElement2 != cPElement && (iResource = cPElement2.getResource()) instanceof IContainer) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList;
    }

    private CPElement newCPSourceElement(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        return new CPElement(this.fCurrCProject, 3, iResource.getFullPath(), iResource);
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List list) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(list));
    }

    public boolean isEntryKind(int n) {
        return n == 3;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
    }

    public void performDefaults() {
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            CPathSourceEntryPage.this.sourcePageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            CPathSourceEntryPage.this.sourcePageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            CPathSourceEntryPage.this.sourcePageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            CPathSourceEntryPage.this.sourcePageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElement) {
                return ((CPElement)object).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPElementAttribute) {
                return ((CPElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return object instanceof CPElement;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CPathSourceEntryPage.this.sourcePageDialogFieldChanged(dialogField);
        }
    }
}

