/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.AbstractPathOptionBlock;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathLibraryEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathOutputEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathProjectsEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathSourceEntryPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CPathTabBlock
extends AbstractPathOptionBlock {
    private int[] pathTypes = new int[]{3, 2, 7, 1, 5};
    private ListDialogField fCPathList;
    private CPathSourceEntryPage fSourcePage;
    private CPathProjectsEntryPage fProjectsPage;
    private CPathOutputEntryPage fOutputPage;
    private CPathContainerEntryPage fContainerPage;
    private CPathLibraryEntryPage fLibrariesPage;

    void buildPathDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fCPathList) {
            this.updateCPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public CPathTabBlock(IStatusChangeListener iStatusChangeListener, int n) {
        super(iStatusChangeListener, n);
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.getString("CPathsBlock.path.up.button");
        stringArray[1] = CPathEntryMessages.getString("CPathsBlock.path.down.button");
        stringArray[3] = CPathEntryMessages.getString("CPathsBlock.path.checkall.button");
        stringArray[4] = CPathEntryMessages.getString("CPathsBlock.path.uncheckall.button");
        String[] stringArray2 = stringArray;
        BuildPathAdapter buildPathAdapter = new BuildPathAdapter();
        this.fCPathList = new ListDialogField(null, stringArray2, null);
        this.fCPathList.setDialogFieldListener(buildPathAdapter);
    }

    protected List getCPaths() {
        return this.fCPathList.getElements();
    }

    protected void addTabs() {
        this.fSourcePage = new CPathSourceEntryPage(this.fCPathList);
        this.addPage(this.fSourcePage);
        this.fOutputPage = new CPathOutputEntryPage(this.fCPathList);
        this.addPage(this.fOutputPage);
        this.fProjectsPage = new CPathProjectsEntryPage(this.fCPathList);
        this.addPage(this.fProjectsPage);
        this.fLibrariesPage = new CPathLibraryEntryPage(this.fCPathList);
        this.addPage(this.fLibrariesPage);
        this.fContainerPage = new CPathContainerEntryPage(this.fCPathList);
        this.addPage(this.fContainerPage);
    }

    public Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        if (this.getCProject() != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    protected void initialize(ICElement iCElement, List list) {
        this.fCPathList.setElements(list);
        if (this.fProjectsPage != null) {
            this.fSourcePage.init(this.getCProject());
            this.fOutputPage.init(this.getCProject());
            this.fProjectsPage.init(this.getCProject());
            this.fContainerPage.init(this.getCProject());
            this.fLibrariesPage.init(this.getCProject());
        }
        this.doStatusLineUpdate();
        this.initializeTimeStamps();
    }

    protected int[] getFilteredTypes() {
        return this.pathTypes;
    }

    public void updateCPathStatus() {
        this.getPathStatus().setOK();
        List list = this.fCPathList.getElements();
        CPElement cPElement = null;
        int n = 0;
        IPathEntry[] iPathEntryArray = new IPathEntry[list.size()];
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            CPElement cPElement2 = (CPElement)list.get(n2);
            iPathEntryArray[n2] = cPElement2.getPathEntry();
            if (cPElement2.getStatus().getSeverity() != 0) {
                ++n;
                if (cPElement == null) {
                    cPElement = cPElement2;
                }
            }
            --n2;
        }
        if (n > 0) {
            if (n == 1) {
                this.getPathStatus().setWarning(cPElement.getStatus().getMessage());
            } else {
                this.getPathStatus().setWarning(CPathEntryMessages.getFormattedString("CPElement.status.multiplePathErrors", String.valueOf(n)));
            }
        }
        this.updateBuildPathStatus();
    }

    private class BuildPathAdapter
    implements IDialogFieldListener {
        BuildPathAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            CPathTabBlock.this.buildPathDialogFieldChanged(dialogField);
        }
    }
}

