/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternEntryDialog;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ExclusionPatternDialog
extends StatusDialog {
    private ListDialogField fExclusionPatternList;
    private CPElement fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExclusionPatternDialog(Shell shell, CPElement cPElement) {
        super(shell);
        this.fCurrElement = cPElement;
        this.setTitle(CPathEntryMessages.getString("ExclusionPatternDialog.title"));
        String string = CPathEntryMessages.getFormattedString("ExclusionPatternDialog.pattern.label", cPElement.getPath().makeRelative().toString());
        String[] stringArray = new String[5];
        stringArray[0] = CPathEntryMessages.getString("ExclusionPatternDialog.pattern.add");
        stringArray[1] = CPathEntryMessages.getString("ExclusionPatternDialog.pattern.add.multiple");
        stringArray[2] = CPathEntryMessages.getString("ExclusionPatternDialog.pattern.edit");
        stringArray[4] = CPathEntryMessages.getString("ExclusionPatternDialog.pattern.remove");
        String[] stringArray2 = stringArray;
        ExclusionPatternAdapter exclusionPatternAdapter = new ExclusionPatternAdapter();
        this.fExclusionPatternList = new ListDialogField(exclusionPatternAdapter, stringArray2, (ILabelProvider)new ExclusionPatternLabelProvider());
        this.fExclusionPatternList.setDialogFieldListener(exclusionPatternAdapter);
        this.fExclusionPatternList.setLabelText(string);
        this.fExclusionPatternList.setRemoveButtonIndex(4);
        this.fExclusionPatternList.enableButton(2, false);
        this.fCurrProject = cPElement.getCProject().getProject();
        IWorkspaceRoot iWorkspaceRoot = this.fCurrProject.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(cPElement.getPath());
        if (iResource instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)iResource;
        }
        IPath[] iPathArray = (IPath[])cPElement.getAttribute("exclusion");
        ArrayList<String> arrayList = new ArrayList<String>(iPathArray.length);
        int n = 0;
        while (n < iPathArray.length) {
            arrayList.add(iPathArray[n].toString());
            ++n;
        }
        this.fExclusionPatternList.setElements(arrayList);
        this.fExclusionPatternList.selectFirstElement();
        this.fExclusionPatternList.enableButton(1, this.fCurrSourceFolder != null);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fExclusionPatternList.doFillIntoGrid(composite3, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doCustomButtonPressed(ListDialogField listDialogField, int n) {
        if (n == 0) {
            this.addEntry();
        } else if (n == 2) {
            this.editEntry();
        } else if (n == 1) {
            this.addMultipleEntries();
        }
    }

    protected void doDoubleClicked(ListDialogField listDialogField) {
        this.editEntry();
    }

    protected void doSelectionChanged(ListDialogField listDialogField) {
        List list = listDialogField.getSelectedElements();
        this.fExclusionPatternList.enableButton(2, this.canEdit(list));
    }

    private boolean canEdit(List list) {
        return list.size() == 1;
    }

    private void editEntry() {
        List list = this.fExclusionPatternList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        List list2 = this.fExclusionPatternList.getElements();
        String string = (String)list.get(0);
        ExclusionPatternEntryDialog exclusionPatternEntryDialog = new ExclusionPatternEntryDialog(this.getShell(), string, list2, this.fCurrElement);
        if (exclusionPatternEntryDialog.open() == 0) {
            this.fExclusionPatternList.replaceElement(string, exclusionPatternEntryDialog.getExclusionPattern());
        }
    }

    private void addEntry() {
        List list = this.fExclusionPatternList.getElements();
        ExclusionPatternEntryDialog exclusionPatternEntryDialog = new ExclusionPatternEntryDialog(this.getShell(), null, list, this.fCurrElement);
        if (exclusionPatternEntryDialog.open() == 0) {
            this.fExclusionPatternList.addElement(exclusionPatternEntryDialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    public IPath[] getExclusionPattern() {
        IPath[] iPathArray = new IPath[this.fExclusionPatternList.getSize()];
        int n = 0;
        while (n < iPathArray.length) {
            String string = (String)this.fExclusionPatternList.getElement(n);
            iPathArray[n] = new Path(string);
            ++n;
        }
        return iPathArray;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    private void addMultipleEntries() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, true);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        Object var6_6 = null;
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setTitle(CPathEntryMessages.getString("ExclusionPatternDialog.ChooseExclusionPattern.title"));
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setMessage(CPathEntryMessages.getString("ExclusionPatternDialog.ChooseExclusionPattern.description"));
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)this.fCurrSourceFolder);
        elementTreeSelectionDialog.setInitialSelection(var6_6);
        elementTreeSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (elementTreeSelectionDialog.open() == 0) {
            Object[] objectArray = elementTreeSelectionDialog.getResult();
            int n = this.fCurrSourceFolder.getFullPath().segmentCount();
            int n2 = 0;
            while (n2 < objectArray.length) {
                IResource iResource = (IResource)objectArray[n2];
                IPath iPath = iResource.getFullPath().removeFirstSegments(n).makeRelative();
                String string = iResource instanceof IContainer ? iPath.addTrailingSeparator().toString() : iPath.toString();
                this.fExclusionPatternList.addElement(string);
                ++n2;
            }
        }
    }

    private static class ExclusionPatternLabelProvider
    extends LabelProvider {
        ExclusionPatternLabelProvider() {
        }

        public Image getImage(Object object) {
            ImageDescriptorRegistry imageDescriptorRegistry = CUIPlugin.getImageDescriptorRegistry();
            return imageDescriptorRegistry.get(CPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
        }

        public String getText(Object object) {
            return (String)object;
        }
    }

    private class ExclusionPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        ExclusionPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            ExclusionPatternDialog.this.doCustomButtonPressed(listDialogField, n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            ExclusionPatternDialog.this.doSelectionChanged(listDialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            ExclusionPatternDialog.this.doDoubleClicked(listDialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

