/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ExclusionPatternEntryDialog
extends StatusDialog {
    private StringButtonDialogField fExclusionPatternDialog;
    private StatusInfo fExclusionPatternStatus;
    private IContainer fCurrSourceFolder;
    private String fExclusionPattern;
    private List fExistingPatterns;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExclusionPatternEntryDialog(Shell shell, String string, List list, CPElement cPElement) {
        super(shell);
        this.fExistingPatterns = list;
        if (string == null) {
            this.setTitle(CPathEntryMessages.getString("ExclusionPatternEntryDialog.add.title"));
        } else {
            this.setTitle(CPathEntryMessages.getString("ExclusionPatternEntryDialog.edit.title"));
            this.fExistingPatterns.remove(string);
        }
        IWorkspaceRoot iWorkspaceRoot = cPElement.getCProject().getProject().getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(cPElement.getPath());
        if (iResource instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)iResource;
        }
        this.fExclusionPatternStatus = new StatusInfo();
        String string2 = CPathEntryMessages.getFormattedString("ExclusionPatternEntryDialog.pattern.label", cPElement.getPath().makeRelative().toString());
        ExclusionPatternAdapter exclusionPatternAdapter = new ExclusionPatternAdapter();
        this.fExclusionPatternDialog = new StringButtonDialogField(exclusionPatternAdapter);
        this.fExclusionPatternDialog.setLabelText(string2);
        this.fExclusionPatternDialog.setButtonLabel(CPathEntryMessages.getString("ExclusionPatternEntryDialog.pattern.button"));
        this.fExclusionPatternDialog.setDialogFieldListener(exclusionPatternAdapter);
        this.fExclusionPatternDialog.enableButton(this.fCurrSourceFolder != null);
        if (string == null) {
            this.fExclusionPatternDialog.setText("");
        } else {
            this.fExclusionPatternDialog.setText(string.toString());
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        int n = this.convertWidthInCharsToPixels(60);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 64);
        label.setText(CPathEntryMessages.getString("ExclusionPatternEntryDialog.description"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        label.setLayoutData((Object)gridData);
        this.fExclusionPatternDialog.doFillIntoGrid(composite3, 3);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getLabelControl(null), n);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternDialog.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternDialog.getTextControl(null));
        this.fExclusionPatternDialog.postSetFocusOnDialogField(composite.getDisplay());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doChangeControlPressed() {
        IPath iPath = this.chooseExclusionPattern();
        if (iPath != null) {
            this.fExclusionPatternDialog.setText(iPath.toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fExclusionPatternStatus);
    }

    protected void checkIfPatternValid() {
        String string = this.fExclusionPatternDialog.getText().trim();
        if (string.length() == 0) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.getString("ExclusionPatternEntryDialog.error.empty"));
            return;
        }
        Path path = new Path(string);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.getString("ExclusionPatternEntryDialog.error.notrelative"));
            return;
        }
        if (this.fExistingPatterns.contains(string)) {
            this.fExclusionPatternStatus.setError(CPathEntryMessages.getString("ExclusionPatternEntryDialog.error.exists"));
            return;
        }
        this.fExclusionPattern = string;
        this.fExclusionPatternStatus.setOK();
    }

    public String getExclusionPattern() {
        return this.fExclusionPattern;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    private IPath chooseExclusionPattern() {
        IResource iResource;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        Path path = new Path(this.fExclusionPatternDialog.getText());
        IResource iResource2 = null;
        IContainer iContainer = this.fCurrSourceFolder;
        int n = path.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            iResource = iContainer.findMember(path.segment(n2));
            if (iResource != null) {
                iResource2 = iResource;
            }
            if (!(iResource instanceof IContainer)) break;
            iContainer = (IContainer)iResource;
            ++n2;
        }
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setTitle(CPathEntryMessages.getString("ExclusionPatternEntryDialog.ChooseExclusionPattern.title"));
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setMessage(CPathEntryMessages.getString("ExclusionPatternEntryDialog.ChooseExclusionPattern.description"));
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)this.fCurrSourceFolder);
        elementTreeSelectionDialog.setInitialSelection((Object)iResource2);
        elementTreeSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (elementTreeSelectionDialog.open() == 0) {
            iResource = (IResource)elementTreeSelectionDialog.getFirstResult();
            IPath iPath = iResource.getFullPath().removeFirstSegments(this.fCurrSourceFolder.getFullPath().segmentCount()).makeRelative();
            if (iResource instanceof IContainer) {
                return iPath.addTrailingSeparator();
            }
            return iPath;
        }
        return null;
    }

    private class ExclusionPatternAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        ExclusionPatternAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ExclusionPatternEntryDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField dialogField) {
            ExclusionPatternEntryDialog.this.doChangeControlPressed();
        }
    }
}

