/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewIncludesSymbolsTabBlock;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class IncludesSymbolsPropertyPage
extends PropertyPage
implements IStatusChangeListener,
IPathEntryStoreListener {
    private static final String PAGE_SETTINGS = "IncludeSysmbolsPropertyPage";
    private static final String INDEX = "pageIndex";
    NewIncludesSymbolsTabBlock fIncludesSymbolsBlock;
    IPathEntryStore fStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite composite) {
        Control control;
        IProject iProject = this.getProject();
        if (iProject == null || !this.isCProject(iProject)) {
            control = this.createWithoutCProject(composite);
        } else if (!iProject.isOpen()) {
            control = this.createForClosedProject(composite);
        } else {
            try {
                this.fStore = CoreModel.getPathEntryStore((IProject)this.getProject());
                this.fStore.addPathEntryStoreListener((IPathEntryStoreListener)this);
            }
            catch (CoreException coreException) {}
            control = this.createWithCProject(composite, iProject);
        }
        Dialog.applyDialogFont((Control)control);
        this.noDefaultAndApplyButton();
        return control;
    }

    private IDialogSettings getSettings() {
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(PAGE_SETTINGS);
            iDialogSettings2.put(INDEX, 3);
        }
        return iDialogSettings2;
    }

    private Control createWithCProject(Composite composite, IProject iProject) {
        this.fIncludesSymbolsBlock = new NewIncludesSymbolsTabBlock(this, this.getSettings().getInt(INDEX));
        this.fIncludesSymbolsBlock.init(this.getCElement(), null);
        return this.fIncludesSymbolsBlock.createContents(composite);
    }

    private Control createWithoutCProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(CPathEntryMessages.getString("CPathsPropertyPage.no_C_project.message"));
        this.fIncludesSymbolsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(CPathEntryMessages.getString("CPathsPropertyPage.closed_project.message"));
        this.fIncludesSymbolsBlock = null;
        this.setValid(true);
        return label;
    }

    public void dispose() {
        if (this.fStore != null) {
            this.fStore.removePathEntryStoreListener((IPathEntryStoreListener)this);
        }
    }

    public void setVisible(boolean bl) {
        if (this.fIncludesSymbolsBlock != null) {
            if (!bl) {
                if (this.fIncludesSymbolsBlock.hasChangesInDialog()) {
                    String string = CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.title");
                    String string2 = CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.message");
                    String[] stringArray = new String[]{CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.button.save"), CPathEntryMessages.getString("CPathsPropertyPage.unsavedchanges.button.discard")};
                    MessageDialog messageDialog = new MessageDialog(this.getShell(), string, null, string2, 3, stringArray, 0);
                    int n = messageDialog.open();
                    if (n == 0) {
                        this.performOk();
                    } else if (n == 1) {
                        this.fIncludesSymbolsBlock.init(this.getCElement(), null);
                    }
                }
            } else if (!this.fIncludesSymbolsBlock.hasChangesInDialog() && this.fIncludesSymbolsBlock.hasChangesInCPathFile()) {
                this.fIncludesSymbolsBlock.init(this.getCElement(), null);
            }
        }
        super.setVisible(bl);
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            return iResource.getProject();
        }
        return null;
    }

    private ICElement getCElement() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICElement iCElement = (ICElement)iAdaptable.getAdapter((Class)clazz);
            return iCElement;
        }
        return null;
    }

    private boolean isCProject(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fIncludesSymbolsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludesSymbolsBlock.getPageIndex());
            Shell shell = this.getControl().getShell();
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IncludesSymbolsPropertyPage.this.fIncludesSymbolsBlock.configureCProject(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
            try {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = CPathEntryMessages.getString("CPathsPropertyPage.error.title");
                String string2 = CPathEntryMessages.getString("CPathsPropertyPage.error.message");
                ExceptionHandler.handle(invocationTargetException, shell, string, string2);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    public boolean performCancel() {
        if (this.fIncludesSymbolsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludesSymbolsBlock.getPageIndex());
        }
        return super.performCancel();
    }

    public void pathEntryStoreChanged(PathEntryStoreChangedEvent pathEntryStoreChangedEvent) {
        Control control;
        if (pathEntryStoreChangedEvent.hasContentChanged() && (control = this.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control control = IncludesSymbolsPropertyPage.this.getControl();
                    if (control != null && !control.isDisposed()) {
                        IncludesSymbolsPropertyPage.this.fIncludesSymbolsBlock.init(IncludesSymbolsPropertyPage.this.getCElement(), null);
                    }
                }
            });
        }
    }
}

