/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class MultipleFolderSelectionDialog
extends SelectionStatusDialog
implements ISelectionChangedListener {
    private CheckboxTreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private List fFilters;
    private Object fInput;
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;
    private Set fExisting;
    private Object fFocusElement;

    public MultipleFolderSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
        super(shell);
        this.fLabelProvider = iLabelProvider;
        this.fContentProvider = iTreeContentProvider;
        this.setSelectionResult(null);
        this.setStatusLineAboveButtons(true);
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.fExisting = null;
        this.fFocusElement = null;
        this.fFilters = null;
    }

    public void setExisting(Object[] objectArray) {
        this.fExisting = new HashSet();
        int n = 0;
        while (n < objectArray.length) {
            this.fExisting.add(objectArray[n]);
            ++n;
        }
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(viewerFilter);
    }

    protected void cancelPressed() {
        this.setSelectionResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        Object[] objectArray = this.fViewer.getCheckedElements();
        if (this.fExisting == null) {
            if (objectArray.length == 0) {
                objectArray = null;
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (!this.fExisting.contains(object)) {
                    arrayList.add(object);
                }
                ++n;
            }
            objectArray = !arrayList.isEmpty() ? arrayList.toArray() : (Object[])null;
        }
        this.setSelectionResult(objectArray);
    }

    void access$superCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                MultipleFolderSelectionDialog.this.access$superCreate();
                MultipleFolderSelectionDialog.this.fViewer.setCheckedElements(MultipleFolderSelectionDialog.this.getInitialElementSelections().toArray());
                MultipleFolderSelectionDialog.this.fViewer.expandToLevel(2);
                if (MultipleFolderSelectionDialog.this.fExisting != null) {
                    Iterator iterator = MultipleFolderSelectionDialog.this.fExisting.iterator();
                    while (iterator.hasNext()) {
                        MultipleFolderSelectionDialog.this.fViewer.reveal(iterator.next());
                    }
                }
                MultipleFolderSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected CheckboxTreeViewer createTreeViewer(Composite composite) {
        this.fViewer = new CheckboxTreeViewer(composite, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                MultipleFolderSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        if (this.fFilters != null) {
            int n = 0;
            while (n != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(n));
                ++n;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected void updateOKStatus() {
        this.computeResult();
        if (this.getResult() != null) {
            this.updateStatus(new StatusInfo());
        } else {
            this.updateStatus(new StatusInfo(4, ""));
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        CheckboxTreeViewer checkboxTreeViewer = this.createTreeViewer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.heightHint = this.convertHeightInCharsToPixels(18);
        Tree tree = checkboxTreeViewer.getTree();
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite2.getFont());
        Button button = new Button(composite2, 8);
        button.setText(CPathEntryMessages.getString("MultipleFolderSelectionDialog.button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MultipleFolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(composite2.getFont());
        gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        button.setLayoutData((Object)gridData);
        this.fNewFolderButton = button;
        checkboxTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fExisting != null) {
            Object[] objectArray = this.fExisting.toArray();
            checkboxTreeViewer.setGrayedElements(objectArray);
            this.setInitialSelections(objectArray);
        }
        if (this.fFocusElement != null) {
            checkboxTreeViewer.setSelection((ISelection)new StructuredSelection(this.fFocusElement), true);
        }
        checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                MultipleFolderSelectionDialog.this.forceExistingChecked(checkStateChangedEvent);
            }
        });
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void forceExistingChecked(CheckStateChangedEvent checkStateChangedEvent) {
        Object object;
        if (this.fExisting != null && this.fExisting.contains(object = checkStateChangedEvent.getElement())) {
            this.fViewer.setChecked(object, true);
        }
    }

    private void updateNewFolderButtonState() {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        this.fSelectedContainer = null;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)object;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (newFolderDialog.open() == 0) {
            CheckboxTreeViewer checkboxTreeViewer = this.fViewer;
            checkboxTreeViewer.refresh((Object)this.fSelectedContainer);
            Object object = newFolderDialog.getResult()[0];
            checkboxTreeViewer.reveal(object);
            checkboxTreeViewer.setChecked(object, true);
            checkboxTreeViewer.setSelection((ISelection)new StructuredSelection(object));
            this.updateOKStatus();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateNewFolderButtonState();
    }

    public void setInitialFocus(Object object) {
        this.fFocusElement = object;
    }
}

