/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewSourceFolderDialog
extends StatusDialog {
    private SelectionButtonDialogField fUseProjectButton;
    private SelectionButtonDialogField fUseFolderButton;
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IContainer fFolder;
    private List fExistingFolders;
    private IProject fCurrProject;

    public NewSourceFolderDialog(Shell shell, String string, IProject iProject, List list, CPElement cPElement) {
        super(shell);
        this.setTitle(string);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        this.fUseProjectButton = new SelectionButtonDialogField(16);
        this.fUseProjectButton.setLabelText(CPathEntryMessages.getString("NewSourceFolderDialog.useproject.button"));
        this.fUseProjectButton.setDialogFieldListener(sourceContainerAdapter);
        this.fUseFolderButton = new SelectionButtonDialogField(16);
        this.fUseFolderButton.setLabelText(CPathEntryMessages.getString("NewSourceFolderDialog.usefolder.button"));
        this.fUseFolderButton.setDialogFieldListener(sourceContainerAdapter);
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(sourceContainerAdapter);
        this.fContainerDialogField.setLabelText(CPathEntryMessages.getString("NewSourceFolderDialog.sourcefolder.label"));
        this.fUseFolderButton.attachDialogField(this.fContainerDialogField);
        this.fFolder = null;
        this.fExistingFolders = list;
        this.fCurrProject = iProject;
        boolean bl = true;
        if (cPElement == null) {
            this.fContainerDialogField.setText("");
        } else {
            IPath iPath = cPElement.getPath().removeFirstSegments(1);
            this.fContainerDialogField.setText(iPath.toString());
            bl = !iPath.isEmpty();
        }
        this.fUseFolderButton.setSelection(bl);
        this.fUseProjectButton.setSelection(!bl);
    }

    public void setMessage(String string) {
        this.fContainerDialogField.setLabelText(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        int n = this.convertWidthInCharsToPixels(50);
        GridData gridData = new GridData(768);
        gridData.widthHint = n;
        if (this.fExistingFolders.contains(this.fCurrProject)) {
            this.fContainerDialogField.doFillIntoGrid(composite3, 2);
        } else {
            int n2;
            this.fUseProjectButton.doFillIntoGrid(composite3, 1);
            this.fUseFolderButton.doFillIntoGrid(composite3, 1);
            this.fContainerDialogField.getTextControl(composite3);
            gridData.horizontalIndent = n2 = this.convertWidthInCharsToPixels(3);
        }
        Text text = this.fContainerDialogField.getTextControl(null);
        text.setLayoutData((Object)gridData);
        this.fContainerDialogField.postSetFocusOnDialogField(composite.getDisplay());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        IProject iProject = null;
        if (this.fUseFolderButton.isSelected()) {
            String string = this.fContainerDialogField.getText();
            if (string.length() == 0) {
                this.fContainerFieldStatus.setError(CPathEntryMessages.getString("NewSourceFolderDialog.error.enterpath"));
                return;
            }
            IPath iPath = this.fCurrProject.getFullPath().append(string);
            IWorkspace iWorkspace = this.fCurrProject.getWorkspace();
            IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 2);
            if (!iStatus.isOK()) {
                this.fContainerFieldStatus.setError(CPathEntryMessages.getFormattedString("NewSourceFolderDialog.error.invalidpath", iStatus.getMessage()));
                return;
            }
            iProject = this.fCurrProject.getFolder(string);
        } else {
            iProject = this.fCurrProject;
        }
        if (this.isExisting((IContainer)iProject)) {
            this.fContainerFieldStatus.setError(CPathEntryMessages.getString("NewSourceFolderDialog.error.pathexists"));
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = iProject;
    }

    private boolean isExisting(IContainer iContainer) {
        return this.fExistingFolders.contains(iContainer);
    }

    public IContainer getSourceFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        SourceContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewSourceFolderDialog.this.doStatusLineUpdate();
        }
    }
}

