/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectContainerPage
extends WizardPage
implements ICPathContainerPage {
    private int[] fFilterType;
    private TableViewer viewer;
    private ICProject fCProject;

    protected ProjectContainerPage(int[] nArray) {
        super("projectContainerPage");
        this.setTitle(CPathEntryMessages.getString("ProjectContainerPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectContainerPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fFilterType = nArray;
        this.validatePage();
    }

    public void initialize(ICProject iCProject, IPathEntry[] iPathEntryArray) {
        this.fCProject = iCProject;
    }

    public boolean finish() {
        return true;
    }

    public IPathEntry[] getContainerEntries() {
        ISelection iSelection;
        ICProject iCProject;
        if (this.viewer != null && (iCProject = (ICProject)SelectionUtil.getSingleElement(iSelection = this.viewer.getSelection())) != null) {
            return new IPathEntry[]{CoreModel.newProjectEntry((IPath)iCProject.getPath())};
        }
        return new IPathEntry[0];
    }

    public void setSelection(IPathEntry iPathEntry) {
        if (iPathEntry != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)iPathEntry));
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(CPathEntryMessages.getString("ProjectContainerPage.label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.viewer = new TableViewer(composite2, 2820);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ProjectContainerPage.this.validatePage();
            }
        });
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gridData);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return !object2.equals(ProjectContainerPage.this.fCProject);
            }
        });
        this.setControl((Control)composite2);
        this.initializeView();
        this.validatePage();
    }

    private void initializeView() {
        ArrayList<ICProject> arrayList = new ArrayList<ICProject>();
        try {
            List<IPathEntry> list = Arrays.asList(this.fCProject.getRawPathEntries());
            ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
            int n = 0;
            while (n < iCProjectArray.length) {
                boolean bl = false;
                if (!iCProjectArray[n].equals(this.fCProject) && !list.contains(CoreModel.newProjectEntry((IPath)iCProjectArray[n].getPath()))) {
                    IPathEntry[] iPathEntryArray = iCProjectArray[n].getRawPathEntries();
                    int n2 = 0;
                    while (n2 < iPathEntryArray.length) {
                        int n3 = 0;
                        while (n3 < this.fFilterType.length) {
                            if (iPathEntryArray[n2].getEntryKind() == this.fFilterType[n3] && iPathEntryArray[n2].isExported()) {
                                arrayList.add(iCProjectArray[n]);
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (bl) break;
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        this.viewer.setInput(arrayList);
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    private IPathEntry getSelected() {
        return this.getContainerEntries().length > 0 ? this.getContainerEntries()[0] : null;
    }
}

