/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ArchiveFileFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.FolderSelectionDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceAttachmentBlock {
    private IStatusChangeListener fContext;
    private StringButtonDialogField fFileNameField;
    private SelectionButtonDialogField fWorkspaceButton;
    private SelectionButtonDialogField fExternalFolderButton;
    private IStatus fNameStatus;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private CLabel fFullPathResolvedLabel;
    private ICProject fProject;
    private ILibraryEntry fEntry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourceAttachmentBlock(IWorkspaceRoot iWorkspaceRoot, IStatusChangeListener iStatusChangeListener, ILibraryEntry iLibraryEntry) {
        this(iStatusChangeListener, iLibraryEntry, null);
    }

    public SourceAttachmentBlock(IStatusChangeListener iStatusChangeListener, ILibraryEntry iLibraryEntry, ICProject iCProject) {
        Assert.isNotNull(iLibraryEntry);
        this.fContext = iStatusChangeListener;
        this.fEntry = iLibraryEntry;
        this.fProject = iCProject;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fNameStatus = new StatusInfo();
        SourceAttachmentAdapter sourceAttachmentAdapter = new SourceAttachmentAdapter();
        this.fFileNameField = new StringButtonDialogField(sourceAttachmentAdapter);
        this.fFileNameField.setDialogFieldListener(sourceAttachmentAdapter);
        this.fFileNameField.setLabelText(CPathEntryMessages.getString("SourceAttachmentBlock.filename.label"));
        this.fFileNameField.setButtonLabel(CPathEntryMessages.getString("SourceAttachmentBlock.filename.externalfile.button"));
        this.fWorkspaceButton = new SelectionButtonDialogField(8);
        this.fWorkspaceButton.setDialogFieldListener(sourceAttachmentAdapter);
        this.fWorkspaceButton.setLabelText(CPathEntryMessages.getString("SourceAttachmentBlock.filename.internal.button"));
        this.fExternalFolderButton = new SelectionButtonDialogField(8);
        this.fExternalFolderButton.setDialogFieldListener(sourceAttachmentAdapter);
        this.fExternalFolderButton.setLabelText(CPathEntryMessages.getString("SourceAttachmentBlock.filename.externalfolder.button"));
        this.setDefaults();
    }

    public void setDefaults() {
        if (this.fEntry.getSourceAttachmentPath() != null) {
            this.fFileNameField.setText(this.fEntry.getSourceAttachmentPath().toString());
        } else {
            this.fFileNameField.setText("");
        }
    }

    public IPath getSourceAttachmentPath() {
        if (this.fFileNameField.getText().length() == 0) {
            return null;
        }
        return new Path(this.fFileNameField.getText());
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return null;
    }

    public Control createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.fSWTWidget = composite;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        int n = pixelConverter.convertWidthInCharsToPixels(60);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        Label label = new Label(composite2, 16384);
        label.setLayoutData((Object)gridData);
        label.setText(CPathEntryMessages.getFormattedString("SourceAttachmentBlock.message", this.fEntry.getLibraryPath().lastSegment()));
        this.fWorkspaceButton.doFillIntoGrid(composite2, 1);
        this.fFileNameField.doFillIntoGrid(composite2, 4);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        DialogField.createEmptySpace(composite2, 3);
        this.fExternalFolderButton.doFillIntoGrid(composite2, 1);
        this.fFileNameField.postSetFocusOnDialogField(composite.getDisplay());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void attachmentChangeControlPressed(DialogField dialogField) {
        IPath iPath;
        if (dialogField == this.fFileNameField && (iPath = this.chooseExtJarFile()) != null) {
            this.fFileNameField.setText(iPath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        } else {
            if (dialogField == this.fWorkspaceButton) {
                IPath iPath = this.chooseInternalJarFile();
                if (iPath != null) {
                    this.fFileNameField.setText(iPath.toString());
                }
                return;
            }
            if (dialogField == this.fExternalFolderButton) {
                IPath iPath = this.chooseExtFolder();
                if (iPath != null) {
                    this.fFileNameField.setText(iPath.toString());
                }
                return;
            }
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
        }
        IStatus iStatus = StatusUtil.getMostSevere(new IStatus[]{this.fNameStatus});
        this.fContext.statusChanged(iStatus);
    }

    private boolean canBrowseFileName() {
        return true;
    }

    private String getResolvedLabelString(String string, boolean bl) {
        IPath iPath = this.getResolvedPath((IPath)new Path(string));
        if (iPath != null) {
            if (bl) {
                return iPath.toOSString();
            }
            return iPath.toString();
        }
        return "";
    }

    private IPath getResolvedPath(IPath iPath) {
        return iPath;
    }

    private IStatus updateFileNameStatus() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fFileNameField.getText();
        if (string.length() == 0) {
            return statusInfo;
        }
        if (!Path.EMPTY.isValidPath(string)) {
            statusInfo.setError(CPathEntryMessages.getString("SourceAttachmentBlock.filename.error.notvalid"));
            return statusInfo;
        }
        Path path = new Path(string);
        File file = path.toFile();
        IResource iResource = this.fWorkspaceRoot.findMember((IPath)path);
        if (iResource != null && iResource.getLocation() != null) {
            file = iResource.getLocation().toFile();
        }
        if (!file.exists()) {
            String string2 = CPathEntryMessages.getFormattedString("SourceAttachmentBlock.filename.error.filenotexists", path.toString());
            statusInfo.setError(string2);
            return statusInfo;
        }
        return statusInfo;
    }

    private IPath chooseExtJarFile() {
        Path path = new Path(this.fFileNameField.getText());
        if (path.isEmpty()) {
            path = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)path)) {
            path = path.removeLastSegments(1);
        }
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(CPathEntryMessages.getString("SourceAttachmentBlock.extjardialog.text"));
        fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        fileDialog.setFilterPath(path.toOSString());
        String string = fileDialog.open();
        if (string != null) {
            return new Path(string).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        Path path = new Path(this.fFileNameField.getText());
        if (path.isEmpty()) {
            path = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)path)) {
            path = path.removeLastSegments(1);
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setText(CPathEntryMessages.getString("SourceAttachmentBlock.extfolderdialog.text"));
        directoryDialog.setFilterPath(path.toOSString());
        String string = directoryDialog.open();
        if (string != null) {
            return new Path(string).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternalJarFile() {
        String string = this.fFileNameField.getText();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false);
        ArchiveFileFilter archiveFileFilter = new ArchiveFileFilter(null, false);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        IResource iResource = null;
        if (string.length() > 0) {
            iResource = this.fWorkspaceRoot.findMember((IPath)new Path(string));
        }
        if (iResource == null) {
            iResource = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog folderSelectionDialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        folderSelectionDialog.setAllowMultiple(false);
        folderSelectionDialog.setValidator(typedElementSelectionValidator);
        folderSelectionDialog.addFilter(archiveFileFilter);
        folderSelectionDialog.setTitle(CPathEntryMessages.getString("SourceAttachmentBlock.intjardialog.title"));
        folderSelectionDialog.setMessage(CPathEntryMessages.getString("SourceAttachmentBlock.intjardialog.message"));
        folderSelectionDialog.setInput(this.fWorkspaceRoot);
        folderSelectionDialog.setInitialSelection(iResource);
        if (folderSelectionDialog.open() == 0) {
            IResource iResource2 = (IResource)folderSelectionDialog.getFirstResult();
            return iResource2.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return CUIPlugin.getActiveWorkbenchShell();
    }

    public IRunnableWithProgress getRunnable(ICProject iCProject, Shell shell) {
        this.fProject = iCProject;
        return this.getRunnable(shell);
    }

    public IRunnableWithProgress getRunnable(final Shell shell) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    SourceAttachmentBlock.this.attachSource(shell, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    protected void attachSource(Shell shell, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = this.fEntry.isExported();
        ILibraryEntry iLibraryEntry = CoreModel.newLibraryEntry((IPath)this.fEntry.getPath(), (IPath)this.fEntry.getBasePath(), (IPath)this.fEntry.getLibraryPath(), (IPath)this.getSourceAttachmentPath(), (IPath)this.getSourceAttachmentRootPath(), (IPath)this.getSourceAttachmentPrefixMapping(), (boolean)bl);
        this.updateProjectPathEntry(shell, this.fProject, iLibraryEntry, iProgressMonitor);
    }

    private void updateProjectPathEntry(Shell shell, ICProject iCProject, ILibraryEntry iLibraryEntry, IProgressMonitor iProgressMonitor) throws CModelException {
        IPathEntry[] iPathEntryArray = iCProject.getRawPathEntries();
        int n = iPathEntryArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n + 1);
        int n2 = iLibraryEntry.getEntryKind();
        IPath iPath = iLibraryEntry.getPath();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            IPathEntry iPathEntry = iPathEntryArray[n3];
            if (iPathEntry.getEntryKind() == n2 && iPathEntry.getPath().equals((Object)iPath)) {
                arrayList.add(iLibraryEntry);
                bl = true;
            } else {
                arrayList.add(iPathEntry);
            }
            ++n3;
        }
        if (!bl) {
            if (iLibraryEntry.getSourceAttachmentPath() == null || !this.putJarOnClasspathDialog(shell)) {
                return;
            }
            arrayList.add(iLibraryEntry);
        }
        IPathEntry[] iPathEntryArray2 = arrayList.toArray(new IPathEntry[arrayList.size()]);
        iCProject.setRawPathEntries(iPathEntryArray2, iProgressMonitor);
    }

    private boolean putJarOnClasspathDialog(Shell shell) {
        final boolean[] blArray = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String string = CPathEntryMessages.getString("SourceAttachmentBlock.putoncpdialog.title");
                String string2 = CPathEntryMessages.getString("SourceAttachmentBlock.putoncpdialog.message");
                blArray[0] = MessageDialog.openQuestion((Shell)CUIPlugin.getActiveWorkbenchShell(), (String)string, (String)string2);
            }
        });
        return blArray[0];
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(dialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(dialogField);
        }
    }
}

