/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.SourceAttachmentBlock;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SourceAttachmentDialog
extends StatusDialog {
    private SourceAttachmentBlock fSourceAttachmentBlock;
    private boolean fApplyChanges;

    public SourceAttachmentDialog(Shell shell, ILibraryEntry iLibraryEntry, ICProject iCProject, boolean bl) {
        super(shell);
        this.fApplyChanges = bl;
        IStatusChangeListener iStatusChangeListener = new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
                SourceAttachmentDialog.this.updateStatus(iStatus);
            }
        };
        this.fSourceAttachmentBlock = new SourceAttachmentBlock(iStatusChangeListener, iLibraryEntry, iCProject);
        this.setTitle(CPathEntryMessages.getString("SourceAttachmentDialog.title"));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Control control = this.createSourceAttachmentControls(composite2);
        control.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected Control createSourceAttachmentControls(Composite composite) {
        return this.fSourceAttachmentBlock.createControl(composite);
    }

    public IPath getSourceAttachmentPath() {
        return this.fSourceAttachmentBlock.getSourceAttachmentPath();
    }

    public IPath getSourceAttachmentRootPath() {
        return this.fSourceAttachmentBlock.getSourceAttachmentRootPath();
    }

    protected void okPressed() {
        super.okPressed();
        if (this.fApplyChanges) {
            try {
                IRunnableWithProgress iRunnableWithProgress = this.getRunnable();
                new ProgressMonitorDialog(this.getShell()).run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = CPathEntryMessages.getString("SourceAttachmentDialog.error.title");
                String string2 = CPathEntryMessages.getString("SourceAttachmentDialog.error.message");
                ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected IRunnableWithProgress getRunnable() {
        return this.fSourceAttachmentBlock.getRunnable(this.getShell());
    }

    public static IPathEntry getPathEntryToEdit(ICProject iCProject, IPath iPath, IPath iPath2) throws CModelException {
        return null;
    }
}

