/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private CEditor fEditor;
    private ITranslationUnit fInput;
    private ProblemTreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TogglePresentationAction fTogglePresentation;
    private String fContextMenuId;
    private OpenIncludeAction fOpenIncludeAction;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;

    public CContentOutlinePage(CEditor cEditor) {
        this("#TranslationUnitOutlinerContext", cEditor);
    }

    public CContentOutlinePage(String string, CEditor cEditor) {
        this.fEditor = cEditor;
        this.fInput = null;
        this.fContextMenuId = string;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)cEditor);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public void contentUpdated() {
        TreeViewer treeViewer;
        if (this.fInput != null && (treeViewer = this.getTreeViewer()) != null && !treeViewer.getControl().isDisposed()) {
            treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getControl().isDisposed()) {
                        ISelection iSelection = treeViewer.getSelection();
                        treeViewer.setSelection(CContentOutlinePage.this.updateSelection(iSelection));
                        treeViewer.refresh();
                    }
                }
            });
        }
    }

    protected ISelection updateSelection(ISelection iSelection) {
        ArrayList arrayList = new ArrayList();
        if (iSelection instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ICElement)) continue;
                arrayList.add(e);
            }
        }
        return new StructuredSelection(arrayList);
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        CUIPlugin.createStandardGroups(iMenuManager);
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            iMenuManager.add((IAction)this.fOpenIncludeAction);
        }
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        if (SelectionSearchGroup.canActionBeAdded(this.getSelection())) {
            this.fSelectionSearchGroup.fillContextMenu(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator("additions"));
        }
        this.fRefactoringActionGroup.fillContextMenu(iMenuManager);
    }

    public void createControl(Composite composite) {
        this.treeViewer = new ProblemTreeViewer(composite, 770);
        this.treeViewer.setContentProvider((IContentProvider)new CContentOutlinerProvider(this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new StandardCElementLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener(this);
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.treeViewer);
        MenuManager menuManager = new MenuManager(this.fContextMenuId);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CContentOutlinePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Control control = this.treeViewer.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (CContentOutlinePage.this.fOpenIncludeAction != null) {
                    CContentOutlinePage.this.fOpenIncludeAction.run();
                }
            }
        });
        IPageSite iPageSite = this.getSite();
        iPageSite.registerContextMenu(this.fContextMenuId, menuManager, (ISelectionProvider)this.treeViewer);
        iPageSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        IActionBars iActionBars = iPageSite.getActionBars();
        iActionBars.setGlobalActionHandler("org.eclipse.cdt.ui.edit.text.c.toggle.presentation", (IAction)this.fTogglePresentation);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fRefactoringActionGroup = new RefactoringActionGroup(this, null);
        this.treeViewer.setInput(this.fInput);
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.cdt.ui.outline_view");
    }

    public void dispose() {
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.treeViewer);
        if (this.treeViewer != null) {
            this.treeViewer.removeSelectionChangedListener(this);
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(null);
            this.fTogglePresentation = null;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
        }
        this.fInput = null;
        super.dispose();
    }

    public void setActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        LexicalSortingAction lexicalSortingAction = new LexicalSortingAction(this.getTreeViewer());
        iToolBarManager.add((IAction)lexicalSortingAction);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.treeViewer, "COutlineViewer");
        this.fMemberFilterActionGroup.fillActionBars(iActionBars);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    protected void fireSelectionChanged(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((ISelectionChangedListener)objectArray[n]).selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelectionChanged(selectionChangedEvent.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection iSelection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(iSelection);
        }
    }

    public void setInput(ITranslationUnit iTranslationUnit) {
        this.fInput = iTranslationUnit;
        if (this.treeViewer != null) {
            this.treeViewer.setInput(this.fInput);
        }
        this.contentUpdated();
    }
}

