/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;

public class CContentOutlinerProvider
extends BaseCElementContentProvider {
    CContentOutlinePage fOutliner;
    ITranslationUnit root;
    private ElementChangedListener fListener;
    private IPropertyChangeListener fPropertyListener;

    public CContentOutlinerProvider(CContentOutlinePage cContentOutlinePage) {
        super(true, true);
        this.fOutliner = cContentOutlinePage;
    }

    public void dispose() {
        super.dispose();
        if (this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
        if (this.fPropertyListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        boolean bl = object2 instanceof ITranslationUnit;
        if (bl && this.fListener == null) {
            this.root = (ITranslationUnit)object2;
            this.fListener = new ElementChangedListener();
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fListener);
            this.fPropertyListener = new PropertyListener();
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        } else if (!bl && this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
            this.root = null;
        }
    }

    class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            ICElementDelta iCElementDelta = this.findElement((ICElement)CContentOutlinerProvider.this.root, elementChangedEvent.getDelta());
            if (iCElementDelta != null && CContentOutlinerProvider.this.fOutliner != null) {
                CContentOutlinerProvider.this.fOutliner.contentUpdated();
                return;
            }
        }

        private boolean isPossibleStructuralChange(ICElementDelta iCElementDelta) {
            if (iCElementDelta.getKind() != 4) {
                return true;
            }
            int n = iCElementDelta.getFlags();
            if ((n & 8) != 0) {
                return true;
            }
            return (n & 0x400001) == 1;
        }

        protected ICElementDelta findElement(ICElement iCElement, ICElementDelta iCElementDelta) {
            if (iCElementDelta == null || iCElement == null) {
                return null;
            }
            ICElement iCElement2 = iCElementDelta.getElement();
            if (iCElement.equals(iCElement2)) {
                if (this.isPossibleStructuralChange(iCElementDelta)) {
                    return iCElementDelta;
                }
                return null;
            }
            if (iCElement2.getElementType() > 60) {
                return null;
            }
            ICElementDelta[] iCElementDeltaArray = iCElementDelta.getAffectedChildren();
            if (iCElementDeltaArray == null || iCElementDeltaArray.length == 0) {
                return null;
            }
            int n = 0;
            while (n < iCElementDeltaArray.length) {
                ICElementDelta iCElementDelta2 = this.findElement(iCElement, iCElementDeltaArray[n]);
                if (iCElementDelta2 != null) {
                    return iCElementDelta2;
                }
                ++n;
            }
            return null;
        }
    }

    class PropertyListener
    implements IPropertyChangeListener {
        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            propertyChangeEvent.getProperty();
        }
    }
}

