/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.CStorageDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.editor.TranslationUnitAnnotationModelEvent;
import org.eclipse.cdt.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CDocumentProvider
extends TextFileDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;

    public CDocumentProvider() {
        this.setParentDocumentProvider((IDocumentProvider)new TextFileDocumentProvider((IDocumentProvider)new CStorageDocumentProvider()));
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (CDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(propertyChangeEvent.getProperty())) {
                    CDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected ITranslationUnit createTranslationUnit(IFile iFile) {
        ICElement iCElement = CoreModel.getDefault().create(iFile);
        if (iCElement instanceof ITranslationUnit) {
            return (ITranslationUnit)iCElement;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new TranslationUnitInfo();
    }

    protected IAnnotationModel createAnnotationModel(IFile iFile) {
        return new TranslationUnitAnnotationModel((IResource)iFile);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object object) throws CoreException {
        Object object2;
        Object object3;
        ITranslationUnit iTranslationUnit = null;
        if (object instanceof IFileEditorInput) {
            object3 = (IFileEditorInput)object;
            iTranslationUnit = this.createTranslationUnit(object3.getFile());
        } else if (object instanceof ITranslationUnitEditorInput) {
            object3 = (ITranslationUnitEditorInput)object;
            iTranslationUnit = object3.getTranslationUnit();
        }
        if (iTranslationUnit == null) {
            return null;
        }
        object3 = super.createFileInfo(object);
        if (!(object3 instanceof TranslationUnitInfo)) {
            return null;
        }
        TranslationUnitInfo translationUnitInfo = (TranslationUnitInfo)((Object)object3);
        this.setUpSynchronization(translationUnitInfo);
        IProblemRequestor iProblemRequestor = translationUnitInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)translationUnitInfo.fModel : null;
        CFileElementWorkingCopy cFileElementWorkingCopy = null;
        if (object instanceof IFileEditorInput) {
            object2 = CUIPlugin.getDefault().getBufferFactory();
            cFileElementWorkingCopy = iTranslationUnit.getSharedWorkingCopy(this.getProgressMonitor(), (IBufferFactory)object2, iProblemRequestor);
        } else if (object instanceof ITranslationUnitEditorInput) {
            cFileElementWorkingCopy = new CFileElementWorkingCopy(iTranslationUnit);
        }
        translationUnitInfo.fCopy = cFileElementWorkingCopy;
        if (translationUnitInfo.fModel instanceof TranslationUnitAnnotationModel) {
            object2 = (TranslationUnitAnnotationModel)translationUnitInfo.fModel;
            ((TranslationUnitAnnotationModel)object2).setTranslationUnit((ITranslationUnit)translationUnitInfo.fCopy);
        }
        if (translationUnitInfo.fModel != null) {
            translationUnitInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        if (iProblemRequestor instanceof IProblemRequestorExtension) {
            object2 = (IProblemRequestorExtension)iProblemRequestor;
            object2.setIsActive(this.isHandlingTemporaryProblems());
        }
        return translationUnitInfo;
    }

    private void setUpSynchronization(TranslationUnitInfo translationUnitInfo) {
        IDocument iDocument = translationUnitInfo.fTextFileBuffer.getDocument();
        IAnnotationModel iAnnotationModel = translationUnitInfo.fModel;
        if (iDocument instanceof ISynchronizable && iAnnotationModel instanceof ISynchronizable) {
            Object object = ((ISynchronizable)iDocument).getLockObject();
            ((ISynchronizable)iAnnotationModel).setLockObject(object);
        }
    }

    protected void disposeFileInfo(Object object, TextFileDocumentProvider.FileInfo fileInfo) {
        if (fileInfo instanceof TranslationUnitInfo) {
            TranslationUnitInfo translationUnitInfo = (TranslationUnitInfo)fileInfo;
            translationUnitInfo.fCopy.destroy();
            if (translationUnitInfo.fModel != null) {
                translationUnitInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(object, fileInfo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(IProgressMonitor iProgressMonitor, Object object, TranslationUnitInfo translationUnitInfo, boolean bl) throws CoreException {
        IWorkingCopy iWorkingCopy = translationUnitInfo.fCopy;
        synchronized (iWorkingCopy) {
            translationUnitInfo.fCopy.reconcile();
        }
        iWorkingCopy = translationUnitInfo.fTextFileBuffer.getDocument();
        IResource iResource = translationUnitInfo.fCopy.getResource();
        if (iResource instanceof IFile && !iResource.exists()) {
            this.createFileFromDocument(iProgressMonitor, (IFile)iResource, (IDocument)iWorkingCopy);
            return;
        }
        try {
            try {
                this.fIsAboutToSave = true;
                this.commitFileBuffer(iProgressMonitor, translationUnitInfo, bl);
            }
            catch (CoreException coreException) {
                this.fireElementStateChangeFailed(object);
                throw coreException;
            }
            catch (RuntimeException runtimeException) {
                this.fireElementStateChangeFailed(object);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.fIsAboutToSave = false;
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.fIsAboutToSave = false;
            return;
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object object, IDocument iDocument, final boolean bl) throws CoreException {
        final TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(object);
        if (fileInfo instanceof TranslationUnitInfo) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    CDocumentProvider.this.commitWorkingCopy(iProgressMonitor, object, (TranslationUnitInfo)fileInfo, bl);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFile iFile = ((IFileEditorInput)fileInfo.fElement).getFile();
                        IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                        if (iFile == null || !iFile.exists()) {
                            return iResourceRuleFactory.createRule((IResource)iFile);
                        }
                        return iResourceRuleFactory.modifyRule((IResource)iFile);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean bl = this.isHandlingTemporaryProblems();
        Iterator iterator = this.getFileInfosIterator();
        while (iterator.hasNext()) {
            TextFileDocumentProvider.FileInfo fileInfo = (TextFileDocumentProvider.FileInfo)iterator.next();
            if (!(fileInfo.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension iProblemRequestorExtension = (IProblemRequestorExtension)fileInfo.fModel;
            iProblemRequestorExtension.setIsActive(bl);
        }
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.fGlobalAnnotationModelListener.addListener(iAnnotationModelListener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.fGlobalAnnotationModelListener.removeListener(iAnnotationModelListener);
    }

    public IWorkingCopy getWorkingCopy(Object object) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(object);
        if (fileInfo instanceof TranslationUnitInfo) {
            TranslationUnitInfo translationUnitInfo = (TranslationUnitInfo)fileInfo;
            return translationUnitInfo.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator iterator = this.getConnectedElementsIterator();
        while (iterator.hasNext()) {
            this.disconnect(iterator.next());
        }
    }

    public IResource getUnderlyingResource(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return iFileEditorInput.getFile();
        }
        return null;
    }

    public void saveDocumentContent(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(iProgressMonitor, object, iDocument, bl);
    }

    public ILineTracker createLineTracker(Object object) {
        return new DefaultLineTracker();
    }

    protected static class TranslationUnitInfo
    extends TextFileDocumentProvider.FileInfo {
        public IWorkingCopy fCopy;

        protected TranslationUnitInfo() {
        }
    }

    protected static class ProblemAnnotation
    extends Annotation
    implements ICAnnotation,
    IAnnotationPresentation {
        private static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private ITranslationUnit fTranslationUnit;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;

        static {
            AnnotationPreferenceLookup annotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", annotationPreferenceLookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.info", annotationPreferenceLookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.warning", annotationPreferenceLookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.error", annotationPreferenceLookup);
            fgQuickFixImagesInitialized = false;
        }

        private static int computeLayer(String string, AnnotationPreferenceLookup annotationPreferenceLookup) {
            Annotation annotation = new Annotation(string, false, null);
            AnnotationPreference annotationPreference = annotationPreferenceLookup.getAnnotationPreference(annotation);
            if (annotationPreference != null) {
                return annotationPreference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem iProblem, ITranslationUnit iTranslationUnit) {
            this.fProblem = iProblem;
            this.fTranslationUnit = iTranslationUnit;
            if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.cdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.cdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.cdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems()) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = CPluginImages.get("org.eclipse.cdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixErrorImage = CPluginImages.get("org.eclipse.cdt.ui.quickfix_error_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.eclipse.cdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("CEditor.ShowTemporaryProblem");
        }

        public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            String[] stringArray;
            if (this.isProblem()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.fProblem.getArguments();
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String string = this.getType();
            return "org.eclipse.cdt.ui.warning".equals(string) || "org.eclipse.cdt.ui.error".equals(string) || SPELLING_ANNOTATION_TYPE.equals(string);
        }

        public boolean hasOverlay() {
            return false;
        }

        public ICAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(ICAnnotation iCAnnotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(iCAnnotation);
        }

        public void removeOverlaid(ICAnnotation iCAnnotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(iCAnnotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ITranslationUnit getTranslationUnit() {
            return this.fTranslationUnit;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int n = this.fList.size();
            int n2 = this.fAnchor;
            while (n2 < n) {
                entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = n2;
                    return entry.fValue;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.fAnchor) {
                entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = n2;
                    return entry.fValue;
                }
                ++n2;
            }
            return null;
        }

        private int getIndex(Position position) {
            int n = this.fList.size();
            int n2 = 0;
            while (n2 < n) {
                Entry entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public void put(Position position, Object object) {
            int n = this.getIndex(position);
            if (n == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = object;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(n);
                entry.fValue = object;
            }
        }

        public void remove(Position position) {
            int n = this.getIndex(position);
            if (n > -1) {
                this.fList.remove(n);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class TranslationUnitAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private ITranslationUnit fTranslationUnit;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public TranslationUnitAnnotationModel(IResource iResource) {
            super(iResource);
        }

        public void setTranslationUnit(ITranslationUnit iTranslationUnit) {
            this.fTranslationUnit = iTranslationUnit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker iMarker) {
            String string = MarkerUtilities.getMarkerType((IMarker)iMarker);
            if (string != null && string.startsWith("org.eclipse.cdt")) {
                return new CMarkerAnnotation(iMarker, null);
            }
            return super.createMarkerAnnotation(iMarker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new TranslationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem iProblem) {
            int n = iProblem.getSourceStart();
            if (n < 0) {
                return null;
            }
            int n2 = iProblem.getSourceEnd() - iProblem.getSourceStart() + 1;
            if (n2 < 0) {
                return null;
            }
            return new Position(n, n2);
        }

        public void beginReporting() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState == null) {
                this.internalBeginReporting(true);
            }
        }

        private void internalBeginReporting(boolean bl) {
            if (this.fTranslationUnit != null && this.fTranslationUnit.getCProject().isOnSourceRoot(this.fTranslationUnit.getResource())) {
                ProblemRequestorState problemRequestorState = new ProblemRequestorState();
                problemRequestorState.fInsideReportingSequence = bl;
                problemRequestorState.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(problemRequestorState);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem iProblem) {
            ProblemRequestorState problemRequestorState;
            if (this.isActive() && (problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                problemRequestorState.fReportedProblems.add(iProblem);
            }
        }

        public void endReporting() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState != null && !problemRequestorState.fInsideReportingSequence) {
                this.internalEndReporting(problemRequestorState);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState != null && problemRequestorState.fInsideReportingSequence) {
                this.internalEndReporting(problemRequestorState);
            }
        }

        private void internalEndReporting(ProblemRequestorState problemRequestorState) {
            int n = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                n = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (n == 0 && this.isActive()) {
                this.reportProblems(problemRequestorState.fReportedProblems);
            }
        }

        private void reportProblems(List list) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean bl = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean bl2 = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    bl = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (list != null && list.size() > 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            bl2 = true;
                            break;
                        }
                        IProblem iProblem = (IProblem)iterator.next();
                        Position position = this.createPositionFromProblem(iProblem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation problemAnnotation = new ProblemAnnotation(iProblem, this.fTranslationUnit);
                            this.overlayMarkers(position, problemAnnotation);
                            this.addAnnotation(problemAnnotation, position, false);
                            this.fGeneratedAnnotations.add(problemAnnotation);
                            bl = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(bl2);
                this.fPreviouslyOverlaid = null;
            }
            if (bl) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean bl) {
            if (bl) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator iterator = this.fPreviouslyOverlaid.iterator();
                while (iterator.hasNext()) {
                    CMarkerAnnotation cMarkerAnnotation = (CMarkerAnnotation)iterator.next();
                    cMarkerAnnotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object object, ProblemAnnotation problemAnnotation) {
            CMarkerAnnotation cMarkerAnnotation;
            if (object instanceof CMarkerAnnotation && (cMarkerAnnotation = (CMarkerAnnotation)object).isProblem()) {
                cMarkerAnnotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(cMarkerAnnotation);
                this.fCurrentlyOverlaid.add(cMarkerAnnotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object object = this.getAnnotations(position);
            if (object instanceof List) {
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.setOverlay(iterator.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(object, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations = null;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
            this.fProgressMonitor = iProgressMonitor;
        }

        public void setIsActive(boolean bl) {
            if (this.fIsActive != bl) {
                this.fIsActive = bl;
                if (this.fIsActive) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean bl) throws BadLocationException {
            super.addAnnotation(annotation, position, bl);
            Object object = this.fReverseMap.get(position);
            if (object == null) {
                this.fReverseMap.put(position, annotation);
            } else if (object instanceof List) {
                List list = (List)object;
                list.add(annotation);
            } else if (object instanceof Annotation) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(object);
                arrayList.add(annotation);
                this.fReverseMap.put(position, arrayList);
            }
        }

        protected void removeAllAnnotations(boolean bl) {
            super.removeAllAnnotations(bl);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean bl) {
            Position position = this.getPosition(annotation);
            Object object = this.fReverseMap.get(position);
            if (object instanceof List) {
                List list = (List)object;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (object instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, bl);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            ProblemRequestorState() {
            }
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ArrayList fListenerList = new ArrayList();

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            Object[] objectArray = this.fListenerList.toArray();
            int n = 0;
            while (n < objectArray.length) {
                ((IAnnotationModelListener)objectArray[n]).modelChanged(iAnnotationModel);
                ++n;
            }
        }

        public void modelChanged(AnnotationModelEvent annotationModelEvent) {
            Object[] objectArray = this.fListenerList.toArray();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)object).modelChanged(annotationModelEvent);
                }
                ++n;
            }
        }

        public void addListener(IAnnotationModelListener iAnnotationModelListener) {
            this.fListenerList.add(iAnnotationModelListener);
        }

        public void removeListener(IAnnotationModelListener iAnnotationModelListener) {
            this.fListenerList.remove(iAnnotationModelListener);
        }
    }
}

