/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.AddIncludeOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.internal.ui.editor.MouseClickListener;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.cdt.ui.actions.ShowInCViewAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public class CEditor
extends TextEditor
implements ISelectionChangedListener,
IShowInSource,
IReconcilingParticipant {
    protected CContentOutlinePage fOutlinePage;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;
    private ShowInCViewAction fShowInCViewAction;
    protected ISelectionChangedListener fStatusLineClearer;
    protected ISelectionChangedListener fSelectionUpdateListener;
    private PropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private MouseClickListener fMouseListener;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected CPairMatcher fBracketMatcher = new CPairMatcher(BRACKETS);
    private TabConverter fTabConverter;
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    public static final String LINKED_POSITION_COLOR = "linkedPositionColor";
    private static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    public static final String HYPERLINK_ENABLED = "hyperlinkEnable";
    public static final String LANGUAGE_CPP = "CEditor.language.cpp";
    public static final String LANGUAGE_C = "CEditor.language.c";
    protected String fOutlinerContextMenuId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void initializeEditor() {
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        this.setSourceViewerConfiguration(new CSourceViewerConfiguration(cTextTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setOutlinerContextMenuId("#CEditorOutlinerContext");
        IPreferenceStore[] iPreferenceStoreArray = new IPreferenceStore[]{CUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore chainedPreferenceStore = new ChainedPreferenceStore(iPreferenceStoreArray);
        this.setPreferenceStore((IPreferenceStore)chainedPreferenceStore);
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(this.getDocumentProvider().getAnnotationModel((Object)iEditorInput));
        }
        this.setOutlinePageInput(this.fOutlinePage, iEditorInput);
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public IFile getInputFile() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        this.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        block15: {
            block18: {
                block17: {
                    AdaptedSourceViewer adaptedSourceViewer = (AdaptedSourceViewer)this.getSourceViewer();
                    try {
                        SourceViewerConfiguration sourceViewerConfiguration;
                        String string;
                        block16: {
                            if (adaptedSourceViewer == null) break block15;
                            string = propertyChangeEvent.getProperty();
                            if ("org.eclipse.cdt.editor.tab.width".equals(string)) {
                                Object object;
                                sourceViewerConfiguration = this.getSourceViewerConfiguration();
                                String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes((ISourceViewer)adaptedSourceViewer);
                                int n = 0;
                                while (true) {
                                    if (n >= stringArray.length) {
                                        if (this.fTabConverter != null) {
                                            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
                                        }
                                        if (!((object = propertyChangeEvent.getNewValue()) instanceof Integer)) break;
                                        adaptedSourceViewer.getTextWidget().setTabs(((Integer)object).intValue());
                                        break block16;
                                    }
                                    adaptedSourceViewer.setIndentPrefixes(sourceViewerConfiguration.getIndentPrefixes((ISourceViewer)adaptedSourceViewer, stringArray[n]), stringArray[n]);
                                    ++n;
                                }
                                if (object instanceof String) {
                                    adaptedSourceViewer.getTextWidget().setTabs(Integer.parseInt((String)object));
                                }
                            }
                        }
                        if (SPACES_FOR_TABS.equals(string)) {
                            if (this.isTabConversionEnabled()) {
                                this.startTabConversion();
                            } else {
                                this.stopTabConversion();
                            }
                            Object var7_8 = null;
                            break block17;
                        }
                        if (HYPERLINK_ENABLED.equals(string)) {
                            if (this.hyperLinkEnabled()) {
                                this.enableBrowserLikeLinks();
                                break block18;
                            } else {
                                this.disableBrowserLikeLinks();
                            }
                            break block18;
                        }
                        sourceViewerConfiguration = adaptedSourceViewer.getContentAssistant();
                        if (sourceViewerConfiguration instanceof ContentAssistant) {
                            ContentAssistPreference.changeConfiguration((ContentAssistant)sourceViewerConfiguration, this.getPreferenceStore(), propertyChangeEvent);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        super.handlePreferenceStoreChanged(propertyChangeEvent);
                        throw throwable;
                    }
                }
                super.handlePreferenceStoreChanged(propertyChangeEvent);
                return;
            }
            Object var7_9 = null;
            super.handlePreferenceStoreChanged(propertyChangeEvent);
            return;
        }
        Object var7_11 = null;
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection;
        Object object;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange iSourceRange = ((ISourceReference)object).getSourceRange();
                if (iSourceRange != null) {
                    this.setSelection(iSourceRange, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ICElement iCElement) {
        if (iCElement == null || iCElement instanceof ITranslationUnit) {
            return;
        }
        if (iCElement instanceof ISourceReference) {
            ISourceReference iSourceReference = (ISourceReference)iCElement;
            this.setSelection(iSourceReference, true);
        }
    }

    public void setSelection(ISourceReference iSourceReference, boolean bl) {
        if (iSourceReference != null) {
            try {
                this.setSelection(iSourceReference.getSourceRange(), bl);
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ISourceRange iSourceRange, boolean bl) {
        if (iSourceRange == null) {
            return;
        }
        try {
            IRegion iRegion = null;
            int n = iSourceRange.getStartPos();
            int n2 = iSourceRange.getLength();
            if (n < 0 || n2 < 0) {
                n = 0;
                n2 = 0;
            }
            if (n2 == 0 && n == 0 && iSourceRange.getStartLine() > 0) {
                n = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(iSourceRange.getStartLine() - 1);
                n2 = iSourceRange.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(iSourceRange.getEndLine()) - n : n;
                iRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(iSourceRange.getStartLine() - 1);
                if ((n == n2 || n2 < 0) && iRegion != null) {
                    n = iRegion.getOffset();
                    n2 = iRegion.getLength();
                }
            }
            this.setHighlightRange(n, n2, bl);
            if (bl) {
                n = iSourceRange.getIdStartPos();
                n2 = iSourceRange.getIdLength();
                if (n == 0 && n2 == 0 && iRegion != null) {
                    n = iRegion.getOffset();
                    n2 = iRegion.getLength();
                }
                if (n > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(n, n2);
                    this.getSourceViewer().setSelectedRange(n, n2);
                }
                this.updateStatusField("CursorPosition");
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        if (bl) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        IPartService iPartService = iWorkbenchWindow.getPartService();
        return this == iPartService.getActivePart();
    }

    public void dispose() {
        Preferences preferences;
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(null);
            this.fCEditorErrorTickUpdater.dispose();
            this.fCEditorErrorTickUpdater = null;
        }
        if (this.fPropertyChangeListener != null) {
            preferences = CCorePlugin.getDefault().getPluginPreferences();
            preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPropertyChangeListener);
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            iPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fSelectionUpdateListener != null) {
            this.getSelectionProvider().addSelectionChangedListener(this.fSelectionUpdateListener);
            this.fSelectionUpdateListener = null;
        }
        if (this.fStatusLineClearer != null) {
            preferences = this.getSelectionProvider();
            preferences.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.fShowInCViewAction != null) {
            this.fShowInCViewAction.dispose();
            this.fShowInCViewAction = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        this.stopTabConversion();
        this.disableBrowserLikeLinks();
        super.dispose();
    }

    protected boolean canHandleMove(IEditorInput iEditorInput, IEditorInput iEditorInput2) {
        ICFileType iCFileType;
        IFile iFile;
        String string;
        String string2 = "";
        if (iEditorInput instanceof IFileEditorInput && (string = ((IFileEditorInput)iEditorInput).getFile()) != null && (string2 = (iFile = CCorePlugin.getDefault().getFileType(string.getProject(), string.getName())).getLanguage().getId()) == null) {
            return false;
        }
        string = "";
        if (iEditorInput2 instanceof IFileEditorInput && (iFile = ((IFileEditorInput)iEditorInput2).getFile()) != null && (string = (iCFileType = CCorePlugin.getDefault().getFileType(iFile.getProject(), iFile.getName())).getLanguage().getId()) == null) {
            return false;
        }
        return string2.equals(string);
    }

    protected void createActions() {
        super.createActions();
        Object object = new TextOperationAction(CEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        object.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.comment");
        this.setAction("Comment", (IAction)object);
        this.markAsStateDependentAction("Comment", true);
        object = new TextOperationAction(CEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        object.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.uncomment");
        this.setAction("Uncomment", (IAction)object);
        this.markAsStateDependentAction("Uncomment", true);
        object = new TextOperationAction(CEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        object.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.setAction("Format", (IAction)object);
        this.markAsStateDependentAction("Format", true);
        object = new ContentAssistAction(CEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)object);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        object = new TextOperationAction(CEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)object);
        this.setAction("AddIncludeOnSelection", (IAction)new AddIncludeOnSelectionAction((ITextEditor)this));
        object = new OpenDeclarationsAction(this);
        object.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        this.setAction("OpenDeclarations", (IAction)object);
        this.fShowInCViewAction = new ShowInCViewAction((ITextEditor)this);
        object = this.fShowInCViewAction;
        object.setActionDefinitionId("org.eclipse.cdt.ui.edit.opencview");
        this.setAction("ShowInCView", (IAction)object);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fRefactoringActionGroup = new RefactoringActionGroup(this, null);
        if (this.hyperLinkEnabled()) {
            this.enableBrowserLikeLinks();
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        this.addGroup(iMenuManager, "group.edit", "group.reorganize");
        this.addGroup(iMenuManager, "group.edit", "group.generate");
        this.addGroup(iMenuManager, "group.edit", "group.new");
        this.addAction(iMenuManager, "group.edit", "Comment");
        this.addAction(iMenuManager, "group.edit", "Uncomment");
        this.addAction(iMenuManager, "group.find", "OpenDeclarations");
        this.addAction(iMenuManager, "group.generate", "ContentAssistProposal");
        this.addAction(iMenuManager, "group.generate", "AddIncludeOnSelection");
        this.addAction(iMenuManager, "group.generate", "ShowInCView");
        this.fRefactoringActionGroup.fillContextMenu(iMenuManager);
        this.fSelectionSearchGroup.fillContextMenu(iMenuManager);
    }

    public void setOutlinePageInput(CContentOutlinePage cContentOutlinePage, IEditorInput iEditorInput) {
        if (cContentOutlinePage != null) {
            IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
            cContentOutlinePage.setInput((ITranslationUnit)iWorkingCopyManager.getWorkingCopy(iEditorInput));
        }
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.editor_view");
        this.fSelectionUpdateListener = new ISelectionChangedListener(){
            private Runnable fRunnable = new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    CEditor.access$0(1.access$0(this.this$1), "CursorPosition");
                }
            };
            private Display fDisplay;

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (this.fDisplay == null) {
                    this.fDisplay = CEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(this.fRunnable);
            }

            static /* synthetic */ CEditor access$0(1 var0) {
                return var0.CEditor.this;
            }
        };
        this.getSelectionProvider().addSelectionChangedListener(this.fSelectionUpdateListener);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPropertyChangeListener);
    }

    private IMarker getNextError(int n, boolean bl) {
        IMarker iMarker = null;
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int n2 = iDocument.getLength();
        int n3 = 0;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            MarkerAnnotation markerAnnotation;
            IMarker iMarker2;
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof CMarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(iMarker2 = (markerAnnotation = (MarkerAnnotation)annotation).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (position = iAnnotationModel.getPosition(annotation)).includes(n)) continue;
            int n4 = 0;
            if (bl) {
                n4 = position.getOffset() - n;
                if (n4 < 0) {
                    n4 = n2 - n + position.getOffset();
                }
            } else {
                n4 = n - position.getOffset();
                if (n4 < 0) {
                    n4 = n + n2 - position.getOffset();
                }
            }
            if (iMarker != null && (n4 >= n3 || n4 == 0)) continue;
            n3 = n4;
            if (n3 == 0) {
                n3 = n2;
            }
            iMarker = iMarker2;
        }
        return iMarker;
    }

    public void gotoError(boolean bl) {
        ITextSelection iTextSelection;
        IMarker iMarker;
        ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        if (this.fStatusLineClearer != null) {
            iSelectionProvider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if ((iMarker = this.getNextError((iTextSelection = (ITextSelection)iSelectionProvider.getSelection()).getOffset(), bl)) != null) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)iMarker);
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.ui.views.TaskList");
            if (iViewPart instanceof TaskList) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iMarker);
                ((TaskList)iViewPart).setSelection((ISelection)structuredSelection, true);
            }
            this.getStatusLineManager().setErrorMessage(iMarker.getAttribute("message", ""));
            this.fStatusLineClearer = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    CEditor.this.getSelectionProvider().removeSelectionChangedListener(CEditor.this.fStatusLineClearer);
                    CEditor.this.fStatusLineClearer = null;
                    CEditor.this.getStatusLineManager().setErrorMessage("");
                }
            };
            iSelectionProvider.addSelectionChangedListener(this.fStatusLineClearer);
        } else {
            this.getStatusLineManager().setErrorMessage("");
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), null);
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
            AdaptedSourceViewer adaptedSourceViewer = (AdaptedSourceViewer)this.getSourceViewer();
            adaptedSourceViewer.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer adaptedSourceViewer = (AdaptedSourceViewer)this.getSourceViewer();
            adaptedSourceViewer.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore.getBoolean(SPACES_FOR_TABS);
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        IProject iProject;
        IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy iWorkingCopy = iWorkingCopyManager.getWorkingCopy(this.getEditorInput());
        String string = LANGUAGE_CPP;
        if (iWorkingCopy != null && !CoreModel.hasCCNature((IProject)(iProject = iWorkingCopy.getCProject().getProject()))) {
            string = iWorkingCopy.isCXXLanguage() ? LANGUAGE_CPP : LANGUAGE_C;
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        iProject = CUIPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = this.createOverviewRuler((ISharedTextColors)iProject);
        AdaptedSourceViewer adaptedSourceViewer = new AdaptedSourceViewer(composite, iVerticalRuler, n, this.fOverviewRuler, this.isOverviewRulerVisible(), string);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)adaptedSourceViewer, this.fOverviewRuler, this.fAnnotationAccess, (ISharedTextColors)iProject);
        this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        this.fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        this.fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        return adaptedSourceViewer;
    }

    protected void setOutlinerContextMenuId(String string) {
        this.fOutlinerContextMenuId = string;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.ui.cEditorScope"});
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        AsmTextTools asmTextTools = CUIPlugin.getDefault().getAsmTextTools();
        return cTextTools.affectsBehavior(propertyChangeEvent) || asmTextTools.affectsBehavior(propertyChangeEvent);
    }

    protected void handlePreferencePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        ISourceViewer iSourceViewer;
        if (TRANSLATION_TASK_TAGS.equals(propertyChangeEvent.getProperty()) && (iSourceViewer = this.getSourceViewer()) != null && this.affectsTextPresentation(propertyChangeEvent)) {
            iSourceViewer.invalidateTextPresentation();
        }
    }

    protected void setStatusLineErrorMessage(String string) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
    }

    private void enableBrowserLikeLinks() {
        if (this.fMouseListener == null) {
            IAction iAction = this.getAction("OpenDeclarations");
            this.fMouseListener = new MouseClickListener(this, this.getSourceViewer(), this.getPreferenceStore(), iAction);
            this.fMouseListener.install();
        }
    }

    private void disableBrowserLikeLinks() {
        if (this.fMouseListener != null) {
            this.fMouseListener.uninstall();
            this.fMouseListener = null;
        }
    }

    private boolean hyperLinkEnabled() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore.getBoolean(HYPERLINK_ENABLED);
    }

    public void reconciled(boolean bl) {
    }

    static /* synthetic */ void access$0(CEditor cEditor, String string) {
        cEditor.updateStatusField(string);
    }

    private class PropertyChangeListener
    implements Preferences.IPropertyChangeListener,
    IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CEditor.this.handlePreferencePropertyChanged(propertyChangeEvent);
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            CEditor.this.handlePreferencePropertyChanged(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }

    interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    static class TabConverter
    implements ITextConverter {
        private String fTabString = "";
        private int tabRatio = 0;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int n) {
            this.tabRatio = n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            this.fTabString = stringBuffer.toString();
        }

        public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
            String string = documentCommand.text;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
            int n = 0;
            try {
                n = documentCommand.offset - iDocument.getLineInformationOfOffset(documentCommand.offset).getOffset();
            }
            catch (Exception exception) {}
            String string2 = null;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if ("\t".equals(string2)) {
                    n2 = this.tabRatio - n % this.tabRatio;
                    int n3 = 0;
                    while (n3 < n2) {
                        stringBuffer.append(' ');
                        ++n3;
                    }
                    n += n2;
                    continue;
                }
                stringBuffer.append(string2);
                n += string2.length();
            }
            documentCommand.text = stringBuffer.toString();
        }
    }

    public class AdaptedSourceViewer
    extends SourceViewer
    implements ITextViewerExtension {
        private List fTextConverters;
        private String fDisplayLanguage;

        public AdaptedSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n, IOverviewRuler iOverviewRuler, boolean bl, String string) {
            super(composite, iVerticalRuler, iOverviewRuler, bl, n);
            this.fDisplayLanguage = string;
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public void doOperation(int n) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (n) {
                case 13: {
                    String string = this.fContentAssistant.showPossibleCompletions();
                    CEditor.this.setStatusLineErrorMessage(string);
                    return;
                }
            }
            super.doOperation(n);
        }

        public void insertTextConverter(ITextConverter iTextConverter, int n) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter iTextConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(iTextConverter);
            } else if (!this.fTextConverters.contains(iTextConverter)) {
                this.fTextConverters.add(iTextConverter);
            }
        }

        public void removeTextConverter(ITextConverter iTextConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(iTextConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand documentCommand) {
            super.customizeDocumentCommand(documentCommand);
            if (this.fTextConverters != null) {
                Iterator iterator = this.fTextConverters.iterator();
                while (iterator.hasNext()) {
                    ((ITextConverter)iterator.next()).customizeDocumentCommand(this.getDocument(), documentCommand);
                }
            }
        }

        public void setDisplayLanguage(String string) {
            this.fDisplayLanguage = string;
        }

        public String getDisplayLanguage() {
            return this.fDisplayLanguage;
        }
    }
}

