/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LexicalSortingAction
extends Action {
    private static final String ACTION_NAME = "LexicalSortingAction";
    private static final String DIALOG_STORE_KEY = "LexicalSortingAction.sort";
    private LexicalCSorter fSorter;
    private TreeViewer fTreeViewer;

    public LexicalSortingAction(TreeViewer treeViewer) {
        super(CUIPlugin.getResourceString("LexicalSortingAction.label"));
        this.setDescription(CUIPlugin.getResourceString("LexicalSortingAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("LexicalSortingAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.alphab_sort_co.gif");
        this.fTreeViewer = treeViewer;
        this.fSorter = new LexicalCSorter();
        boolean bl = CUIPlugin.getDefault().getDialogSettings().getBoolean(DIALOG_STORE_KEY);
        this.valueChanged(bl, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean bl, boolean bl2) {
        this.setChecked(bl);
        this.fTreeViewer.setSorter((ViewerSorter)(bl ? this.fSorter : null));
        String string = "LexicalSortingAction.tooltip" + (bl ? ".on" : ".off");
        this.setToolTipText(CUIPlugin.getResourceString(string));
        if (bl2) {
            CUIPlugin.getDefault().getDialogSettings().put(DIALOG_STORE_KEY, bl);
        }
    }

    private class LexicalCSorter
    extends ViewerSorter {
        LexicalCSorter() {
        }

        public boolean isSorterProperty(Object object, Object object2) {
            return true;
        }

        public int category(Object object) {
            if (object instanceof ICElement) {
                ICElement iCElement = (ICElement)object;
                switch (iCElement.getElementType()) {
                    case 77: {
                        return 1;
                    }
                    case 72: {
                        return 2;
                    }
                    case 64: {
                        return 3;
                    }
                    case 65: {
                        return 4;
                    }
                    case 66: {
                        return 5;
                    }
                    case 69: {
                        return 6;
                    }
                    case 71: {
                        return 7;
                    }
                }
            }
            return 0;
        }
    }
}

