/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class MouseClickListener
implements MouseListener,
KeyListener,
MouseMoveListener,
FocusListener,
PaintListener,
IPropertyChangeListener {
    private final CEditor fEditor;
    private ISourceViewer fViewer;
    private IPreferenceStore fPrefStore;
    private IAction fOpenDeclAction;
    private boolean fActive;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private Cursor fCursor;
    private Color fColor;
    private int fKeyModifierMask;
    private boolean fIncludeMode;
    private Set fgKeywords;

    public MouseClickListener(CEditor cEditor, ISourceViewer iSourceViewer, IPreferenceStore iPreferenceStore, IAction iAction) {
        this.fEditor = cEditor;
        this.fViewer = iSourceViewer;
        this.fPrefStore = iPreferenceStore;
        this.fOpenDeclAction = iAction;
        this.fgKeywords = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.ALL, (ParserLanguage)ParserLanguage.CPP);
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean bl) {
        if (!this.fActive) {
            return;
        }
        this.repairRepresentation(bl);
        this.fActive = false;
        this.fIncludeMode = false;
    }

    private void repairRepresentation(boolean bl) {
        if (this.fActiveRegion == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.fViewer;
        if (iSourceViewer != null) {
            ITextViewerExtension5 iTextViewerExtension5;
            this.resetCursor(iSourceViewer);
            int n = this.fActiveRegion.getOffset();
            int n2 = this.fActiveRegion.getLength();
            if (!bl && iSourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)iSourceViewer).invalidateTextPresentation(n, n2);
            } else {
                iSourceViewer.invalidateTextPresentation();
            }
            if (iSourceViewer instanceof ITextViewerExtension5) {
                iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
                n = iTextViewerExtension5.modelOffset2WidgetOffset(n);
            } else {
                n -= iSourceViewer.getVisibleRegion().getOffset();
            }
            iTextViewerExtension5 = iSourceViewer.getTextWidget();
            try {
                iTextViewerExtension5.redrawRange(n, n2, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Util.log((Throwable)illegalArgumentException, (String)"Error in CEditor.MouseClickListener.repairRepresentation", (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        this.fActiveRegion = null;
    }

    private void activateCursor(ISourceViewer iSourceViewer) {
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        Display display = styledText.getDisplay();
        if (this.fCursor == null) {
            this.fCursor = new Cursor((Device)display, 21);
        }
        styledText.setCursor(this.fCursor);
    }

    private void resetCursor(ISourceViewer iSourceViewer) {
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            styledText.setCursor(null);
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
    }

    public void install() {
        ISourceViewer iSourceViewer = this.fViewer;
        if (iSourceViewer == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        this.updateColor(iSourceViewer);
        styledText.addKeyListener((KeyListener)this);
        styledText.addMouseListener((MouseListener)this);
        styledText.addMouseMoveListener((MouseMoveListener)this);
        styledText.addFocusListener((FocusListener)this);
        styledText.addPaintListener((PaintListener)this);
        this.updateKeyModifierMask();
        IPreferenceStore iPreferenceStore = this.fPrefStore;
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void uninstall() {
        ISourceViewer iSourceViewer;
        IPreferenceStore iPreferenceStore;
        if (this.fColor != null) {
            this.fColor.dispose();
            this.fColor = null;
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if ((iPreferenceStore = this.fPrefStore) != null) {
            iPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((iSourceViewer = this.fViewer) == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        styledText.removeKeyListener((KeyListener)this);
        styledText.removeMouseListener((MouseListener)this);
        styledText.removeMouseMoveListener((MouseMoveListener)this);
        styledText.removeFocusListener((FocusListener)this);
        styledText.removePaintListener((PaintListener)this);
    }

    private void updateKeyModifierMask() {
        this.fKeyModifierMask = 262144;
    }

    private void updateColor(ISourceViewer iSourceViewer) {
        StyledText styledText;
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        if ((styledText = iSourceViewer.getTextWidget()) == null || styledText.isDisposed()) {
            return;
        }
        Display display = styledText.getDisplay();
        this.fColor = this.createColor(this.fPrefStore, "linkedPositionColor", display);
    }

    private Color createColor(IPreferenceStore iPreferenceStore, String string, Display display) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string) && (rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string)) != null) {
            return new Color((Device)display, rGB);
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (!this.fActive) {
            return;
        }
        if (mouseEvent.stateMask != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        if (mouseEvent.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (!this.fActive) {
            return;
        }
        if (mouseEvent.button != 1) {
            this.deactivate();
            return;
        }
        boolean bl = this.fCursor != null;
        boolean bl2 = this.fIncludeMode;
        this.deactivate();
        if (bl && !bl2 && this.fOpenDeclAction != null) {
            this.fOpenDeclAction.run();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.fActive) {
            this.deactivate();
            return;
        }
        if (keyEvent.keyCode != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        this.fActive = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.fActive) {
            return;
        }
        this.deactivate();
    }

    public void mouseMove(MouseEvent mouseEvent) {
        ISourceViewer iSourceViewer;
        if (mouseEvent.widget instanceof Control && !((Control)mouseEvent.widget).isFocusControl()) {
            this.deactivate();
            return;
        }
        if (!this.fActive) {
            if (mouseEvent.stateMask != this.fKeyModifierMask) {
                return;
            }
            this.fActive = true;
        }
        if ((iSourceViewer = this.fViewer) == null) {
            this.deactivate();
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((mouseEvent.stateMask & 0x80000) != 0 && styledText.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        IRegion iRegion = this.getCurrentTextRegion(iSourceViewer);
        if (iRegion == null || iRegion.getLength() == 0) {
            this.repairRepresentation();
            return;
        }
        this.highlightRegion(iSourceViewer, iRegion);
        this.activateCursor(iSourceViewer);
    }

    IRegion getCurrentTextRegion(ISourceViewer iSourceViewer) {
        int n = this.getCurrentTextOffset(iSourceViewer);
        if (n == -1) {
            return null;
        }
        return this.selectWord(iSourceViewer.getDocument(), n);
    }

    private IRegion selectWord(IDocument iDocument, int n) {
        try {
            char c;
            int n2 = n;
            while (n2 >= 0) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                --n2;
            }
            int n3 = n2;
            n2 = n;
            int n4 = iDocument.getLength();
            while (n2 < n4) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++n2;
            }
            int n5 = n2;
            if (n3 == n5) {
                return new Region(n3, 0);
            }
            String string = null;
            String string2 = iDocument.get(n3, 1);
            string = string2.equals("\n") || string2.equals("\t") || string2.equals(" ") ? iDocument.get(n3 + 1, n5 - n3 - 1) : iDocument.get(n3, n5 - n3);
            if (this.isKeyWord(string)) {
                return null;
            }
            char c2 = string.charAt(0);
            if (c2 == '\"' || c2 == '.' || c2 == '<' || c2 == '>') {
                return null;
            }
            if (string.equals("#include")) {
                int n6 = n5;
                while (!Character.isJavaIdentifierPart(iDocument.getChar(n6))) {
                    ++n6;
                }
                while (n6 < n4) {
                    c = iDocument.getChar(n6);
                    if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                    ++n6;
                }
                int n7 = n6;
                string = iDocument.get(n3, n7 - n3);
                n5 = n7 + 1;
                --n3;
                this.fIncludeMode = true;
            }
            return new Region(n3 + 1, n5 - n3 - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isKeyWord(String string) {
        Iterator iterator = this.fgKeywords.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private int getCurrentTextOffset(ISourceViewer iSourceViewer) {
        try {
            StyledText styledText = iSourceViewer.getTextWidget();
            if (styledText == null || styledText.isDisposed()) {
                return -1;
            }
            Display display = styledText.getDisplay();
            Point point = display.getCursorLocation();
            Point point2 = styledText.toControl(point);
            int n = styledText.getOffsetAtLocation(point2);
            if (iSourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
                return iTextViewerExtension5.widgetOffset2ModelOffset(n);
            }
            return n + iSourceViewer.getVisibleRegion().getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private void highlightRegion(ISourceViewer iSourceViewer, IRegion iRegion) {
        IRegion iRegion2;
        ITextViewerExtension5 iTextViewerExtension5;
        if (iRegion.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iRegion2 = iTextViewerExtension5.modelRange2WidgetRange(iRegion);
            if (iRegion2 == null) {
                return;
            }
            n = iRegion2.getOffset();
            n2 = iRegion2.getLength();
        } else {
            n = iRegion.getOffset() - iSourceViewer.getVisibleRegion().getOffset();
            n2 = iRegion.getLength();
        }
        iTextViewerExtension5 = styledText.getStyleRangeAtOffset(n);
        iRegion2 = this.fColor;
        Color color = iTextViewerExtension5 == null ? styledText.getBackground() : iTextViewerExtension5.background;
        StyleRange styleRange = new StyleRange(n, n2, (Color)iRegion2, color);
        styledText.setStyleRange(styleRange);
        styledText.redrawRange(n, n2, true);
        this.fActiveRegion = iRegion;
    }

    private void repairRepresentation() {
        this.repairRepresentation(false);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.deactivate();
    }

    public void paintControl(PaintEvent paintEvent) {
        IRegion iRegion;
        ITextViewerExtension5 iTextViewerExtension5;
        if (this.fActiveRegion == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.fViewer;
        if (iSourceViewer == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(n, n2));
            if (iRegion == null) {
                return;
            }
            n = iRegion.getOffset();
            n2 = iRegion.getLength();
        } else {
            iTextViewerExtension5 = iSourceViewer.getVisibleRegion();
            if (!this.includes((IRegion)iTextViewerExtension5, this.fActiveRegion)) {
                return;
            }
            n = this.fActiveRegion.getOffset() - iTextViewerExtension5.getOffset();
            n2 = this.fActiveRegion.getLength();
        }
        iTextViewerExtension5 = this.getMinimumLocation(styledText, n, n2);
        iRegion = this.getMaximumLocation(styledText, n, n2);
        int n3 = iTextViewerExtension5.x;
        int n4 = iTextViewerExtension5.x + iRegion.x - iTextViewerExtension5.x - 1;
        int n5 = iTextViewerExtension5.y + styledText.getLineHeight() - 1;
        GC gC = paintEvent.gc;
        if (this.fColor != null && !this.fColor.isDisposed()) {
            gC.setForeground(this.fColor);
        }
        gC.drawLine(n3, n5, n4, n5);
    }

    private boolean includes(IRegion iRegion, IRegion iRegion2) {
        return iRegion2.getOffset() >= iRegion.getOffset() && iRegion2.getOffset() + iRegion2.getLength() <= iRegion.getOffset() + iRegion.getLength();
    }

    private Point getMinimumLocation(StyledText styledText, int n, int n2) {
        Point point = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int n3 = 0;
        while (n3 <= n2) {
            Point point2 = styledText.getLocationAtOffset(n + n3);
            if (point2.x < point.x) {
                point.x = point2.x;
            }
            if (point2.y < point.y) {
                point.y = point2.y;
            }
            ++n3;
        }
        return point;
    }

    private Point getMaximumLocation(StyledText styledText, int n, int n2) {
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int n3 = 0;
        while (n3 <= n2) {
            Point point2 = styledText.getLocationAtOffset(n + n3);
            if (point2.x > point.x) {
                point.x = point2.x;
            }
            if (point2.y > point.y) {
                point.y = point2.y;
            }
            ++n3;
        }
        return point;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ISourceViewer iSourceViewer;
        if (propertyChangeEvent.getProperty().equals("linkedPositionColor") && (iSourceViewer = this.fViewer) != null) {
            this.updateColor(iSourceViewer);
        }
    }
}

