/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class OpenIncludeAction
extends Action {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider iSelectionProvider) {
        super(CUIPlugin.getResourceString("OpenIncludeAction.label"));
        this.setDescription(CUIPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("OpenIncludeAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
        this.fSelectionProvider = iSelectionProvider;
    }

    public void run() {
        ICElement iCElement = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (iCElement == null) {
            return;
        }
        try {
            int n;
            ITranslationUnit iTranslationUnit;
            IScannerInfo iScannerInfo;
            IScannerInfoProvider iScannerInfoProvider;
            IProject iProject;
            IResource iResource = iCElement.getUnderlyingResource();
            ArrayList arrayList = new ArrayList(4);
            if (iResource != null) {
                iProject = iResource.getProject();
                String string = iCElement.getElementName();
                iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
                if (iScannerInfoProvider != null) {
                    iScannerInfo = iScannerInfoProvider.getScannerInformation(iResource);
                    if (iScannerInfo == null) {
                        iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
                    }
                    if (iScannerInfo != null) {
                        iTranslationUnit = iScannerInfo.getIncludePaths();
                        this.findFile((String[])iTranslationUnit, string, arrayList);
                    }
                    if (arrayList.size() == 0) {
                        this.findFile((IContainer)iProject, (IPath)new Path(string), arrayList);
                    }
                }
            }
            if ((n = arrayList.size()) == 0) {
                this.noElementsFound();
                iProject = null;
            } else {
                iProject = n == 1 ? (IPath)arrayList.get(0) : this.chooseFile(arrayList);
            }
            if (iProject != null) {
                iScannerInfoProvider = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)iProject);
                if (iScannerInfoProvider != null) {
                    EditorUtility.openInEditor(iScannerInfoProvider);
                } else {
                    iScannerInfo = iCElement.getCProject();
                    iTranslationUnit = CoreModel.getDefault().createTranslationUnitFrom((ICProject)iScannerInfo, (IPath)iProject);
                    if (iTranslationUnit != null) {
                        EditorUtility.openInEditor(iTranslationUnit);
                    }
                }
            }
        }
        catch (CModelException cModelException) {
            CUIPlugin.getDefault().log(cModelException.getStatus());
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException.getStatus());
        }
    }

    private void noElementsFound() {
        MessageBox messageBox = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        messageBox.setText(CUIPlugin.getResourceString("OpenIncludeAction.error"));
        messageBox.setMessage(CUIPlugin.getResourceString("OpenIncludeAction.error.description"));
        messageBox.open();
    }

    private void findFile(String[] stringArray, String string, ArrayList arrayList) throws CoreException {
        int n = 0;
        while (n < stringArray.length) {
            Path path = new Path(String.valueOf(stringArray[n]) + "/" + string);
            File file = path.toFile();
            if (file.exists()) {
                arrayList.add(path);
            }
            ++n;
        }
    }

    private void findFile(IContainer iContainer, final IPath iPath, final ArrayList arrayList) throws CoreException {
        iContainer.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                if (iResourceProxy.getType() == 1 && iResourceProxy.getName().equalsIgnoreCase(iPath.lastSegment())) {
                    arrayList.add(iResourceProxy.requestResource().getLocation());
                    return false;
                }
                return true;
            }
        }, 0);
    }

    private IPath chooseFile(ArrayList arrayList) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IPath) {
                    IPath iPath = (IPath)object;
                    return String.valueOf(iPath.lastSegment()) + " - " + iPath.toString();
                }
                return super.getText(object);
            }
        };
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider, false, false);
        elementListSelectionDialog.setTitle(CUIPlugin.getResourceString(DIALOG_TITLE));
        elementListSelectionDialog.setMessage(CUIPlugin.getResourceString(DIALOG_MESSAGE));
        elementListSelectionDialog.setElements(arrayList);
        if (elementListSelectionDialog.open() == 0) {
            return (IPath)elementListSelectionDialog.getSelectedElement();
        }
        return null;
    }

    private static ICElement getIncludeStatement(ISelection iSelection) {
        Object e;
        List list;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (list = ((IStructuredSelection)iSelection).toList()).size() == 1 && (e = list.get(0)) instanceof ICElement && ((ICElement)e).getElementType() == 72) {
            return (ICElement)e;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection iSelection) {
        IResource iResource;
        ICElement iCElement = OpenIncludeAction.getIncludeStatement(iSelection);
        return iCElement != null && (iResource = iCElement.getUnderlyingResource()) != null;
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return "org.eclipse.ui.systemExternalEditor";
        }
        return null;
    }
}

