/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchDialogAction
extends Action {
    private static final String PREFIX = "SearchDialogAction.";
    private static final String C_SEARCH_PAGE_ID = "org.eclipse.cdt.ui.CSearchPage";
    private ISelectionProvider fSelectionProvider;
    private ITextEditor fEditor;
    private IWorkbenchWindow fWorkbenchWindow;

    public SearchDialogAction(ISelectionProvider iSelectionProvider, CEditor cEditor) {
        super(CUIPlugin.getResourceString("SearchDialogAction.label"));
        this.setDescription(CUIPlugin.getResourceString("SearchDialogAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("SearchDialogAction.tooltip"));
        if (iSelectionProvider instanceof CContentOutlinePage) {
            this.setImageDescriptor(CPluginImages.DESC_OBJS_CSEARCH);
        }
        this.fSelectionProvider = iSelectionProvider;
        this.fEditor = cEditor;
    }

    public SearchDialogAction(ISelectionProvider iSelectionProvider, IWorkbenchWindow iWorkbenchWindow) {
        super(CUIPlugin.getResourceString("SearchDialogAction.label"));
        this.setDescription(CUIPlugin.getResourceString("SearchDialogAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("SearchDialogAction.tooltip"));
        if (iSelectionProvider instanceof CContentOutlinePage) {
            this.setImageDescriptor(CPluginImages.DESC_OBJS_CSEARCH);
        }
        this.fSelectionProvider = iSelectionProvider;
        this.fWorkbenchWindow = iWorkbenchWindow;
    }

    public void run() {
        ISelection iSelection = this.fSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            String string = ((ITextSelection)iSelection).getText();
            if (string.length() == 0) {
                return;
            }
        } else {
            ICElement iCElement = SearchDialogAction.getElement(iSelection);
            if (iCElement == null) {
                return;
            }
            String string = iCElement.getElementName();
        }
        if (this.fEditor != null) {
            SearchUI.openSearchDialog((IWorkbenchWindow)this.fEditor.getEditorSite().getWorkbenchWindow(), (String)C_SEARCH_PAGE_ID);
        } else if (this.fWorkbenchWindow != null) {
            SearchUI.openSearchDialog((IWorkbenchWindow)this.fWorkbenchWindow, (String)C_SEARCH_PAGE_ID);
        }
    }

    private static ICElement getElement(ISelection iSelection) {
        Object e;
        List list;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (list = ((IStructuredSelection)iSelection).toList()).size() == 1 && (e = list.get(0)) instanceof ICElement) {
            return (ICElement)e;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection iSelection) {
        if (iSelection instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getLength() > 0;
        }
        return SearchDialogAction.getElement(iSelection) != null;
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return "org.eclipse.ui.systemExternalEditor";
        }
        return null;
    }
}

