/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.asm.AsmWordDetector;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.util.CWhitespaceDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class AsmCodeScanner
extends AbstractCScanner {
    private static String[] fgKeywords = new String[]{".set", ".section", ".global", ".file", ".extern", ".macro", ".endm", ".if", ".ifdef", ".ifndef", ".else", ".endif", ".include", ".globl", ".text", ".data", ".rodata", ".common", ".debug", ".ctor", ".dtor", ".ascii", ".asciz", ".byte", ".long", ".size", ".align", ".type"};
    private static String[] fgTypes = new String[]{"char", "double", "float", "int", "long", "short", "signed", "unsigned", "void"};
    private static String[] fgTokenProperties = new String[]{"c_keyword", "c_type", "c_string", "c_single_line_comment", "c_default"};

    public AsmCodeScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        super(iColorManager, iPreferenceStore);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Token token = this.getToken("c_single_line_comment");
        arrayList.add(new EndOfLineRule("#", (IToken)token));
        token = this.getToken("c_string");
        arrayList.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        Token token2 = this.getToken("c_default");
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new CWhitespaceDetector()));
        WordRule wordRule = new WordRule(new AsmWordDetector(false), (IToken)token2){
            private StringBuffer fBuffer = new StringBuffer();

            public IToken evaluate(ICharacterScanner iCharacterScanner) {
                int n = iCharacterScanner.read();
                if (this.fDetector.isWordStart((char)n) && (this.fColumn == -1 || this.fColumn == iCharacterScanner.getColumn() - 1)) {
                    this.fBuffer.setLength(0);
                    do {
                        this.fBuffer.append((char)n);
                    } while (this.fDetector.isWordPart((char)(n = iCharacterScanner.read())));
                    if (n != 58) {
                        this.unreadBuffer(iCharacterScanner);
                        return this.fDefaultToken;
                    }
                    this.fBuffer.append((char)n);
                    IToken iToken = (IToken)this.fWords.get(":");
                    if (iToken != null) {
                        return iToken;
                    }
                    return this.fDefaultToken;
                }
                iCharacterScanner.unread();
                return Token.UNDEFINED;
            }

            public void addWord(String string, IToken iToken) {
                this.fWords.put(string, iToken);
            }

            protected void unreadBuffer(ICharacterScanner iCharacterScanner) {
                int n = this.fBuffer.length() - 1;
                while (n >= 0) {
                    iCharacterScanner.unread();
                    --n;
                }
            }
        };
        token = this.getToken("c_type");
        wordRule.addWord(":", (IToken)token);
        arrayList.add(wordRule);
        WordRule wordRule2 = new WordRule((IWordDetector)new AsmWordDetector('.'), (IToken)token2);
        int n = 0;
        while (n < fgKeywords.length) {
            wordRule2.addWord(fgKeywords[n], (IToken)token);
            ++n;
        }
        n = 0;
        while (n < fgTypes.length) {
            wordRule2.addWord(fgTypes[n], (IToken)token);
            ++n;
        }
        arrayList.add(wordRule2);
        token = this.getToken("c_keyword");
        WordPatternRule wordPatternRule = new WordPatternRule((IWordDetector)new AsmWordDetector('%', '\u0000'), "%", null, (IToken)token);
        arrayList.add(wordPatternRule);
        this.setDefaultReturnToken((IToken)this.getToken("c_default"));
        return arrayList;
    }

    public void setRules(IRule[] iRuleArray) {
        super.setRules(iRuleArray);
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return super.affectsBehavior(propertyChangeEvent);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (super.affectsBehavior(propertyChangeEvent)) {
            super.adaptToPreferenceChange(propertyChangeEvent);
        }
    }
}

