/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.asm.AsmSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AsmTextEditor
extends AbstractDecoratedTextEditor {
    public AsmTextEditor() {
        this.initializeEditor();
    }

    protected void initializeEditor() {
        AsmTextTools asmTextTools = CUIPlugin.getDefault().getAsmTextTools();
        this.setSourceViewerConfiguration(new AsmSourceViewerConfiguration(asmTextTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setEditorContextMenuId("#ASMEditorContext");
        this.setRulerContextMenuId("#ASMEditorRulerContext");
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        Shell shell = this.getSite().getShell();
        SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath == null) {
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile iFile = iWorkspace.getRoot().getFile(iPath);
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((IEditorInput)fileEditorInput){
            private final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                AsmTextEditor.this.getDocumentProvider().saveDocument(iProgressMonitor, (Object)this.val$newInput, AsmTextEditor.this.getDocumentProvider().getDocument((Object)AsmTextEditor.this.getEditorInput()), true);
            }
        };
        boolean bl = false;
        try {
            try {
                this.getDocumentProvider().aboutToChange((Object)fileEditorInput);
                new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = CEditorMessages.getString("CEditor.error.saving.title");
                String string2 = MessageFormat.format(CEditorMessages.getString("CEditor.error.saving.message"), invocationTargetException.getTargetException().getMessage());
                MessageDialog.openError((Shell)shell, (String)string, (String)string2);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.getDocumentProvider().changed((Object)fileEditorInput);
            if (bl) {
                this.setInput((IEditorInput)fileEditorInput);
            }
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.getDocumentProvider().changed((Object)fileEditorInput);
        if (bl) {
            this.setInput((IEditorInput)fileEditorInput);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        AsmTextTools asmTextTools = CUIPlugin.getDefault().getAsmTextTools();
        return (bl |= asmTextTools.affectsBehavior(propertyChangeEvent)) ? bl : super.affectsTextPresentation(propertyChangeEvent);
    }

    protected void createActions() {
        super.createActions();
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        this.addAction(iMenuManager, "group.edit", "ShiftRight");
        this.addAction(iMenuManager, "group.edit", "ShiftLeft");
    }
}

