/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.filters.FilterDescriptor;
import org.eclipse.cdt.internal.ui.filters.FilterMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class CustomFiltersDialog
extends SelectionDialog {
    private static final String SEPARATOR = ",";
    private String fViewId;
    private boolean fEnablePatterns;
    private String[] fPatterns;
    private String[] fEnabledFilterIds;
    private FilterDescriptor[] fBuiltInFilters;
    private CheckboxTableViewer fCheckBoxList;
    private Button fEnableUserDefinedPatterns;
    private Text fUserDefinedPatterns;
    private Stack fFilterDescriptorChangeHistory;

    public CustomFiltersDialog(Shell shell, String string, boolean bl, String[] stringArray, String[] stringArray2) {
        super(shell);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)stringArray);
        Assert.isNotNull((Object)stringArray2);
        this.fViewId = string;
        this.fPatterns = stringArray;
        this.fEnablePatterns = bl;
        this.fEnabledFilterIds = stringArray2;
        this.fBuiltInFilters = FilterDescriptor.getFilterDescriptors(this.fViewId);
        this.fFilterDescriptorChangeHistory = new Stack();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        this.setTitle(FilterMessages.getString("CustomFiltersDialog.title"));
        this.setMessage(FilterMessages.getString("CustomFiltersDialog.filterList.label"));
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.cdt.ui.open_custom_filters_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Composite composite3 = composite2;
        this.fEnableUserDefinedPatterns = new Button(composite3, 32);
        this.fEnableUserDefinedPatterns.setText(FilterMessages.getString("CustomFiltersDialog.enableUserDefinedPattern"));
        this.fUserDefinedPatterns = new Text(composite3, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(59);
        this.fUserDefinedPatterns.setLayoutData((Object)gridData);
        String string = CustomFiltersDialog.convertToString(this.fPatterns, SEPARATOR);
        this.fUserDefinedPatterns.setText(string);
        final Label label = new Label(composite3, 16384);
        label.setText(FilterMessages.getString("CustomFiltersDialog.patternInfo"));
        this.fEnableUserDefinedPatterns.setSelection(this.fEnablePatterns);
        this.fUserDefinedPatterns.setEnabled(this.fEnablePatterns);
        label.setEnabled(this.fEnablePatterns);
        this.fEnableUserDefinedPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = CustomFiltersDialog.this.fEnableUserDefinedPatterns.getSelection();
                CustomFiltersDialog.this.fUserDefinedPatterns.setEnabled(bl);
                label.setEnabled(CustomFiltersDialog.this.fEnableUserDefinedPatterns.getSelection());
                if (bl) {
                    CustomFiltersDialog.this.fUserDefinedPatterns.setFocus();
                }
            }
        });
        if (this.fBuiltInFilters.length > 0) {
            this.createCheckBoxList(composite3);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createCheckBoxList(Composite composite) {
        new Label(composite, 0);
        Label label = new Label(composite, 16384);
        label.setText(FilterMessages.getString("CustomFiltersDialog.filterList.label"));
        this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.fCheckBoxList.getTable().getItemHeight() * 10;
        this.fCheckBoxList.getTable().setLayoutData((Object)gridData);
        this.fCheckBoxList.setLabelProvider((IBaseLabelProvider)this.createLabelPrivder());
        this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fCheckBoxList.setInput((Object)this.fBuiltInFilters);
        this.setInitialSelections(this.getEnabledFilterDescriptors());
        List list = this.getInitialElementSelections();
        if (list != null && !list.isEmpty()) {
            this.checkInitialSelections();
        }
        label = new Label(composite, 16384);
        label.setText(FilterMessages.getString("CustomFiltersDialog.description.label"));
        final Text text = new Text(composite, 19018);
        gridData = new GridData(768);
        gridData.heightHint = this.convertHeightInCharsToPixels(3);
        text.setLayoutData((Object)gridData);
        this.fCheckBoxList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof FilterDescriptor) {
                    text.setText(((FilterDescriptor)object).getDescription());
                }
            }
        });
        this.fCheckBoxList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                if (object instanceof FilterDescriptor) {
                    if (CustomFiltersDialog.this.fFilterDescriptorChangeHistory.contains(object)) {
                        CustomFiltersDialog.this.fFilterDescriptorChangeHistory.remove(object);
                    }
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(object);
                }
            }
        });
        this.addSelectionButtons(composite);
    }

    private void addSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(640);
        gridData.grabExcessHorizontalSpace = true;
        composite.setData((Object)gridData);
        String string = FilterMessages.getString("CustomFiltersDialog.SelectAllButton.label");
        Button button = this.createButton(composite2, 18, string, false);
        SWTUtil.setButtonDimensionHint(button);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomFiltersDialog.this.fCheckBoxList.setAllChecked(true);
                CustomFiltersDialog.this.fFilterDescriptorChangeHistory.clear();
                int n = 0;
                while (n < CustomFiltersDialog.this.fBuiltInFilters.length) {
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(CustomFiltersDialog.this.fBuiltInFilters[n]);
                    ++n;
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        string = FilterMessages.getString("CustomFiltersDialog.DeselectAllButton.label");
        Button button2 = this.createButton(composite2, 19, string, false);
        SWTUtil.setButtonDimensionHint(button2);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomFiltersDialog.this.fCheckBoxList.setAllChecked(false);
                CustomFiltersDialog.this.fFilterDescriptorChangeHistory.clear();
                int n = 0;
                while (n < CustomFiltersDialog.this.fBuiltInFilters.length) {
                    CustomFiltersDialog.this.fFilterDescriptorChangeHistory.push(CustomFiltersDialog.this.fBuiltInFilters[n]);
                    ++n;
                }
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void checkInitialSelections() {
        Iterator iterator = this.getInitialElementSelections().iterator();
        while (iterator.hasNext()) {
            this.fCheckBoxList.setChecked(iterator.next(), true);
        }
    }

    protected void okPressed() {
        if (this.fBuiltInFilters != null) {
            ArrayList<FilterDescriptor> arrayList = new ArrayList<FilterDescriptor>();
            int n = 0;
            while (n < this.fBuiltInFilters.length) {
                if (this.fCheckBoxList.getChecked((Object)this.fBuiltInFilters[n])) {
                    arrayList.add(this.fBuiltInFilters[n]);
                }
                ++n;
            }
            this.setResult(arrayList);
        }
        super.okPressed();
    }

    private ILabelProvider createLabelPrivder() {
        return new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                if (object instanceof FilterDescriptor) {
                    return ((FilterDescriptor)object).getName();
                }
                return null;
            }
        };
    }

    protected void setResult(List list) {
        super.setResult(list);
        if (this.fUserDefinedPatterns.getText().length() > 0) {
            this.fEnablePatterns = this.fEnableUserDefinedPatterns.getSelection();
            this.fPatterns = CustomFiltersDialog.convertFromString(this.fUserDefinedPatterns.getText(), SEPARATOR);
        } else {
            this.fEnablePatterns = false;
            this.fPatterns = new String[0];
        }
    }

    public String[] getUserDefinedPatterns() {
        return this.fPatterns;
    }

    public String[] getEnabledFilterIds() {
        Object[] objectArray = this.getResult();
        HashSet<String> hashSet = new HashSet<String>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(((FilterDescriptor)objectArray[n]).getId());
            ++n;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public boolean areUserDefinedPatternsEnabled() {
        return this.fEnablePatterns;
    }

    public Stack getFilterDescriptorChangeHistory() {
        return this.fFilterDescriptorChangeHistory;
    }

    private FilterDescriptor[] getEnabledFilterDescriptors() {
        FilterDescriptor[] filterDescriptorArray = this.fBuiltInFilters;
        ArrayList<FilterDescriptor> arrayList = new ArrayList<FilterDescriptor>(filterDescriptorArray.length);
        List<String> list = Arrays.asList(this.fEnabledFilterIds);
        int n = 0;
        while (n < filterDescriptorArray.length) {
            String string = filterDescriptorArray[n].getId();
            if (list.contains(string)) {
                arrayList.add(filterDescriptorArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new FilterDescriptor[arrayList.size()]);
    }

    public static String[] convertFromString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public static String convertToString(String[] stringArray, String string) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        if (n <= 0) {
            return "";
        }
        stringBuffer.append(stringArray[0]);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[n2++]);
        }
        return stringBuffer.toString();
    }
}

